/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.LongMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableIntMatrix;
import ch.javasoft.smx.iface.ReadableIntRationalMatrix;
import ch.javasoft.smx.iface.ReadableLongMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableDoubleMatrix;
import ch.javasoft.smx.iface.WritableIntMatrix;
import ch.javasoft.smx.iface.WritableIntRationalMatrix;
import ch.javasoft.smx.iface.WritableLongMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultIntMatrix;
import ch.javasoft.smx.impl.DefaultIntRationalMatrix;
import ch.javasoft.smx.impl.DefaultLongMatrix;
import ch.javasoft.smx.util.DimensionCheck;
import ch.javasoft.smx.util.SmxIntegerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarOps {
    public static <N extends Number> DoubleMatrix add(ReadableDoubleMatrix src, double value) {
        int rows = src.getRowCount();
        DoubleMatrix res = src.toDoubleMatrix(true);
        int row = 0;
        while (row < rows) {
            res.multiplyRow(rows, value);
            ++row;
        }
        return res;
    }

    public static <N extends Number> IntMatrix add(ReadableIntMatrix src, int value) {
        int rows = src.getRowCount();
        IntMatrix res = src.toIntMatrix(true);
        int row = 0;
        while (row < rows) {
            res.multiplyRow(rows, value);
            ++row;
        }
        return res;
    }

    public static <N extends Number> LongMatrix add(ReadableLongMatrix src, long value) {
        int rows = src.getRowCount();
        LongMatrix res = src.toLongMatrix(true);
        int row = 0;
        while (row < rows) {
            res.multiplyRow(rows, value);
            ++row;
        }
        return res;
    }

    public static <N extends Number> ReadableMatrix<N> subtractGeneric(ReadableMatrix<N> src, N value) {
        return ScalarOps.addGeneric(src, src.getNumberOperations().negate(value));
    }

    public static <N extends Number> ReadableMatrix<N> addGeneric(ReadableMatrix<N> src, N value) {
        NumberOperations nops = src.getNumberOperations();
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        WritableMatrix res = src.newInstance(rows, cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Object sum = nops.add(src.getNumberValueAt(row, col), value);
                res.setValueAt(row, col, nops.reduce(sum));
                ++col;
            }
            ++row;
        }
        return res.toReadableMatrix(false);
    }

    public static IntMatrix scale(ReadableIntMatrix src, int factor) {
        DefaultIntMatrix dst = new DefaultIntMatrix(src.getRowCount(), src.getColumnCount());
        ScalarOps.scale(src, dst, factor);
        return dst;
    }

    public static void scale(ReadableIntMatrix src, WritableIntMatrix dst, int factor) {
        DimensionCheck.checkEqualDimensions(src, dst);
        int rows = src.getRowCount();
        int row = 0;
        while (row < rows) {
            ScalarOps.scaleRowInternal(src, dst, row, factor);
            ++row;
        }
    }

    public static LongMatrix scale(ReadableLongMatrix src, long factor) {
        DefaultLongMatrix dst = new DefaultLongMatrix(src.getRowCount(), src.getColumnCount());
        ScalarOps.scale(src, dst, factor);
        return dst;
    }

    public static void scale(ReadableLongMatrix src, WritableLongMatrix dst, long factor) {
        DimensionCheck.checkEqualDimensions(src, dst);
        int rows = src.getRowCount();
        int row = 0;
        while (row < rows) {
            ScalarOps.scaleRowInternal(src, dst, row, factor);
            ++row;
        }
    }

    public static <N extends Number> ReadableMatrix<N> scaleGeneric(ReadableMatrix<N> src, N factor) {
        NumberOperations nops = src.getNumberOperations();
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        WritableMatrix dst = src.newInstance(rows, cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Object val = nops.multiply(factor, src.getNumberValueAt(row, col));
                dst.setValueAt(row, col, nops.reduce(val));
                ++col;
            }
            ++row;
        }
        return dst.toReadableMatrix(false);
    }

    public static IntMatrix scaleRow(ReadableIntMatrix src, int row, int factor) {
        DefaultIntMatrix dst = new DefaultIntMatrix(src.getRowCount(), src.getColumnCount());
        ScalarOps.scaleRowInternal(src, dst, row, factor);
        return dst;
    }

    public static void scaleRow(ReadableIntMatrix src, WritableIntMatrix dst, int row, int factor) {
        DimensionCheck.checkEqualRowCount(src, dst);
        ScalarOps.scaleRowInternal(src, dst, row, factor);
    }

    private static void scaleRowInternal(ReadableIntMatrix src, WritableIntMatrix dst, int row, int factor) {
        int cols = src.getColumnCount();
        int col = 0;
        while (col < cols) {
            long scaled = src.getIntValueAt(row, col) * factor;
            dst.setValueAt(row, col, SmxIntegerUtil.checkIntegerRange(scaled));
            ++col;
        }
    }

    private static void scaleRowInternal(ReadableLongMatrix src, WritableLongMatrix dst, int row, long factor) {
        int cols = src.getColumnCount();
        int col = 0;
        while (col < cols) {
            long scaled = src.getLongValueAt(row, col) * factor;
            dst.setValueAt(row, col, scaled);
            ++col;
        }
    }

    public static IntRationalMatrix scale(ReadableIntRationalMatrix src, int mulFactor, int divFactor) {
        DefaultIntRationalMatrix dst = new DefaultIntRationalMatrix(src.getRowCount(), src.getColumnCount());
        ScalarOps.scale(src, dst, mulFactor, divFactor);
        return dst;
    }

    public static void scale(ReadableIntRationalMatrix src, WritableIntRationalMatrix dst, int mulFactor, int divFactor) {
        DimensionCheck.checkEqualDimensions(src, dst);
        int rows = src.getRowCount();
        int row = 0;
        while (row < rows) {
            ScalarOps.scaleRowInternal(src, dst, row, mulFactor, divFactor);
            ++row;
        }
    }

    public static IntRationalMatrix scaleRow(ReadableIntRationalMatrix src, int row, int mulFactor, int divFactor) {
        DefaultIntRationalMatrix dst = new DefaultIntRationalMatrix(src.getRowCount(), src.getColumnCount());
        ScalarOps.scaleRowInternal(src, dst, row, mulFactor, divFactor);
        return dst;
    }

    public static void scaleRow(ReadableIntRationalMatrix src, WritableIntRationalMatrix dst, int row, int mulFactor, int divFactor) {
        DimensionCheck.checkEqualRowCount(src, dst);
        ScalarOps.scaleRowInternal(src, dst, row, mulFactor, divFactor);
    }

    private static void scaleRowInternal(ReadableIntRationalMatrix src, WritableIntRationalMatrix dst, int row, int mulFactor, int divFactor) {
        int cols = src.getColumnCount();
        int col = 0;
        while (col < cols) {
            SmxIntegerUtil.multiply(src.getIntNumeratorAt(row, col), src.getIntDenominatorAt(row, col), mulFactor, divFactor, dst, row, col);
            ++col;
        }
    }

    public static DoubleMatrix scale(ReadableDoubleMatrix src, double factor) {
        DefaultDoubleMatrix dst = new DefaultDoubleMatrix(src.getRowCount(), src.getColumnCount());
        ScalarOps.scale(src, dst, factor);
        return dst;
    }

    public static void scale(ReadableDoubleMatrix src, WritableDoubleMatrix dst, double factor) {
        DimensionCheck.checkEqualDimensions(src, dst);
        int rows = src.getRowCount();
        int row = 0;
        while (row < rows) {
            ScalarOps.scaleRowInternal(src, dst, row, factor);
            ++row;
        }
    }

    public static DoubleMatrix scaleRow(ReadableDoubleMatrix src, int row, double factor) {
        DefaultDoubleMatrix dst = new DefaultDoubleMatrix(src.getRowCount(), src.getColumnCount());
        ScalarOps.scaleRowInternal(src, dst, row, factor);
        return dst;
    }

    public static void scaleRow(ReadableDoubleMatrix src, WritableDoubleMatrix dst, int row, double factor) {
        DimensionCheck.checkEqualRowCount(src, dst);
        ScalarOps.scaleRowInternal(src, dst, row, factor);
    }

    private static void scaleRowInternal(ReadableDoubleMatrix src, WritableDoubleMatrix dst, int row, double factor) {
        int cols = src.getColumnCount();
        int col = 0;
        while (col < cols) {
            dst.setValueAt(row, col, factor * src.getDoubleValueAt(row, col));
            ++col;
        }
    }

    private ScalarOps() {
    }
}

