/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableIntMatrix;
import ch.javasoft.smx.iface.ReadableIntRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableDoubleMatrix;
import ch.javasoft.smx.iface.WritableIntMatrix;
import ch.javasoft.smx.iface.WritableIntRationalMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultIntMatrix;
import ch.javasoft.smx.impl.DefaultIntRationalMatrix;
import ch.javasoft.smx.util.DimensionCheck;
import ch.javasoft.smx.util.SmxIntegerUtil;
import ch.javasoft.util.numeric.IntegerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mul {
    public static IntMatrix multiply(ReadableIntMatrix srcA, ReadableIntMatrix srcB) {
        DefaultIntMatrix dst = new DefaultIntMatrix(srcA.getRowCount(), srcB.getColumnCount());
        Mul.multiply(srcA, srcB, dst);
        return dst;
    }

    public static void multiply(ReadableIntMatrix srcA, ReadableIntMatrix srcB, WritableIntMatrix dst) {
        boolean srcAIsSrcB;
        DimensionCheck.checkMulDimensions(srcA, srcB, dst);
        boolean bl = srcAIsSrcB = srcA == srcB;
        if (srcA == dst) {
            srcA = (ReadableIntMatrix)srcA.clone();
        }
        if (srcB == dst) {
            srcB = srcAIsSrcB ? srcA : (ReadableIntMatrix)srcB.clone();
        }
        int rows = dst.getRowCount();
        int cols = dst.getColumnCount();
        int cnt = srcA.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                long val = 0L;
                int ii = 0;
                while (ii < cnt) {
                    long summandA = (long)srcA.getIntValueAt(row, ii) * (long)srcB.getIntValueAt(ii, col);
                    long summandB = val;
                    val = summandA + summandB;
                    SmxIntegerUtil.checkLongRangeAfterAddition(summandA, summandB, val);
                    ++ii;
                }
                SmxIntegerUtil.checkIntegerRange(val);
                dst.setValueAt(row, col, (int)val);
                ++col;
            }
            ++row;
        }
    }

    public static IntRationalMatrix multiply(ReadableIntRationalMatrix srcA, ReadableIntRationalMatrix srcB) {
        DefaultIntRationalMatrix dst = new DefaultIntRationalMatrix(srcA.getRowCount(), srcA.getColumnCount());
        Mul.multiply(srcA, srcB, dst);
        return dst;
    }

    public static void multiply(ReadableIntRationalMatrix srcA, ReadableIntRationalMatrix srcB, WritableIntRationalMatrix dst) {
        boolean srcAIsSrcB;
        DimensionCheck.checkMulDimensions(srcA, srcB, dst);
        boolean bl = srcAIsSrcB = srcA == srcB;
        if (srcA == dst) {
            srcA = (ReadableIntRationalMatrix)srcA.clone();
        }
        if (srcB == dst) {
            srcB = srcAIsSrcB ? srcA : (ReadableIntRationalMatrix)srcB.clone();
        }
        int rows = srcA.getRowCount();
        int cols = srcA.getColumnCount();
        int cnt = srcA.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                long dividend = 0L;
                long divisor = 1L;
                int ii = 0;
                while (ii < cnt) {
                    long dividendA = srcA.getIntNumeratorAt(row, ii);
                    long dividendB = srcB.getIntNumeratorAt(ii, col);
                    long divisorA = srcA.getIntDenominatorAt(row, ii);
                    long divisorB = srcB.getIntDenominatorAt(ii, col);
                    long dividendP = dividendA * dividendB;
                    long divisorP = divisorA * divisorB;
                    long newDividendA = dividendP * divisor;
                    long newDividendB = dividend * divisorP;
                    SmxIntegerUtil.checkLongRangeAfterMultiplication(dividendP, divisor, newDividendA);
                    SmxIntegerUtil.checkLongRangeAfterMultiplication(dividend, divisorP, newDividendB);
                    long newDivisor = divisor * divisorP;
                    SmxIntegerUtil.checkLongRangeAfterMultiplication(divisor, divisorP, newDivisor);
                    long newDividend = newDividendA + newDividendB;
                    SmxIntegerUtil.checkLongRangeAfterAddition(newDividendA, newDividendB, newDividend);
                    long gcd = IntegerUtil.gcd(newDividend, newDivisor);
                    dividend = newDividend / gcd;
                    divisor = newDivisor / gcd;
                    ++ii;
                }
                SmxIntegerUtil.checkIntegerRange(dividend);
                SmxIntegerUtil.checkIntegerRange(divisor);
                dst.setValueAt(row, col, (int)dividend, (int)divisor);
                ++col;
            }
            ++row;
        }
    }

    public static DoubleMatrix multiply(ReadableDoubleMatrix srcA, ReadableDoubleMatrix srcB) {
        DefaultDoubleMatrix dst = new DefaultDoubleMatrix(srcA.getRowCount(), srcB.getColumnCount());
        Mul.multiply(srcA, srcB, dst);
        return dst;
    }

    public static void multiply(ReadableDoubleMatrix srcA, ReadableDoubleMatrix srcB, WritableDoubleMatrix dst) {
        boolean srcAIsSrcB;
        DimensionCheck.checkMulDimensions(srcA, srcB, dst);
        boolean bl = srcAIsSrcB = srcA == srcB;
        if (srcA == dst) {
            srcA = (ReadableDoubleMatrix)srcA.clone();
        }
        if (srcB == dst) {
            srcB = srcAIsSrcB ? srcA : (ReadableDoubleMatrix)srcB.clone();
        }
        int rows = dst.getRowCount();
        int cols = dst.getColumnCount();
        int cnt = srcA.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                double val = 0.0;
                int ii = 0;
                while (ii < cnt) {
                    val += srcA.getDoubleValueAt(row, ii) * srcB.getDoubleValueAt(ii, col);
                    ++ii;
                }
                dst.setValueAt(row, col, val);
                ++col;
            }
            ++row;
        }
    }

    public static <N extends Number> ReadableMatrix<N> multiplyGeneric(ReadableMatrix<N> srcA, ReadableMatrix<N> srcB) {
        WritableMatrix<N> dst = srcA.newInstance(srcA.getRowCount(), srcB.getColumnCount());
        Mul.multiplyGeneric(srcA, srcB, dst);
        return dst.toReadableMatrix(false);
    }

    public static <N extends Number> void multiplyGeneric(ReadableMatrix<N> srcA, ReadableMatrix<N> srcB, WritableMatrix<N> dst) {
        boolean srcAIsSrcB;
        DimensionCheck.checkMulDimensions(srcA, srcB, dst);
        NumberOperations numberOps = srcA.getNumberOperations();
        boolean bl = srcAIsSrcB = srcA == srcB;
        if (srcA == dst) {
            srcA = srcA.clone();
        }
        if (srcB == dst) {
            srcB = srcAIsSrcB ? srcA : srcB.clone();
        }
        int rows = dst.getRowCount();
        int cols = dst.getColumnCount();
        int cnt = srcA.getColumnCount();
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                Object val = numberOps.zero();
                int ii = 0;
                while (ii < cnt) {
                    Object prod = numberOps.multiply(srcA.getNumberValueAt(row, ii), srcB.getNumberValueAt(ii, col));
                    val = numberOps.add(val, prod);
                    ++ii;
                }
                val = numberOps.reduce(val);
                dst.setValueAt(row, col, val);
                ++col;
            }
            ++row;
        }
    }

    private Mul() {
    }
}

