/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.LongRationalMatrix;
import ch.javasoft.smx.iface.ReadableIntRationalMatrix;
import ch.javasoft.smx.impl.AbstractDoubleMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.util.SmxIntegerUtil;
import ch.javasoft.util.numeric.IntegerUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Arrays;

public class DefaultIntRationalMatrix
implements IntRationalMatrix {
    private static final String NL = System.getProperty("line.separator");
    private int mColumnCount;
    private int[] mNumerators;
    private int[] mDenominators;

    public DefaultIntRationalMatrix(int rowCount, int columnCount) {
        this(new int[rowCount * columnCount], null, rowCount, columnCount);
    }

    public DefaultIntRationalMatrix(int[] numerators, int[] denominators, int rowCount, int columnCount) {
        this(numerators, denominators, rowCount, columnCount, true);
    }

    private DefaultIntRationalMatrix(int[] numerators, int[] denominators, int rowCount, int columnCount, boolean checkDenominators) {
        if (denominators == null) {
            denominators = DefaultIntRationalMatrix.getOnes(numerators.length);
        } else if (checkDenominators) {
            int ii = 0;
            while (ii < denominators.length) {
                if (denominators[ii] <= 0) {
                    throw new IllegalArgumentException("denominator values must be > 0, but value " + ii + " is " + denominators[ii]);
                }
                ++ii;
            }
        }
        if (numerators.length != denominators.length) {
            throw new IllegalArgumentException("number of numerators not equal to number of denominators: " + numerators.length + " != " + denominators.length);
        }
        if (rowCount == -1) {
            rowCount = numerators.length / columnCount;
        }
        if (columnCount == -1) {
            columnCount = numerators.length / rowCount;
        }
        if (rowCount < 0 || columnCount < 0 || rowCount * columnCount != numerators.length) {
            throw new IllegalArgumentException("rowCount (" + rowCount + ") * columnCount (" + columnCount + ") != number of values (" + numerators.length + ")");
        }
        this.mNumerators = numerators;
        this.mDenominators = denominators;
        this.mColumnCount = columnCount;
    }

    public DefaultIntRationalMatrix(ReadableIntRationalMatrix mx) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        this.mNumerators = new int[rows * cols];
        this.mDenominators = new int[rows * cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                this.mNumerators[row * cols + col] = mx.getIntNumeratorAt(row, col);
                this.mDenominators[row * cols + col] = mx.getIntDenominatorAt(row, col);
                ++col;
            }
            ++row;
        }
        this.mColumnCount = cols;
    }

    public static DefaultIntRationalMatrix diag(int[] numerators, int[] denominators) {
        if (numerators.length != denominators.length) {
            throw new IllegalArgumentException("numerator and denominator length missmatch");
        }
        int len = numerators.length;
        DefaultIntRationalMatrix mx = new DefaultIntRationalMatrix(new int[len * len], null, len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, numerators[ii], denominators[ii]);
            ++ii;
        }
        return mx;
    }

    public static DefaultIntRationalMatrix diag(int numerator, int denominator, int len) {
        DefaultIntRationalMatrix mx = new DefaultIntRationalMatrix(new int[len * len], null, len, len);
        int ii = 0;
        while (ii < len) {
            mx.setValueAt(ii, ii, numerator, denominator);
            ++ii;
        }
        return mx;
    }

    public static DefaultIntRationalMatrix identity(int len) {
        return DefaultIntRationalMatrix.diag(1, 1, len);
    }

    public NumberOperations getNumberOperations() {
        throw new RuntimeException("not implemented");
    }

    public MatrixOperations getMatrixOperations() {
        throw new RuntimeException("not implemented");
    }

    public int getIntNumeratorAt(int row, int col) {
        return this.mNumerators[row * this.mColumnCount + col];
    }

    public int getIntDenominatorAt(int row, int col) {
        return this.mDenominators[row * this.mColumnCount + col];
    }

    public int getSignumAt(int row, int col) {
        int num = this.getIntNumeratorAt(row, col);
        int den = this.getIntDenominatorAt(row, col);
        return num == 0 ? 0 : (num < 0 == den < 0 ? 1 : -1);
    }

    public long getLongNumeratorAt(int row, int col) {
        return this.getIntNumeratorAt(row, col);
    }

    public long getLongDenominatorAt(int row, int col) {
        return this.getIntDenominatorAt(row, col);
    }

    public BigInteger getBigIntegerNumeratorAt(int row, int col) {
        return BigInteger.valueOf(this.getIntNumeratorAt(row, col));
    }

    public BigInteger getBigIntegerDenominatorAt(int row, int col) {
        return BigInteger.valueOf(this.getIntDenominatorAt(row, col));
    }

    public double getDoubleValueAt(int row, int col) {
        return (double)this.getIntNumeratorAt(row, col) / (double)this.getIntDenominatorAt(row, col);
    }

    public BigFraction getBigFractionValueAt(int row, int col) {
        return new BigFraction(this.getBigIntegerNumeratorAt(row, col), this.getBigIntegerDenominatorAt(row, col));
    }

    public int getRowCount() {
        return this.mNumerators.length / this.mColumnCount;
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public void setValueAt(int row, int col, int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("div by 0");
        }
        if (numerator == 0) {
            denominator = 1;
        } else if (denominator < 0) {
            numerator = -numerator;
            denominator = -denominator;
        }
        int index = row * this.mColumnCount + col;
        this.mNumerators[index] = numerator;
        this.mDenominators[index] = denominator;
    }

    public void setValueAt(int row, int col, int value) {
        this.setValueAt(row, col, value, 1);
    }

    public void swapRows(int rowA, int rowB) {
        if (rowA == rowB) {
            return;
        }
        int[] tmpRow = new int[this.mColumnCount];
        System.arraycopy(this.mNumerators, rowA * this.mColumnCount, tmpRow, 0, this.mColumnCount);
        System.arraycopy(this.mNumerators, rowB * this.mColumnCount, this.mNumerators, rowA * this.mColumnCount, this.mColumnCount);
        System.arraycopy(tmpRow, 0, this.mNumerators, rowB * this.mColumnCount, this.mColumnCount);
        System.arraycopy(this.mDenominators, rowA * this.mColumnCount, tmpRow, 0, this.mColumnCount);
        System.arraycopy(this.mDenominators, rowB * this.mColumnCount, this.mDenominators, rowA * this.mColumnCount, this.mColumnCount);
        System.arraycopy(tmpRow, 0, this.mDenominators, rowB * this.mColumnCount, this.mColumnCount);
    }

    public void swapColumns(int colA, int colB) {
        if (colA != colB) {
            int rows = this.getRowCount();
            int row = 0;
            while (row < rows) {
                int tmpNumerator = this.getIntNumeratorAt(row, colA);
                int tmpDenominator = this.getIntDenominatorAt(row, colA);
                this.setValueAt(row, colA, this.getIntNumeratorAt(row, colB), this.getIntDenominatorAt(row, colB));
                this.setValueAt(row, colB, tmpNumerator, tmpDenominator);
                ++row;
            }
        }
    }

    public Number getNumberValueAt(int row, int col) {
        return this.getDoubleValueAt(row, col);
    }

    public void setValueAt(int row, int col, Number value) {
        throw new RuntimeException("not implemented");
    }

    public String toString() {
        return DefaultIntRationalMatrix.toString(this);
    }

    public void writeTo(Writer writer) {
        DefaultIntRationalMatrix.writeTo(writer, (ReadableIntRationalMatrix)this);
    }

    public void writeTo(OutputStream out) {
        DefaultIntRationalMatrix.writeTo(out, (ReadableIntRationalMatrix)this);
    }

    public static String toString(ReadableIntRationalMatrix mx) {
        return DefaultIntRationalMatrix.toString(mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(Writer writer, ReadableIntRationalMatrix mx) {
        DefaultIntRationalMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public static void writeTo(OutputStream out, ReadableIntRationalMatrix mx) {
        DefaultIntRationalMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{", " }", " [", "]", "", "", "", ", ");
    }

    public String toMultilineString() {
        return DefaultIntRationalMatrix.toMultilineString(this);
    }

    public void writeToMultiline(Writer writer) {
        DefaultIntRationalMatrix.writeToMultiline(writer, (ReadableIntRationalMatrix)this);
    }

    public void writeToMultiline(OutputStream out) {
        DefaultIntRationalMatrix.writeToMultiline(out, (ReadableIntRationalMatrix)this);
    }

    public static String toMultilineString(ReadableIntRationalMatrix mx) {
        return DefaultIntRationalMatrix.toString(mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(Writer writer, ReadableIntRationalMatrix mx) {
        DefaultIntRationalMatrix.writeTo(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer), mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    public static void writeToMultiline(OutputStream out, ReadableIntRationalMatrix mx) {
        DefaultIntRationalMatrix.writeTo(new PrintWriter(new OutputStreamWriter(out)), mx, "{" + NL, "}" + NL, " [", "]" + NL, "", " ", " ", ",");
    }

    protected static String toString(ReadableIntRationalMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        StringWriter sw = new StringWriter();
        DefaultIntRationalMatrix.writeTo(new PrintWriter(sw), mx, prefix, postfix, rowPrefix, rowPostfix, rowSeparator, colPrefix, colPostfix, colSeparator);
        return sw.toString();
    }

    protected static void writeTo(PrintWriter writer, ReadableIntRationalMatrix mx, String prefix, String postfix, String rowPrefix, String rowPostfix, String rowSeparator, String colPrefix, String colPostfix, String colSeparator) {
        int rows = mx.getRowCount();
        int cols = mx.getColumnCount();
        writer.print(prefix);
        int row = 0;
        while (row < rows) {
            if (row > 0) {
                writer.print(rowSeparator);
            }
            writer.print(rowPrefix);
            int col = 0;
            while (col < cols) {
                if (col > 0) {
                    writer.print(colSeparator);
                }
                writer.print(colPrefix);
                writer.print(mx.getIntNumeratorAt(row, col));
                writer.print('/');
                writer.print(mx.getIntDenominatorAt(row, col));
                writer.print(colPostfix);
                ++col;
            }
            writer.print(rowPostfix);
            ++row;
        }
        writer.print(postfix);
        writer.flush();
    }

    public DefaultIntRationalMatrix clone() {
        return new DefaultIntRationalMatrix((int[])this.mNumerators.clone(), (int[])this.mDenominators.clone(), -1, this.mColumnCount, false);
    }

    public DefaultIntRationalMatrix newInstance(int rows, int cols) {
        return new DefaultIntRationalMatrix(rows, cols);
    }

    public DefaultIntRationalMatrix newInstance(Number[][] data, boolean rowsInDim1) {
        throw new RuntimeException("not implemented");
    }

    public IntRationalMatrix toIntRationalMatrix(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public IntRationalMatrix toWritableMatrix(boolean enforceNewInstance) {
        return this.toIntRationalMatrix(enforceNewInstance);
    }

    public IntRationalMatrix toReadableMatrix(boolean enforceNewInstance) {
        return this.toIntRationalMatrix(enforceNewInstance);
    }

    public DoubleMatrix toDoubleMatrix(boolean enforceNewInstance) {
        return new DefaultDoubleMatrix(this.toDoubleArray(), this.getRowCount(), this.getColumnCount());
    }

    public LongRationalMatrix toLongRationalMatrix(boolean enforceNewInstance) {
        throw new RuntimeException("not implemented yet");
    }

    public BigIntegerRationalMatrix toBigIntegerRationalMatrix(boolean enforceNewInstance) {
        int len = this.mNumerators.length;
        BigInteger[] numerators = new BigInteger[len];
        BigInteger[] denominators = new BigInteger[len];
        int i = 0;
        while (i < len) {
            numerators[i] = BigInteger.valueOf(this.mNumerators[i]);
            denominators[i] = BigInteger.valueOf(this.mDenominators[i]);
            ++i;
        }
        return new DefaultBigIntegerRationalMatrix(numerators, denominators, this.getRowCount(), this.getColumnCount());
    }

    public double[] toDoubleArray() {
        double[] array = new double[this.mNumerators.length];
        this.toArray(array);
        return array;
    }

    public void toArray(double[] array) {
        if (array.length != this.mNumerators.length) {
            throw new IllegalArgumentException("expected array length " + this.mNumerators.length + " but found " + array.length);
        }
        int ii = 0;
        while (ii < array.length) {
            array[ii] = (double)this.mNumerators[ii] / (double)this.mDenominators[ii];
            ++ii;
        }
    }

    public double[] getDoubleColumn(int col) {
        return AbstractDoubleMatrix.getDoubleColumn(this, col);
    }

    public double[][] getDoubleColumns() {
        return AbstractDoubleMatrix.getDoubleColumns(this);
    }

    public double[] getDoubleRow(int row) {
        return AbstractDoubleMatrix.getDoubleRow(this, row);
    }

    public double[][] getDoubleRows() {
        return AbstractDoubleMatrix.getDoubleRows(this);
    }

    public Number[][] getNumberRows() {
        throw new RuntimeException("not implemented");
    }

    private static int[] getOnes(int count) {
        int[] ones = new int[count];
        Arrays.fill(ones, 1);
        return ones;
    }

    public void addRowToOtherRow(int srcRow, int srcFactor, int dstRow, int dstFactor) {
        this.addRowToOtherRow(srcRow, srcFactor, 1, dstRow, dstFactor, 1);
    }

    public void addRowToOtherRow(int srcRow, int srcNumerator, int srcDenominator, int dstRow, int dstNumerator, int dstDenominator) {
        if (srcDenominator == 0 || dstDenominator == 0) {
            throw new ArithmeticException("div by 0");
        }
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            long srcNumeratorL = this.getIntNumeratorAt(srcRow, col);
            long srcDenominatorL = this.getIntDenominatorAt(srcRow, col);
            long srcGcd = IntegerUtil.gcd(srcNumeratorL *= (long)srcNumerator, srcDenominatorL *= (long)srcDenominator);
            SmxIntegerUtil.checkIntegerRange(srcNumeratorL /= srcGcd);
            SmxIntegerUtil.checkIntegerRange(srcDenominatorL /= srcGcd);
            this.multiply(dstRow, col, dstNumerator, dstDenominator);
            this.add(dstRow, col, (int)srcNumeratorL, (int)srcDenominatorL);
            ++col;
        }
    }

    public void add(int row, int col, int value) {
        this.add(row, col, value, 1);
    }

    public void add(int row, int col, int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("div by 0");
        }
        if (numerator == 0) {
            return;
        }
        long rowNumerator = this.getIntNumeratorAt(row, col);
        if (rowNumerator == 0L) {
            this.setValueAt(row, col, numerator, denominator);
            return;
        }
        long rowDenominator = this.getIntDenominatorAt(row, col);
        long newDenominator = rowDenominator * (long)denominator;
        long newNumerator = (long)denominator * rowNumerator + rowDenominator * (long)numerator;
        long gcd = IntegerUtil.gcd(newDenominator, newNumerator);
        SmxIntegerUtil.checkIntegerRange(newNumerator /= gcd);
        SmxIntegerUtil.checkIntegerRange(newDenominator /= gcd);
        this.setValueAt(row, col, (int)newNumerator, (int)newDenominator);
    }

    public void multiply(int row, int col, int factor) {
        this.multiply(row, col, factor, 1);
    }

    public void multiply(int row, int col, int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("div by 0");
        }
        if (numerator == denominator) {
            return;
        }
        if (numerator == 0) {
            this.setValueAt(row, col, 0);
            return;
        }
        long rowNumerator = this.getIntNumeratorAt(row, col);
        if (rowNumerator == 0L) {
            return;
        }
        long rowDenominator = this.getIntDenominatorAt(row, col);
        if (rowNumerator == rowDenominator) {
            int gcd = IntegerUtil.gcd(numerator, denominator);
            this.setValueAt(row, col, numerator / gcd, denominator / gcd);
            return;
        }
        long newDenominator = rowDenominator * (long)denominator;
        long newNumerator = rowNumerator * (long)numerator;
        long gcd = IntegerUtil.gcd(newDenominator, newNumerator);
        SmxIntegerUtil.checkIntegerRange(newNumerator /= gcd);
        SmxIntegerUtil.checkIntegerRange(newDenominator /= gcd);
        this.setValueAt(row, col, (int)newNumerator, (int)newDenominator);
    }

    public void multiplyRow(int row, int factor) {
        this.multiplyRow(row, factor, 1);
    }

    public void multiplyRow(int row, int numerator, int denominator) {
        int cols = this.getColumnCount();
        int col = 0;
        while (col < cols) {
            this.multiply(row, col, numerator, denominator);
            ++col;
        }
    }

    public int hashCode() {
        int value = this.mColumnCount;
        int ii = 0;
        while (ii < this.mNumerators.length) {
            value ^= this.mNumerators[ii] ^ this.mDenominators[ii];
            ++ii;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IntRationalMatrix) {
            IntRationalMatrix other = (IntRationalMatrix)obj;
            int rows = this.getRowCount();
            if (rows != other.getRowCount()) {
                return false;
            }
            int cols = this.getColumnCount();
            if (cols != other.getColumnCount()) {
                return false;
            }
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    if (this.getIntNumeratorAt(row, col) != other.getIntNumeratorAt(row, col)) {
                        return false;
                    }
                    if (this.getIntDenominatorAt(row, col) != other.getIntDenominatorAt(row, col)) {
                        return false;
                    }
                    ++col;
                }
                ++row;
            }
            return true;
        }
        return false;
    }

    public IntRationalMatrix subIntRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        DefaultIntRationalMatrix res = new DefaultIntRationalMatrix(rowEnd - rowStart, colEnd - colStart);
        int row = 0;
        while (row < res.getRowCount()) {
            int col = 0;
            while (col < res.getColumnCount()) {
                res.setValueAt(row, col, this.getIntNumeratorAt(rowStart + row, colStart + col), this.getIntDenominatorAt(rowStart + row, colStart + col));
                ++col;
            }
            ++row;
        }
        return res;
    }

    public LongRationalMatrix subLongRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntRationalMatrix(rowStart, rowEnd, colStart, colEnd).toLongRationalMatrix(false);
    }

    public BigIntegerRationalMatrix subBigIntegerRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntRationalMatrix(rowStart, rowEnd, colStart, colEnd).toBigIntegerRationalMatrix(false);
    }

    public DoubleMatrix subDoubleMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.subIntRationalMatrix(rowStart, rowEnd, colStart, colEnd).toDoubleMatrix(false);
    }

    public boolean reduce() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        boolean any = false;
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                any |= this.reduceValueAt(row, col);
                ++col;
            }
            ++row;
        }
        return any;
    }

    public boolean reduceRow(int row) {
        int cols = this.getColumnCount();
        boolean any = false;
        int col = 0;
        while (col < cols) {
            any |= this.reduceValueAt(row, col);
            ++col;
        }
        return any;
    }

    public boolean reduceValueAt(int row, int col) {
        int num = this.getIntNumeratorAt(row, col);
        int den = this.getIntDenominatorAt(row, col);
        if (num == 0) {
            if (den != 1) {
                this.setValueAt(row, col, 0, 1);
                return true;
            }
            return false;
        }
        int gcd = IntegerUtil.gcd(num, den);
        if (gcd != 1) {
            if (den < 0) {
                gcd = -gcd;
            }
            this.setValueAt(row, col, num / gcd, den / gcd);
            return true;
        }
        return false;
    }

    public DefaultIntRationalMatrix transpose() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        DefaultIntRationalMatrix tr = new DefaultIntRationalMatrix(cols, rows);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                tr.setValueAt(col, row, this.getIntNumeratorAt(row, col), this.getIntDenominatorAt(row, col));
                ++col;
            }
            ++row;
        }
        return tr;
    }

    public void negate(int row, int col) {
        int num = this.getIntNumeratorAt(row, col);
        int den = this.getIntNumeratorAt(row, col);
        if (den > 0) {
            this.setValueAt(row, col, -num, den);
        } else {
            this.setValueAt(row, col, num, -den);
        }
    }
}

