/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.parse.util;

import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.sort.LexMinArrayComparator;
import ch.javasoft.math.array.sort.MatrixSortUtil;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.PolcoConfig;
import ch.javasoft.polco.config.XmlAttribute;
import ch.javasoft.polco.config.XmlElement;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.numeric.Zero;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Comparator;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortUtil {
    public static <N extends Number, A> void sortMatrix(Element config, Arithmetic<N, A> arithmetic, Zero zero, A[] matrix) throws IOException {
        if (config == null) {
            return;
        }
        try {
            Comparator comparator;
            Element elPolcoConfig = PolcoConfig.getPolcoConfig(config.getDocument());
            Element elInput = XmlUtil.getRequiredSingleChildElement(elPolcoConfig, XmlElement.input);
            String sort = XmlUtil.getRequiredAttributeValue(elInput, XmlAttribute.sort);
            if ("default".equals(sort)) {
                return;
            }
            String className = SortUtil.getComparatorClassName(sort);
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> cons = clazz.getConstructor(NumberOperators.class);
                comparator = (Comparator)cons.newInstance(arithmetic.getNumberOperators(zero));
            }
            catch (Exception e) {
                throw new XmlConfigException("could not instantiate sorter class " + className + ", e=" + e, XmlUtil.getElementPath(elInput, true), (Throwable)e);
            }
            MatrixSortUtil.sortMatrixRows(matrix, comparator);
        }
        catch (Exception e) {
            throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
        }
    }

    private static String getComparatorClassName(String sort) {
        String clsNameRef = LexMinArrayComparator.class.getName();
        String clsNameSimpleRef = LexMinArrayComparator.class.getSimpleName();
        String clsNameSimpleThis = String.valueOf(sort) + clsNameSimpleRef.substring("LexMin".length());
        return clsNameRef.replace(clsNameSimpleRef, clsNameSimpleThis);
    }
}

