/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.config;

import ch.javasoft.math.array.Converter;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.polco.EqualityPolyhedralCone;
import ch.javasoft.polco.InequalityPolyhedralCone;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.impl.DefaultEqualityCone;
import ch.javasoft.polco.impl.DefaultInequalityCone;
import ch.javasoft.polco.impl.DefaultPolyhedralCone;
import ch.javasoft.polco.transform.TransformHelper;
import ch.javasoft.polco.transform.TransformedPolyhedralCone;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEvent;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverter<IN extends Number, IA, RN extends Number, RA> {
    private final boolean allowMatrixRowScaling;
    private final LinAlgOperations<IN, IA> originalOps;
    private final LinAlgOperations<RN, RA> targetOps;
    private final Converter<IN, IA, RN, RA> converter;

    public TypeConverter(LinAlgOperations<IN, IA> originalOps, LinAlgOperations<RN, RA> targetOps, boolean allowMatrixRowScaling) {
        this.allowMatrixRowScaling = allowMatrixRowScaling;
        this.originalOps = originalOps;
        this.targetOps = targetOps;
        this.converter = new Converter(originalOps.getNumberArrayOperations(), targetOps.getNumberArrayOperations());
    }

    public TypeConverter(Arithmetic<IN, IA> originalType, Zero originalZero, Arithmetic<RN, RA> targetType, Zero targetZero, boolean allowMatrixRowScaling) {
        this(originalType.getLinAlgOperations(originalZero), targetType.getLinAlgOperations(targetZero), allowMatrixRowScaling);
    }

    public Converter<IN, IA, RN, RA> getConverter() {
        return this.converter;
    }

    public boolean isIdentityConverter() {
        return this.converter.isIdentityConverter();
    }

    public ExtremeRayCallback<RN, RA> convertCallback(ExtremeRayCallback<IN, IA> original) {
        if (this.isIdentityConverter()) {
            return original;
        }
        return this.convertCallbackInternal(original);
    }

    private ExtremeRayCallback<RN, RA> convertCallbackInternal(final ExtremeRayCallback<IN, IA> original) {
        final TypeConverter<RN, RA, IN, IA> back = new TypeConverter<RN, RA, IN, IA>(this.targetOps, this.originalOps, this.allowMatrixRowScaling);
        return new ExtremeRayCallback<RN, RA>(){
            final ThreadLocal<ExtremeRayEvent<IN, IA>> convertedEvent = new ThreadLocal();
            final ThreadLocal<ExtremeRayEvent<RN, RA>> originalEvent = new ThreadLocal();

            @Override
            public boolean initialize(ExtremeRayEvent<RN, RA> event) throws IOException {
                ExtremeRayEvent cEvent = back.convertEvent(event);
                this.originalEvent.set(event);
                this.convertedEvent.set(cEvent);
                return original.initialize(cEvent);
            }

            @Override
            public void outputExtremeRay(ExtremeRayEvent<RN, RA> event, long index, RA extremeRay) throws IOException {
                ExtremeRayEvent<Object, Object> cEvent;
                if (event.equals(this.originalEvent.get())) {
                    cEvent = this.convertedEvent.get();
                } else {
                    this.originalEvent.set(event);
                    cEvent = back.convertEvent(event);
                    this.convertedEvent.set(cEvent);
                }
                Object cExtremeRay = back.converter.convertVector(extremeRay, true, true);
                original.outputExtremeRay(cEvent, index, cExtremeRay);
            }

            @Override
            public void terminate(ExtremeRayEvent<RN, RA> event) throws IOException {
                ExtremeRayEvent<Object, Object> cEvent;
                if (event.equals(this.originalEvent.get())) {
                    cEvent = this.convertedEvent.get();
                } else {
                    this.originalEvent.set(event);
                    cEvent = back.convertEvent(event);
                    this.convertedEvent.set(cEvent);
                }
                original.terminate(cEvent);
                this.originalEvent.set(null);
                this.convertedEvent.set(null);
            }
        };
    }

    public ExtremeRayEvent<RN, RA> convertEvent(ExtremeRayEvent<IN, IA> original) {
        if (this.isIdentityConverter()) {
            return original;
        }
        return this.convertEventInternal(original);
    }

    private ExtremeRayEvent<RN, RA> convertEventInternal(ExtremeRayEvent<IN, IA> original) {
        PolyhedralCone<RN, RA> converted = this.convertPolyhedralCone(original.getPolyhedralCone());
        return new ExtremeRayEvent<RN, RA>(converted, original.getRayCount());
    }

    public PolyhedralCone<RN, RA> convertPolyhedralCone(PolyhedralCone<IN, IA> original) {
        if (this.isIdentityConverter()) {
            return original;
        }
        return this.convertPolyhedralConeInternal(original);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyhedralCone<RN, RA> convertPolyhedralConeInternal(final PolyhedralCone<IN, IA> original) {
        if (original instanceof EqualityPolyhedralCone) {
            Arr[] origA;
            EqualityPolyhedralCone cone = (EqualityPolyhedralCone)original;
            Arr[] ArrArray = origA = cone.getA();
            synchronized (origA) {
                Object[] convA = this.convertMatrix(origA, true);
                // ** MonitorExit[var5_8] (shouldn't be in output)
                if (original instanceof TransformedPolyhedralCone) {
                    return this.createTransformedEqualityCone((TransformedPolyhedralCone)original, convA);
                }
                return new DefaultEqualityCone<RN, RA>(this.targetOps, convA){

                    @Override
                    public int getDimensions() {
                        return original.getDimensions();
                    }
                };
            }
        }
        if (original instanceof InequalityPolyhedralCone) {
            Arr[] origB;
            InequalityPolyhedralCone cone = (InequalityPolyhedralCone)original;
            Arr[] ArrArray = origB = cone.getB();
            synchronized (origB) {
                Object[] convB = this.convertMatrix(origB, true);
                // ** MonitorExit[var5_9] (shouldn't be in output)
                if (original instanceof TransformedPolyhedralCone) {
                    return this.createTransformedInequalityCone((TransformedPolyhedralCone)original, convB);
                }
                return new DefaultInequalityCone<RN, RA>(this.targetOps, convB){

                    @Override
                    public int getDimensions() {
                        return original.getDimensions();
                    }
                };
            }
        }
        IA[] origA = original.getA();
        IA[] origB = original.getB();
        IA[] IAArray = origA;
        synchronized (origA) {
            Object[] convA = this.convertMatrix(origA, true);
            // ** MonitorExit[var6_14] (shouldn't be in output)
            IAArray = origB;
            synchronized (origB) {
                Object[] convB = this.convertMatrix(origB, true);
                // ** MonitorExit[var6_14] (shouldn't be in output)
                if (original instanceof TransformedPolyhedralCone) {
                    return this.createTransformedPolyhedralCone((TransformedPolyhedralCone)original, convA, convB);
                }
                return new DefaultPolyhedralCone<RN, RA>(this.targetOps, convA, convB){

                    @Override
                    public int getDimensions() {
                        return original.getDimensions();
                    }
                };
            }
        }
    }

    private PolyhedralCone<RN, RA> createTransformedEqualityCone(final TransformedPolyhedralCone<IN, IA> original, RA[] mxA) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class TransformedEqualityCone
        extends DefaultEqualityCone<RN, RA>
        implements TransformedPolyhedralCone<RN, RA> {
            private volatile PolyhedralCone<RN, RA> parent;
            private volatile AtomicReference<RA[]> mxTtoOriginal;

            public TransformedEqualityCone(LinAlgOperations<RN, RA> linAlgOps, RA[] mxA) {
                super(linAlgOps, mxA);
                this.mxTtoOriginal = new AtomicReference();
            }

            @Override
            public PolyhedralCone<RN, RA> getParentCone() {
                if (this.parent == null && this.parent == null) {
                    this.parent = this.convertPolyhedralCone(original.getParentCone());
                }
                return this.parent;
            }

            @Override
            public PolyhedralCone<RN, RA> getOriginalCone() {
                return TransformHelper.getOriginalCone(this);
            }

            @Override
            public int getDimensions() {
                return original.getDimensions();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RA transformToOriginal(RA x2) {
                Object[] mxTtoOriginalI;
                if (this.mxTtoOriginal.get() != null) return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                Object[] objectArray = mxTtoOriginalI = TransformHelper.getTransformationMatrixToOriginal(original);
                synchronized (mxTtoOriginalI) {
                    if (this.mxTtoOriginal.get() != null) return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                    this.mxTtoOriginal.compareAndSet(null, this.convertMatrix(mxTtoOriginalI, false));
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                }
            }

            @Override
            public RA[] getTransformationMatrixToParent() {
                throw new RuntimeException("unsupported, use transformToOriginal() instead");
            }
        }
        return new TransformedEqualityCone(this.targetOps, (Object[])mxA);
    }

    private PolyhedralCone<RN, RA> createTransformedInequalityCone(final TransformedPolyhedralCone<IN, IA> original, RA[] mxB) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class TransformedEqualityCone
        extends DefaultInequalityCone<RN, RA>
        implements TransformedPolyhedralCone<RN, RA> {
            private volatile PolyhedralCone<RN, RA> parent;
            private volatile AtomicReference<RA[]> mxTtoOriginal;

            public TransformedEqualityCone(LinAlgOperations<RN, RA> linAlgOps, RA[] mxB) {
                super(linAlgOps, mxB);
                this.mxTtoOriginal = new AtomicReference();
            }

            @Override
            public PolyhedralCone<RN, RA> getParentCone() {
                if (this.parent == null && this.parent == null) {
                    this.parent = this.convertPolyhedralCone(original.getParentCone());
                }
                return this.parent;
            }

            @Override
            public PolyhedralCone<RN, RA> getOriginalCone() {
                return TransformHelper.getOriginalCone(this);
            }

            @Override
            public int getDimensions() {
                return original.getDimensions();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RA transformToOriginal(RA x2) {
                Object[] mxTtoOriginalI;
                if (this.mxTtoOriginal.get() != null) return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                Object[] objectArray = mxTtoOriginalI = TransformHelper.getTransformationMatrixToOriginal(original);
                synchronized (mxTtoOriginalI) {
                    if (this.mxTtoOriginal.get() != null) return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                    this.mxTtoOriginal.compareAndSet(null, this.convertMatrix(mxTtoOriginalI, false));
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                }
            }

            @Override
            public RA[] getTransformationMatrixToParent() {
                throw new RuntimeException("unsupported, use transformToOriginal() instead");
            }
        }
        return new TransformedEqualityCone(this.targetOps, (Object[])mxB);
    }

    private PolyhedralCone<RN, RA> createTransformedPolyhedralCone(final TransformedPolyhedralCone<IN, IA> original, RA[] mxA, RA[] mxB) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class TransformedCone
        extends DefaultPolyhedralCone<RN, RA>
        implements TransformedPolyhedralCone<RN, RA> {
            private volatile PolyhedralCone<RN, RA> parent;
            private volatile AtomicReference<RA[]> mxTtoOriginal;

            public TransformedCone(LinAlgOperations<RN, RA> linAlgOps, RA[] mxA, RA[] mxB) {
                super(linAlgOps, mxA, mxB);
                this.mxTtoOriginal = new AtomicReference();
            }

            @Override
            public PolyhedralCone<RN, RA> getParentCone() {
                if (this.parent == null && this.parent == null) {
                    this.parent = this.convertPolyhedralCone(original.getParentCone());
                }
                return this.parent;
            }

            @Override
            public PolyhedralCone<RN, RA> getOriginalCone() {
                return TransformHelper.getOriginalCone(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RA transformToOriginal(RA x2) {
                Object[] mxTtoOriginalI;
                if (this.mxTtoOriginal.get() != null) return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                Object[] objectArray = mxTtoOriginalI = TransformHelper.getTransformationMatrixToOriginal(original);
                synchronized (mxTtoOriginalI) {
                    if (this.mxTtoOriginal.get() != null) return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                    this.mxTtoOriginal.compareAndSet(null, this.convertMatrix(mxTtoOriginalI, false));
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return TransformHelper.transformToOriginal(this, this.mxTtoOriginal, x2);
                }
            }

            @Override
            public RA[] getTransformationMatrixToParent() {
                throw new RuntimeException("unsupported, use transformToOriginal() instead");
            }
        }
        return new TransformedCone(this.targetOps, (Object[])mxA, (Object[])mxB);
    }

    private RA[] convertMatrix(IA[] original, boolean allowRowScaling) {
        try {
            return this.converter.convertMatrix(original);
        }
        catch (ArithmeticException e) {
            return this.converter.convertMatrix(original, true, allowRowScaling && this.allowMatrixRowScaling, false, true);
        }
    }
}

