/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.callback.matlab;

import ch.javasoft.jsmat.MatFileWriter;
import ch.javasoft.jsmat.ReservedMatrixWriter;
import ch.javasoft.jsmat.variable.MatAllocated;
import ch.javasoft.jsmat.variable.MatCharMatrix;
import ch.javasoft.jsmat.variable.MatDoubleMatrix;
import ch.javasoft.jsmat.variable.MatReservedMatrix;
import ch.javasoft.jsmat.variable.MatVariable;
import ch.javasoft.math.array.Converter;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.operator.impl.DoubleOperators;
import ch.javasoft.polco.EqualityPolyhedralCone;
import ch.javasoft.polco.InequalityPolyhedralCone;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.polco.xenum.ExtremeRayEvent;
import ch.javasoft.util.numeric.Zero;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatlabCallback<Num extends Number, Arr>
implements ExtremeRayCallback<Num, Arr> {
    private final MatFileWriter matFileWriter;
    private Converter<Num, Arr, Double, double[]> converter;
    private ReservedMatrixWriter<double[]> rayWriter;

    public MatlabCallback(File file) throws IOException {
        this.matFileWriter = new MatFileWriter(file);
    }

    @Override
    public boolean initialize(ExtremeRayEvent<Num, Arr> event) throws IOException {
        MatVariable mat;
        PolyhedralCone<Num, Arr> cone = event.getPolyhedralCone();
        NumberArrayOperations naops = cone.getLinAlgOperations().getNumberArrayOperations();
        int dims = cone.getDimensions();
        this.converter = this.getDoubleConverter(naops);
        long bytes = 0L;
        MatCharMatrix desc = new MatCharMatrix(String.valueOf(cone.toString()) + " = { x = R c , R:" + cone.getDimensions() + "x" + event.getRayCount() + "   for some c >= 0 }");
        this.matFileWriter.write("description", desc);
        bytes += (long)desc.getRawDataSize();
        if (!(cone instanceof InequalityPolyhedralCone)) {
            mat = new MatDoubleMatrix(this.converter.convertMatrix(cone.getA()));
            this.matFileWriter.write("A", (MatAllocated)mat);
            bytes += (long)mat.getRawDataSize();
        }
        if (!(cone instanceof EqualityPolyhedralCone)) {
            mat = new MatDoubleMatrix(this.converter.convertMatrix(cone.getB()));
            this.matFileWriter.write("B", (MatAllocated)mat);
            bytes += (long)mat.getRawDataSize();
        }
        bytes += event.getRayCount() * (long)dims + 8L + 2L;
        if ((bytes += 65536L) > 0xFFFFFFFEL) {
            throw new IOException("too many bytes (" + bytes + " > 4G), use hdf5 instead");
        }
        mat = MatReservedMatrix.createDoubleMatrix(dims, (int)event.getRayCount());
        this.rayWriter = this.matFileWriter.createReservedWriter("R", mat);
        return true;
    }

    @Override
    public void outputExtremeRay(ExtremeRayEvent<Num, Arr> event, long index, Arr extremeRay) throws IOException {
        NumberArrayOperations naops = event.getPolyhedralCone().getLinAlgOperations().getNumberArrayOperations();
        this.writeVector(this.rayWriter, naops, extremeRay);
    }

    @Override
    public void terminate(ExtremeRayEvent<Num, Arr> event) throws IOException {
        this.rayWriter.close();
        this.rayWriter = null;
        this.matFileWriter.close();
    }

    private void writeVector(ReservedMatrixWriter<double[]> writer, NumberArrayOperations<Num, Arr> naops, Arr vector) throws IOException {
        double[] ray = this.converter.convertVector(vector);
        writer.append(ray);
    }

    private Converter<Num, Arr, Double, double[]> getDoubleConverter(NumberArrayOperations<Num, Arr> naops) {
        return new DoubleOperators(new Zero()).getNumberArrayOperations().getConverterFrom(naops);
    }
}

