/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.adapter;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.operator.impl.BigFractionOperators;
import ch.javasoft.math.operator.impl.BigIntegerOperators;
import ch.javasoft.math.operator.impl.DoubleOperators;
import ch.javasoft.polco.adapter.AdapterCallback;
import ch.javasoft.polco.adapter.Options;
import ch.javasoft.polco.config.PolcoConfig;
import ch.javasoft.polco.impl.AbstractPolyhedralCone;
import ch.javasoft.polco.impl.DefaultInequalityCone;
import ch.javasoft.polco.impl.DefaultPolyhedralCone;
import ch.javasoft.polco.main.Polco;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.xml.config.MissingReferableException;
import ch.javasoft.xml.config.XmlArgException;
import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlConfigException;
import java.math.BigInteger;

public class PolcoAdapter {
    private final Polco polco;

    public PolcoAdapter() throws XmlConfigException {
        this(new Options());
    }

    public PolcoAdapter(Options options) throws XmlConfigException {
        try {
            try {
                XmlConfig xmlConfig = PolcoConfig.resolveXmlConfig(options.toArgs());
                this.polco = new Polco(xmlConfig);
            }
            catch (XmlArgException ex) {
                throw ex;
            }
            catch (MissingReferableException ex) {
                throw ex;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PolcoConfig.traceArgs(System.err, String.valueOf(PolcoAdapter.class.getName()) + " with following arguments: ", options.toArgs());
            throw ExceptionUtil.toRuntimeExceptionOr(XmlConfigException.class, ex);
        }
    }

    public double[][] getDoubleRays(double[][] eq, double[][] iq) {
        LinAlgOperations<Double, double[]> dblOps = DoubleOperators.DEFAULT.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<Double, double[]>(dblOps, (Arr[])iq) : new DefaultPolyhedralCone<Double, double[]>(dblOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(dblOps.getArrayOperations());
        this.polco.call(cone, callback, dblOps);
        return (double[][])callback.yield();
    }

    public double[][] getDoubleRays(int[][] eq, int[][] iq) {
        BigInteger[][] beq = eq == null ? null : PolcoAdapter.toBigInteger(eq);
        BigInteger[][] biq = PolcoAdapter.toBigInteger(iq);
        return this.getDoubleRays(beq, biq);
    }

    public double[][] getDoubleRays(long[][] eq, long[][] iq) {
        BigInteger[][] beq = eq == null ? null : PolcoAdapter.toBigInteger(eq);
        BigInteger[][] biq = PolcoAdapter.toBigInteger(iq);
        return this.getDoubleRays(beq, biq);
    }

    public double[][] getDoubleRays(BigInteger[][] eq, BigInteger[][] iq) {
        LinAlgOperations<BigInteger, BigInteger[]> intOps = BigIntegerOperators.EXACT_DIVISION_INSTANCE.getLinAlgOperations();
        LinAlgOperations<Double, double[]> dblOps = DoubleOperators.DEFAULT.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<BigInteger, BigInteger[]>(intOps, (Arr[])iq) : new DefaultPolyhedralCone<BigInteger, BigInteger[]>(intOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(dblOps.getArrayOperations());
        this.polco.call(cone, callback, dblOps);
        return (double[][])callback.yield();
    }

    public double[][] getDoubleRays(BigFraction[][] eq, BigFraction[][] iq) {
        LinAlgOperations<BigFraction, BigFraction[]> fraOps = BigFractionOperators.INSTANCE.getLinAlgOperations();
        LinAlgOperations<Double, double[]> dblOps = DoubleOperators.DEFAULT.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<BigFraction, BigFraction[]>(fraOps, (Arr[])iq) : new DefaultPolyhedralCone<BigFraction, BigFraction[]>(fraOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(dblOps.getArrayOperations());
        this.polco.call(cone, callback, dblOps);
        return (double[][])callback.yield();
    }

    public BigInteger[][] getBigIntegerRays(double[][] eq, double[][] iq) {
        LinAlgOperations<Double, double[]> dblOps = DoubleOperators.DEFAULT.getLinAlgOperations();
        LinAlgOperations<BigInteger, BigInteger[]> intOps = BigIntegerOperators.EXACT_DIVISION_INSTANCE.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<Double, double[]>(dblOps, (Arr[])iq) : new DefaultPolyhedralCone<Double, double[]>(dblOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(intOps.getArrayOperations());
        this.polco.call(cone, callback, intOps);
        return (BigInteger[][])callback.yield();
    }

    public BigInteger[][] getBigIntegerRays(int[][] eq, int[][] iq) {
        BigInteger[][] beq = eq == null ? null : PolcoAdapter.toBigInteger(eq);
        BigInteger[][] biq = PolcoAdapter.toBigInteger(iq);
        return this.getBigIntegerRays(beq, biq);
    }

    public BigInteger[][] getBigIntegerRays(long[][] eq, long[][] iq) {
        BigInteger[][] beq = eq == null ? null : PolcoAdapter.toBigInteger(eq);
        BigInteger[][] biq = PolcoAdapter.toBigInteger(iq);
        return this.getBigIntegerRays(beq, biq);
    }

    public BigInteger[][] getBigIntegerRays(BigInteger[][] eq, BigInteger[][] iq) {
        LinAlgOperations<BigInteger, BigInteger[]> intOps = BigIntegerOperators.EXACT_DIVISION_INSTANCE.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<BigInteger, BigInteger[]>(intOps, (Arr[])iq) : new DefaultPolyhedralCone<BigInteger, BigInteger[]>(intOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(intOps.getArrayOperations());
        this.polco.call(cone, callback, intOps);
        return (BigInteger[][])callback.yield();
    }

    public BigInteger[][] getBigIntegerRays(BigFraction[][] eq, BigFraction[][] iq) {
        LinAlgOperations<BigFraction, BigFraction[]> fraOps = BigFractionOperators.INSTANCE.getLinAlgOperations();
        LinAlgOperations<BigInteger, BigInteger[]> intOps = BigIntegerOperators.EXACT_DIVISION_INSTANCE.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<BigFraction, BigFraction[]>(fraOps, (Arr[])iq) : new DefaultPolyhedralCone<BigFraction, BigFraction[]>(fraOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(intOps.getArrayOperations());
        this.polco.call(cone, callback, intOps);
        return (BigInteger[][])callback.yield();
    }

    public BigFraction[][] getBigFractionRays(double[][] eq, double[][] iq) {
        LinAlgOperations<Double, double[]> dblOps = DoubleOperators.DEFAULT.getLinAlgOperations();
        LinAlgOperations<BigFraction, BigFraction[]> fraOps = BigFractionOperators.INSTANCE.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<Double, double[]>(dblOps, (Arr[])iq) : new DefaultPolyhedralCone<Double, double[]>(dblOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(fraOps.getArrayOperations());
        this.polco.call(cone, callback, fraOps);
        return (BigFraction[][])callback.yield();
    }

    public BigFraction[][] getBigFractionRays(int[][] eq, int[][] iq) {
        BigInteger[][] beq = eq == null ? null : PolcoAdapter.toBigInteger(eq);
        BigInteger[][] biq = PolcoAdapter.toBigInteger(iq);
        return this.getBigFractionRays(beq, biq);
    }

    public BigFraction[][] getBigFractionRays(long[][] eq, long[][] iq) {
        BigInteger[][] beq = eq == null ? null : PolcoAdapter.toBigInteger(eq);
        BigInteger[][] biq = PolcoAdapter.toBigInteger(iq);
        return this.getBigFractionRays(beq, biq);
    }

    public BigFraction[][] getBigFractionRays(BigInteger[][] eq, BigInteger[][] iq) {
        LinAlgOperations<BigInteger, BigInteger[]> intOps = BigIntegerOperators.EXACT_DIVISION_INSTANCE.getLinAlgOperations();
        LinAlgOperations<BigFraction, BigFraction[]> fraOps = BigFractionOperators.INSTANCE.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<BigInteger, BigInteger[]>(intOps, (Arr[])iq) : new DefaultPolyhedralCone<BigInteger, BigInteger[]>(intOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(fraOps.getArrayOperations());
        this.polco.call(cone, callback, fraOps);
        return (BigFraction[][])callback.yield();
    }

    public BigFraction[][] getBigFractionRays(BigFraction[][] eq, BigFraction[][] iq) {
        LinAlgOperations<BigFraction, BigFraction[]> fraOps = BigFractionOperators.INSTANCE.getLinAlgOperations();
        AbstractPolyhedralCone cone = eq == null || eq.length == 0 ? new DefaultInequalityCone<BigFraction, BigFraction[]>(fraOps, (Arr[])iq) : new DefaultPolyhedralCone<BigFraction, BigFraction[]>(fraOps, (Arr[])eq, (Arr[])iq);
        AdapterCallback callback = new AdapterCallback(fraOps.getArrayOperations());
        this.polco.call(cone, callback, fraOps);
        return (BigFraction[][])callback.yield();
    }

    private static final BigInteger[][] toBigInteger(int[][] matrix) {
        BigInteger[][] result = new BigInteger[matrix.length][];
        int i = 0;
        while (i < matrix.length) {
            result[i] = new BigInteger[matrix[i].length];
            int j = 0;
            while (j < matrix[i].length) {
                result[i][j] = BigInteger.valueOf(matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static final BigInteger[][] toBigInteger(long[][] matrix) {
        BigInteger[][] result = new BigInteger[matrix.length][];
        int i = 0;
        while (i < matrix.length) {
            result[i] = new BigInteger[matrix[i].length];
            int j = 0;
            while (j < matrix[i].length) {
                result[i][j] = BigInteger.valueOf(matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return result;
    }
}

