/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco;

import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.TestHelper;
import ch.javasoft.polco.callback.matlab.MatlabCallback;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.ArithmeticCallback;
import ch.javasoft.polco.metabolic.EfmExtremeRayEnumerator;
import ch.javasoft.polco.parse.TextParser;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import junit.framework.TestCase;

public class TextTest
extends TestCase {
    private static final File FOLDER = new File("../metabolic-data/text-matrix");
    private static final ch.javasoft.metabolic.efm.config.Arithmetic arithmetic;

    static {
        CompressionMethod[] compression = CompressionMethod.STANDARD_NO_DUPLICATE;
        arithmetic = ch.javasoft.metabolic.efm.config.Arithmetic.fractional;
        if (Config.initForJUnitTest("pattern-tree-minzero", "FewestNegPos", compression, false, arithmetic)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
        }
    }

    public void testZeroConstraints() throws Exception {
        String[] iq = new String[]{"1 0 1 0 0", "0 1 0 1 0", "0 0 1 1 0", "0 0 1 0 1", "0 0 0 1 1"};
        this.internalTestText(null, iq);
    }

    public void testColiAll() throws Exception {
        this.internalTestText("coli-nature-all");
    }

    public void testColiExpandedAll() throws Exception {
        this.internalTestText("coli-nature-expanded-all");
    }

    public void testColiExpandedGlX() throws Exception {
        this.internalTestText("coli-nature-expanded-glx");
    }

    public void testColiExpandedGlXMueCut() throws Exception {
        this.internalTestText("coli-nature-expanded-glx-muecut");
    }

    protected void internalTestText(String[] eq, String[] iq) throws Exception {
        InputStream seq = TextTest.str2InputStream(eq);
        InputStream sine = TextTest.str2InputStream(iq);
        this.internalTestText(seq, sine);
    }

    private static InputStream str2InputStream(String[] mat) {
        if (mat == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        int i = 0;
        while (i < mat.length) {
            ps.println(mat[i]);
            ++i;
        }
        ps.flush();
        return new ByteArrayInputStream(out.toByteArray());
    }

    protected void internalTestText(String fileName) throws Exception {
        File eq = new File(FOLDER, String.valueOf(fileName) + ".eq");
        File iq = new File(FOLDER, String.valueOf(fileName) + ".iq");
        this.internalTestText(eq, iq);
    }

    protected void internalTestText(File eq, File iq) throws Exception {
        FileInputStream seq = eq == null ? null : new FileInputStream(eq);
        FileInputStream siq = iq == null ? null : new FileInputStream(iq);
        this.internalTestText(seq, siq);
    }

    protected void internalTestText(final InputStream eq, final InputStream iq) throws Exception {
        TestHelper.getPolcoArithmetic(arithmetic).callback(new ArithmeticCallback<Void>(){

            @Override
            public <N extends Number, A> Void callback(Arithmetic<N, A> arithmetic) throws Exception {
                Zero zero = Config.getConfig().zero();
                PolyhedralCone<N, A> cone = new TextParser().parse(null, arithmetic, zero, eq, iq);
                EfmExtremeRayEnumerator xray = new EfmExtremeRayEnumerator(zero, true);
                MatlabCallback callback = new MatlabCallback(new File("/tmp/efms.mat"));
                xray.enumerateExtremeRays(cone, callback, arithmetic.getLinAlgOperations(zero));
                return null;
            }
        });
    }
}

