/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco;

import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.TestHelper;
import ch.javasoft.polco.callback.NullCallback;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.ArithmeticCallback;
import ch.javasoft.polco.metabolic.EfmExtremeRayEnumerator;
import ch.javasoft.polco.parse.CddParser;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import junit.framework.TestCase;

public class CddIneTest
extends TestCase {
    private static final File FOLDER_INE = new File("../cdd-data/ine");
    private static final ch.javasoft.metabolic.efm.config.Arithmetic arithmetic;

    static {
        CompressionMethod[] compression = CompressionMethod.NONE;
        arithmetic = ch.javasoft.metabolic.efm.config.Arithmetic.bigint;
        if (Config.initForJUnitTest("pattern-tree-minzero", "MostZerosOrAbsLexMin", compression, false, arithmetic)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
        }
    }

    public void testCube2() throws Exception {
        this.internalTestIne("cube2.ine");
    }

    public void testCube3() throws Exception {
        this.internalTestIne("cube3.ine");
    }

    public void testCube4() throws Exception {
        this.internalTestIne("cube4.ine");
    }

    public void testCube6() throws Exception {
        this.internalTestIne("cube6.ine");
    }

    public void testCube8() throws Exception {
        this.internalTestIne("cube8.ine");
    }

    public void testCube10() throws Exception {
        this.internalTestIne("cube10.ine");
    }

    public void testCube14() throws Exception {
        this.internalTestIne("cube14.ine");
    }

    public void testCube16() throws Exception {
        this.internalTestIne("cube16.ine");
    }

    public void testCube18() throws Exception {
        this.internalTestIne("cube18.ine");
    }

    public void testCube20() throws Exception {
        this.internalTestIne("cube20.ine");
    }

    public void testCube22() throws Exception {
        this.internalTestIne("cube22.ine");
    }

    public void testCross6() throws Exception {
        this.internalTestIne("cross6.ine");
    }

    public void testCross8() throws Exception {
        this.internalTestIne("cross8.ine");
    }

    public void testCross10() throws Exception {
        this.internalTestIne("cross10.ine");
    }

    public void testCross12() throws Exception {
        this.internalTestIne("cross12.ine");
    }

    public void testCcp4rev() throws Exception {
        this.internalTestIne("ccp4.ine");
    }

    public void testCcp5rev() throws Exception {
        this.internalTestIne("ccp5.ine");
    }

    public void testCcp6rev() throws Exception {
        this.internalTestIne("ccp6.ine");
    }

    public void testCcp7rev() throws Exception {
        this.internalTestIne("ccp7.ine");
    }

    public void testReg600_5() throws Exception {
        this.internalTestIne("reg600-5.ine");
    }

    public void testProdmT5() throws Exception {
        this.internalTestIne("prodmt5.ine");
    }

    public void testProdmT62() throws Exception {
        this.internalTestIne("prodst62.ine");
    }

    public void testMit31_20() throws Exception {
        this.internalTestIne("mit31-20.ine");
    }

    public void testMit41_16() throws Exception {
        this.internalTestIne("mit41-16.ine");
    }

    public void testMit71_61() throws Exception {
        this.internalTestIne("mit71-61.ine");
    }

    public void testMit90_86() throws Exception {
        this.internalTestIne("mit90-86.ine");
    }

    public void testMit729_9() throws Exception {
        this.internalTestIne("mit729-9.ine");
    }

    public void testKkd11_3() throws Exception {
        this.internalTestIne("kkd11_3.ine");
    }

    public void testKkd18_4() throws Exception {
        this.internalTestIne("kkd18_4.ine");
    }

    public void testKkd27_5() throws Exception {
        this.internalTestIne("kkd27_5.ine");
    }

    public void testKkd38_6() throws Exception {
        this.internalTestIne("kkd38_6.ine");
    }

    public void testKkd51_7() throws Exception {
        this.internalTestIne("kkd51_7.ine");
    }

    public void testKkd66_8() throws Exception {
        this.internalTestIne("kkd66_8.ine");
    }

    public void testKkd83_9() throws Exception {
        this.internalTestIne("kkd83_9.ine");
    }

    public void testKkd102_10() throws Exception {
        this.internalTestIne("kkd102_10.ine");
    }

    public void testKkd123_11() throws Exception {
        this.internalTestIne("kkd123_11.ine");
    }

    public void testKkd146_12() throws Exception {
        this.internalTestIne("kkd146_12.ine");
    }

    public void testStein27() throws Exception {
        this.internalTestIne("stein27.ine");
    }

    protected void internalTestIne(String fileName) throws Exception {
        final File file = new File(FOLDER_INE, fileName);
        TestHelper.getPolcoArithmetic(arithmetic).callback(new ArithmeticCallback<Void>(){

            @Override
            public <N extends Number, A> Void callback(Arithmetic<N, A> arithmetic) throws Exception {
                Zero zero = Config.getConfig().zero();
                PolyhedralCone<N, A> cone = new CddParser().parse(null, arithmetic, zero, new FileInputStream(file));
                EfmExtremeRayEnumerator xray = new EfmExtremeRayEnumerator(zero, true);
                ExtremeRayCallback callback = NullCallback.instance();
                xray.enumerateExtremeRays(cone, callback, arithmetic.getLinAlgOperations(zero));
                return null;
            }
        });
    }
}

