/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.io.Files;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import ch.javasoft.util.Arrays;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class PalssonTest
extends AbstractParseTestCase {
    protected static final File FOLDER_IN = new File("../metabolic-data/palsson/");
    protected static final File FOLDER_OUT = Files.getTempDir();
    protected ThreadLocal<File> fileOut = new ThreadLocal();

    public void testPalsson_coli_iJR904_xrev() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "coli/iJR904(7-28-04)-reacts-xrev.csv"), new File(FOLDER_OUT, "iJR904_xrev.m"));
    }

    public void testPalsson_coli_iJR904_xspec() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "coli/iJR904-reacts-xspec.csv"), new File(FOLDER_OUT, "iJR904_xspec.m"));
    }

    public void testPalsson_coli_iJR904_xnone() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "coli/iJR904(7-28-04)-reacts-xnone.csv"), new File(FOLDER_OUT, "iJR904_xnone.m"));
    }

    public void testPalsson_coli_iJR904_minimal() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "coli/iJR904(7-28-04)-reacts-minimal.csv"), new File(FOLDER_OUT, "iJR904_minimal.m"));
    }

    public void testPalsson_coli_iJR904_xnone_nobio() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "coli/iJR904(7-28-04)-reacts-xnone_nobio.csv"), new File(FOLDER_OUT, "iJR904_xnonenobio.m"));
    }

    public void testPalsson_coli_iJR904_fba_reduced_ac() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "coli/iJR904-fba-reduced_ac.csv"), new File(FOLDER_OUT, "iJR904_fba_reduced_ac.m"));
    }

    public void testPalsson_coli_iJR904_fba_reduced() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "coli/iJR904-fba-reduced.csv"), new File(FOLDER_OUT, "iJR904_fba_reduced.m"));
    }

    public void testPalsson_coli_iJR904_fba_reduced_xnone() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "coli/iJR904-fba-reduced_xnone.csv"), new File(FOLDER_OUT, "iJR904_fba_reduced_xnone.m"));
    }

    public void testPalsson_coli_Robert() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestPalsson(new File(FOLDER_IN, "coli/coliRobert.csv"), new File(FOLDER_OUT, "coliRobert.m"), externalPattern, null);
    }

    public void testPalsson_coli_Robert_reduced() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestPalsson(new File(FOLDER_IN, "coli/coliRobert.csv"), new File(FOLDER_OUT, "coliRobert.m"), externalPattern, new String[]{"extract_SUCC", "extract_PYR", "focA", "mglABC", "maint_ATP"});
    }

    public void testPalsson_subtilisPalsson07() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "subtilis/bacillus-subtilis-palsson-07.csv"), new File(FOLDER_OUT, "subtilisPalsson07.m"));
    }

    public void testPalsson_aureus_iSB619_xrev() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "staph_aureus/iSB619-reacts-xrev.csv"), new File(FOLDER_OUT, "iSB619_xrev.m"));
    }

    public void testPalsson_aureus_iSB619_xspec() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "staph_aureus/iSB619-reacts-xspec.csv"), new File(FOLDER_OUT, "iSB619_xspec.m"));
    }

    public void testPalsson_aureus_iSB619_xnone() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "staph_aureus/iSB619-reacts-xnone.csv"), new File(FOLDER_OUT, "iSB619_xnone.m"));
    }

    public void testPalsson_aureus_iSB619_opt() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "staph_aureus/iSB619-opt.csv"), new File(FOLDER_OUT, "iSB619_opt.m"));
    }

    public void testPalsson_aureus_iMH556() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "staph_aureus/iMH556.csv"), new File(FOLDER_OUT, "iMH556.m"));
    }

    public void testPalsson_barkeri_iAF692_xspec() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "barkeri/mbarkeri-iAF692.csv"), new File(FOLDER_OUT, "iAF692_xspec.m"));
    }

    public void testPalsson_barkeri_iAF692_opt() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "barkeri/iAF692-opt.csv"), new File(FOLDER_OUT, "iAF692_opt.m"));
    }

    public void testPalsson_pylori_iIT341_xspec() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341.csv"), new File(FOLDER_OUT, "iIT341_xspec.m"));
    }

    public void testPalsson_pylori_iIT341_glc() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341-glc.csv"), new File(FOLDER_OUT, "iIT341_glc.m"));
    }

    public void testPalsson_pylori_iIT341_glcopt() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341-glcopt.csv"), new File(FOLDER_OUT, "iIT341_glcopt.m"));
    }

    public void testPalsson_pylori_iIT341_glcmin() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341-glcmin.csv"), new File(FOLDER_OUT, "iIT341_glcmin.m"));
    }

    public void testPalsson_pylori_iIT341_redin() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341-redin.csv"), new File(FOLDER_OUT, "iIT341_redin.m"));
    }

    public void testPalsson_pylori_iIT341_xnone() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341-xnone.csv"), new File(FOLDER_OUT, "iIT341_xnone.m"));
    }

    public void testPalsson_pylori_iIT341_aminomin() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341-aminomin.csv"), new File(FOLDER_OUT, "iIT341_aminomin.m"));
    }

    public void testPalsson_pylori_iIT341_aminoglcmin() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341-aminoglcmin.csv"), new File(FOLDER_OUT, "iIT341_aminoglcmin.m"));
    }

    public void testPalsson_pylori_iIT341_aminominGlnGly() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/iIT341-aminoGlnGly.csv"), new File(FOLDER_OUT, "iIT341_aminoGlnGly.m"));
    }

    public void testPalsson_pylori_iCS291() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/pylori_model_v10_iCS291.csv"), new File(FOLDER_OUT, "pylori_model_v10_iCS291.m"), externalPattern, null);
    }

    public void testPalsson_pylori_iCS291_glcamino() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/pylori_model_v10_iCS291_glcamino.csv"), new File(FOLDER_OUT, "pylori_model_v10_iCS291_glcamino.m"));
    }

    public void testPalsson_pylori_iCS291_specamino() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/pylori_model_v10_iCS291_specamino.csv"), new File(FOLDER_OUT, "pylori_model_v10_iCS291_specamino.m"));
    }

    public void testPalsson_pylori_iCS291_amino() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "pylori/pylori_model_v10_iCS291_amino.csv"), new File(FOLDER_OUT, "pylori_model_v10_iCS291_amino.m"));
    }

    public void testPalsson_yeastc_iND750_xnone() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "yeast-cerevisiae/iND750-reacts.csv"), new File(FOLDER_OUT, "iND750_xnone.m"), null, null);
    }

    public void testPalsson_yeastc_iND750() throws Exception {
        Pattern externalPattern = Pattern.compile(".*\\[e\\]");
        this.internalTestPalsson(new File(FOLDER_IN, "yeast-cerevisiae/iND750-reacts.csv"), new File(FOLDER_OUT, "iND750.m"), externalPattern, null);
    }

    public void testPalsson_yeastc_iLL672() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt");
        this.internalTestPalsson(new File(FOLDER_IN, "yeast-cerevisiae/iLL672-reacts.csv"), new File(FOLDER_OUT, "iLL672.m"), externalPattern, null);
    }

    public void testPalsson_yeastc_iLL672_xnone() throws Exception {
        this.internalTestPalsson(new File(FOLDER_IN, "yeast-cerevisiae/iLL672-reacts.csv"), new File(FOLDER_OUT, "iLL672.m"), null, null);
    }

    public void testPalsson_yeastc_iLL672_unbalancedMetas() throws Exception {
        Pattern externalPattern = Pattern.compile(".*xt|TRE|GLYCOGEN|CLm|DEAC|PAP|RADP|SAMOB|THFG");
        this.internalTestPalsson(new File(FOLDER_IN, "yeast-cerevisiae/iLL672-reacts.csv"), new File(FOLDER_OUT, "iLL672_unbalanced.m"), externalPattern, null);
    }

    private void internalTestPalsson(File inFile, File outFile) throws Exception {
        this.internalTestPalsson(inFile, outFile, null, null);
    }

    private void internalTestPalsson(File inFile, File outFile, Pattern externalPattern, String[] excludeReactions) throws Exception {
        this.fileOut.set(outFile);
        Reaction[] reacts = externalPattern == null ? new PalssonParser().parseReactions(inFile) : new PalssonParser().parseReactions(inFile, externalPattern);
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(reacts);
        System.out.println("parsed network: " + PalssonTest.netSize(metaNet));
        Set<String> suppressedReacs = Arrays.asSet(excludeReactions);
        this.internalTestOrDelegate(metaNet, suppressedReacs);
    }

    private static String netSize(MetabolicNetwork net) {
        return String.valueOf(net.getMetabolites().length()) + " metabolites, " + net.getReactions().length() + " reactions";
    }
}

