/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.ExcelParser;
import ch.javasoft.metabolic.parse.FluxAnalyserParser;
import ch.javasoft.metabolic.parse.JUnitTestCaseParser;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.parse.SbmlParser;
import ch.javasoft.metabolic.parse.StoichParser;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import ch.javasoft.xml.config.ConstConfigParser;
import ch.javasoft.xml.config.FileConfigParser;
import ch.javasoft.xml.config.StreamConfigParser;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlNode;
import ch.javasoft.xml.config.XmlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ConfiguredParser {
    public static MetabolicNetwork parseConfig(Element parentElement) throws XmlConfigException, IOException {
        Element parseElement = XmlUtil.getRequiredSingleChildElement(parentElement, XmlElements.metabolic_parse);
        return ConfiguredParser.parse(parseElement);
    }

    public static MetabolicNetwork parse(Element metabolicParseElement) throws XmlConfigException, IOException {
        XmlUtil.checkExpectedElementName(metabolicParseElement, XmlElements.metabolic_parse);
        Element parseElement = XmlUtil.getRequiredSingleChildElement(metabolicParseElement, XmlElements.parse);
        String type = parseElement.attributeValue(XmlAttributes.type.getXmlName());
        ParseType pType = ParseType.find(type);
        if (pType == null) {
            throw new XmlConfigException("unknown parse type '" + type + "'", (Node)parseElement);
        }
        switch (pType) {
            case flux_analyzer: {
                return ConfiguredParser.parseFluxAnalyzer(parseElement);
            }
            case reaction_list: {
                return ConfiguredParser.parseReactionList(parseElement);
            }
            case reaction_excel: {
                return ConfiguredParser.parseReactionExcel(parseElement);
            }
            case stoichiometry: {
                return ConfiguredParser.parseStoichiometry(parseElement);
            }
            case sbml: {
                return ConfiguredParser.parseSbml(parseElement);
            }
            case junit: {
                return ConfiguredParser.parseJUnit(parseElement);
            }
        }
        throw new XmlConfigException("internal error: unknown parse type " + (Object)((Object)pType), (Node)parseElement);
    }

    private static MetabolicNetwork parseFluxAnalyzer(Element parseElement) throws XmlConfigException, IOException {
        List inputs = parseElement.elements(XmlElements.input.getXmlName());
        if (inputs.size() == 1) {
            Element input = (Element)inputs.get(0);
            XmlUtil.checkExpectedAttributeValue(input, XmlAttributes.name, FluxAnalyzerFileType.directory.getXmlName());
            Element fileEl = XmlUtil.getRequiredSingleChildElement(input, XmlElements.file);
            File file = FileConfigParser.parseFile(fileEl);
            return FluxAnalyserParser.parse(file);
        }
        if (inputs.size() == 3) {
            Element inReactions = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, FluxAnalyzerFileType.reactions_file.getXmlName(), true);
            Element inMacromolecules = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, FluxAnalyzerFileType.macromolecules_file.getXmlName(), true);
            Element inMacromolSynth = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, FluxAnalyzerFileType.macromolecule_synthesis_file.getXmlName(), true);
            InputStream stReactions = StreamConfigParser.parseInputStream(inReactions);
            InputStream stMacromolecules = StreamConfigParser.parseInputStream(inMacromolecules);
            InputStream stMacromolSynth = StreamConfigParser.parseInputStream(inMacromolSynth);
            return FluxAnalyserParser.parse(stReactions, stMacromolecules, stMacromolSynth);
        }
        throw new XmlConfigException("expected input directory or 3 input files for flux analyzer parse config", (Node)parseElement);
    }

    private static MetabolicNetwork parseReactionList(Element parseElement) throws XmlConfigException, IOException {
        Element input = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.input);
        Pattern externalPat = ConfiguredParser.parseExternalPattern(parseElement);
        InputStream in = StreamConfigParser.parseInputStream(input);
        Reaction[] reacts = externalPat == null ? new PalssonParser().parseReactions(in) : new PalssonParser().parseReactions(in, externalPat);
        return new DefaultMetabolicNetwork(reacts);
    }

    private static MetabolicNetwork parseReactionExcel(Element parseElement) throws XmlConfigException, IOException {
        Element inputFile = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, ExcelInputType.excel_file.getXmlName(), true);
        Element inputSheet = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, ExcelInputType.excel_sheet.getXmlName(), false);
        Element inputRCol = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, ExcelInputType.reaction_column.getXmlName(), true);
        Element inputRNCol = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, ExcelInputType.reaction_name_column.getXmlName(), true);
        Element inputHRows = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, ExcelInputType.header_rows.getXmlName(), true);
        Pattern externalPat = ConfiguredParser.parseExternalPattern(parseElement);
        int sheetIndex = 0;
        String sheetName = null;
        if (inputSheet != null) {
            Element elConst = XmlUtil.getRequiredSingleChildElement(inputSheet, XmlElements.const_);
            try {
                sheetIndex = ConstConfigParser.parseIntConstant(elConst);
            }
            catch (Exception e) {
                try {
                    sheetName = ConstConfigParser.parseStringConstant(elConst, false);
                }
                catch (Exception e2) {
                    throw new XmlConfigException("string or int value expected for " + (Object)((Object)ExcelInputType.excel_sheet) + ", e=" + e2, (Node)elConst);
                }
            }
        }
        Element elFile = XmlUtil.getRequiredSingleChildElement(inputFile, XmlElements.file);
        File file = FileConfigParser.parseFile(elFile);
        ExcelParser parser = sheetName == null ? new ExcelParser(file, sheetIndex - 1) : new ExcelParser(file, sheetName);
        int reactCol = ConstConfigParser.parseIntConstant(XmlUtil.getRequiredSingleChildElement(inputRCol, XmlElements.const_));
        int reactNameColumn = ConstConfigParser.parseIntConstant(XmlUtil.getRequiredSingleChildElement(inputRNCol, XmlElements.const_));
        int headerRows = ConstConfigParser.parseIntConstant(XmlUtil.getRequiredSingleChildElement(inputHRows, XmlElements.const_));
        if (externalPat == null) {
            return parser.parse(reactCol, reactNameColumn, headerRows);
        }
        return parser.parse(reactCol - 1, reactNameColumn - 1, headerRows, externalPat);
    }

    private static MetabolicNetwork parseStoichiometry(Element parseElement) throws XmlConfigException, IOException {
        Element elStoich = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, StoichInputType.stoichiometry_file.getXmlName(), true);
        Element elRev = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, StoichInputType.reversibilities_file.getXmlName(), false);
        Element elMetaNames = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, StoichInputType.metabolite_names_file.getXmlName(), true);
        Element elReacNames = XmlUtil.getChildElementByAttributeValue(parseElement, XmlElements.input, XmlAttributes.name, StoichInputType.reaction_names_file.getXmlName(), true);
        Element elSeparator = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.separator);
        String separator = XmlUtil.getRequiredAttributeValue(elSeparator, XmlAttributes.value);
        BufferedReader rdStoich = ConfiguredParser.toBufferedReader(StreamConfigParser.parseInputStream(elStoich));
        BufferedReader rdRev = ConfiguredParser.toBufferedReader(StreamConfigParser.parseInputStream(elRev));
        BufferedReader rdMetaNames = ConfiguredParser.toBufferedReader(StreamConfigParser.parseInputStream(elMetaNames));
        BufferedReader rdReacNames = ConfiguredParser.toBufferedReader(StreamConfigParser.parseInputStream(elReacNames));
        StoichParser parser = separator.trim().length() == 0 ? StoichParser.getWhitespaceSeparatedStoichParser() : StoichParser.getSeparatorStoichParser(separator);
        return parser.parse(rdStoich, rdMetaNames, rdReacNames, rdRev);
    }

    private static final BufferedReader toBufferedReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in));
    }

    private static MetabolicNetwork parseSbml(Element parseElement) throws XmlConfigException, IOException {
        Element elInput = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.input);
        Element elExtCmp = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.external_compartment);
        Element elSbmlVal = parseElement.element(XmlElements.sbml_validate_schema.getXmlName());
        String extCmp = XmlUtil.getRequiredAttributeValue(elExtCmp, XmlAttributes.name);
        boolean validate = true;
        if (elSbmlVal != null) {
            Element cnst = XmlUtil.getRequiredSingleChildElement(elSbmlVal, XmlElements.const_);
            validate = ConstConfigParser.parseBooleanConstant(cnst);
        }
        InputStream in = StreamConfigParser.parseInputStream(elInput);
        try {
            return new SbmlParser(extCmp, validate).parse(in);
        }
        catch (DocumentException ex) {
            throw new IOException("cannot parse sbml document, e=" + (Object)((Object)ex));
        }
    }

    private static MetabolicNetwork parseJUnit(Element parseElement) throws XmlConfigException {
        Exception ex;
        String errMsg;
        Element elTest = XmlUtil.getRequiredSingleChildElement(parseElement, XmlElements.test);
        String className = XmlUtil.getRequiredAttributeValue(elTest, XmlAttributes.class_);
        String methodName = XmlUtil.getRequiredAttributeValue(elTest, XmlAttributes.method);
        try {
            AbstractParseTestCase testCase = (AbstractParseTestCase)((Object)Class.forName(className).newInstance());
            MetabolicNetwork net = JUnitTestCaseParser.parse(testCase, methodName);
            if (net != null) {
                return net;
            }
            errMsg = "unit test method " + className + "." + methodName + " did not yield a metabolic network";
            ex = null;
        }
        catch (ClassNotFoundException e) {
            errMsg = "no such unit test: " + className;
            ex = e;
        }
        catch (InstantiationException e) {
            errMsg = "cannot instantiate unit test " + className + ", e=" + e;
            ex = e;
        }
        catch (Exception e) {
            errMsg = "cannot invoke unit test method " + className + "." + methodName + ", e=" + e;
            ex = e;
        }
        XmlConfigException xex = new XmlConfigException(errMsg, (Node)elTest);
        if (ex != null) {
            xex.initCause(ex);
        }
        throw xex;
    }

    private static Pattern parseExternalPattern(Element parseElement) throws XmlConfigException {
        Element external = parseElement.element(XmlElements.external.getXmlName());
        Pattern externalPat = null;
        if (external != null) {
            String patString = external.attributeValue(XmlAttributes.pattern.getXmlName());
            try {
                externalPat = Pattern.compile(patString);
            }
            catch (Exception ex) {
                throw new XmlConfigException("cannot parse external pattern '" + patString + "', e=" + ex, (Node)external, (Throwable)ex);
            }
        }
        return externalPat;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExcelInputType {
        excel_file,
        excel_sheet,
        reaction_column,
        reaction_name_column,
        header_rows;


        String getXmlName() {
            return this.name().replaceAll("_", "-");
        }

        static ExcelInputType find(String type) {
            ExcelInputType[] excelInputTypeArray = ExcelInputType.values();
            int n = excelInputTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExcelInputType eType = excelInputTypeArray[n2];
                if (eType.getXmlName().equals(type)) {
                    return eType;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FluxAnalyzerFileType {
        directory,
        reactions_file,
        macromolecules_file,
        macromolecule_synthesis_file;


        String getXmlName() {
            return this.name().replaceAll("_", "-");
        }

        static FluxAnalyzerFileType find(String type) {
            FluxAnalyzerFileType[] fluxAnalyzerFileTypeArray = FluxAnalyzerFileType.values();
            int n = fluxAnalyzerFileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FluxAnalyzerFileType fType = fluxAnalyzerFileTypeArray[n2];
                if (fType.getXmlName().equals(type)) {
                    return fType;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParseType {
        flux_analyzer,
        reaction_list,
        reaction_excel,
        stoichiometry,
        sbml,
        junit;


        String getXmlName() {
            return this.name().replaceAll("_", "-");
        }

        static ParseType find(String type) {
            ParseType[] parseTypeArray = ParseType.values();
            int n = parseTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParseType pType = parseTypeArray[n2];
                if (pType.getXmlName().equals(type)) {
                    return pType;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoichInputType {
        stoichiometry_file,
        reversibilities_file,
        metabolite_names_file,
        reaction_names_file;


        String getXmlName() {
            return this.name().replaceAll("_", "-");
        }

        static StoichInputType find(String type) {
            StoichInputType[] stoichInputTypeArray = StoichInputType.values();
            int n = stoichInputTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StoichInputType sType = stoichInputTypeArray[n2];
                if (sType.getXmlName().equals(type)) {
                    return sType;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlAttributes implements XmlNode
    {
        type,
        name,
        value,
        pattern,
        validate,
        class_,
        method;


        @Override
        public String getXmlName() {
            return this == class_ ? "class" : this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlElements implements XmlNode
    {
        metabolic_parse,
        parse,
        input,
        file,
        const_,
        separator,
        external,
        external_compartment,
        sbml_validate_schema,
        test;


        @Override
        public String getXmlName() {
            return this == const_ ? "const" : this.name().replaceAll("_", "-");
        }
    }
}

