/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.parse.StoichParser;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.regex.Pattern;

public abstract class AnneTest
extends AbstractParseTestCase {
    private static final File FOLDER_DATA = new File("../metabolic-data/anne/");

    public void testAnneYeast_all() throws Exception {
        this.internalTest(new File(FOLDER_DATA, "anne_yeast_all.csv"));
    }

    public void testAnneYeast_glc() throws Exception {
        this.internalTest(new File(FOLDER_DATA, "anne_yeast_glc.csv"));
    }

    public void testAnneYeast_eth() throws Exception {
        this.internalTest(new File(FOLDER_DATA, "anne_yeast_eth.csv"));
    }

    public void testAnneYeast_iAK0815_Glc_Etoh() throws Exception {
        this.internalTestStoich("iAK0815_Glc_Etoh-stoich.txt", "iAK0815_Glc_Etoh-mnames.txt", "iAK0815_Glc_Etoh-rnames.txt", "iAK0815_Glc_Etoh-revs.txt");
    }

    public void testAnneYeast_iAK0815_Glc() throws Exception {
        this.internalTestStoich("iAK0815_Glc-stoich.txt", "iAK0815_Glc-mnames.txt", "iAK0815_Glc-rnames.txt", "iAK0815_Glc-revs.txt");
    }

    public void testAnneYeast_iAK0815_Etoh() throws Exception {
        this.internalTestStoich("iAK0815_Etoh-stoich.txt", "iAK0815_Etoh-mnames.txt", "iAK0815_Etoh-rnames.txt", "iAK0815_Etoh-revs.txt");
    }

    private void internalTest(File file) throws Exception {
        this.internalTest(file, null);
    }

    private void internalTestStoich(String fStoich, String fMetaNames, String fReacNames, String fRev) throws Exception {
        this.internalTestStoich(new File(FOLDER_DATA, fStoich), new File(FOLDER_DATA, fMetaNames), new File(FOLDER_DATA, fReacNames), new File(FOLDER_DATA, fRev));
    }

    private void internalTestStoich(File fStoich, File fMetaNames, File fReacNames, File fRev) throws Exception {
        BufferedReader rdStoich = new BufferedReader(new FileReader(fStoich));
        BufferedReader rdMetaNames = new BufferedReader(new FileReader(fMetaNames));
        BufferedReader rdReacNames = new BufferedReader(new FileReader(fReacNames));
        BufferedReader rdRev = new BufferedReader(new FileReader(fRev));
        StoichParser parser = StoichParser.getWhitespaceSeparatedStoichParser();
        MetabolicNetwork metaNet = parser.parse(rdStoich, rdMetaNames, rdReacNames, rdRev);
        this.internalTestOrDelegate(metaNet, null);
    }

    private void internalTest(File file, Pattern externalPattern) throws Exception {
        Reaction[] reacts = externalPattern == null ? new PalssonParser().parseReactions(file) : new PalssonParser().parseReactions(file, externalPattern);
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(reacts);
        System.out.println("parsed network: " + AnneTest.netSize(metaNet));
        this.internalTestOrDelegate(metaNet, null);
    }

    private static String netSize(MetabolicNetwork net) {
        return String.valueOf(net.getMetabolites().length()) + " metabolites, " + net.getReactions().length() + " reactions";
    }
}

