/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.BigFractionOperations;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Norm;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.impl.AbstractFluxDistribution;
import ch.javasoft.metabolic.util.FluxNormalizer;
import ch.javasoft.util.numeric.Zero;
import java.math.BigInteger;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionNumberFluxDistribution
extends AbstractFluxDistribution {
    private final BigFraction[] mRates;

    public FractionNumberFluxDistribution(MetabolicNetwork network, BigInteger[] rates) {
        super(network);
        BigFraction[] frac = new BigFraction[rates.length];
        int i = 0;
        while (i < frac.length) {
            frac[i] = BigFraction.valueOf(rates[i]);
            ++i;
        }
        this.mRates = frac;
    }

    public FractionNumberFluxDistribution(MetabolicNetwork network, BigFraction[] rates) {
        super(network);
        this.mRates = rates;
    }

    @Override
    public int getSize() {
        return this.mRates.length;
    }

    @Override
    public BigFraction getNumberRate(Reaction reaction) {
        int index = this.getReactionIndex(reaction);
        if (index < 0) {
            throw new IllegalArgumentException("no such reaction in the network: " + reaction);
        }
        return this.getNumberRate(index);
    }

    @Override
    public BigFraction getNumberRate(int index) {
        return this.mRates[index];
    }

    @Override
    public int getRateSignum(int index) {
        return this.mRates[index].signum();
    }

    public Number getCombinedRate(int indexForward, int indexBackward) {
        BigFraction result = this.mRates[indexForward].subtract(this.mRates[indexBackward]);
        result.reduce();
        return result;
    }

    @Override
    public void setRate(int index, Number rate) {
        this.mRates[index] = BigFraction.valueOf(rate);
    }

    @Override
    public void setRate(Reaction reaction, Number rate) {
        int index = this.getReactionIndex(reaction);
        if (index < 0) {
            throw new IllegalArgumentException("no such reaction in the network: " + reaction);
        }
        this.setRate(index, rate);
    }

    public Class<BigFraction> getPreferredNumberClass() {
        return BigFraction.class;
    }

    @Override
    public void norm(Norm norm, Zero zero) {
        switch (norm) {
            case max: {
                FluxNormalizer.normalizeMax((MetabolicNetwork)this.mNetwork, (Number[])this.mRates, (NumberOperations)BigFractionOperations.instance(), (Zero)zero);
                break;
            }
            case min: {
                FluxNormalizer.normalizeMin((MetabolicNetwork)this.mNetwork, (Number[])this.mRates, (NumberOperations)BigFractionOperations.instance(), (Zero)zero);
                break;
            }
            case norm2: {
                FluxNormalizer.normalizeNorm2((MetabolicNetwork)this.mNetwork, (Number[])this.mRates, (NumberOperations)BigFractionOperations.instance(), (Zero)zero);
                break;
            }
            case squared: {
                FluxNormalizer.normalizeSquared((MetabolicNetwork)this.mNetwork, (Number[])this.mRates, (NumberOperations)BigFractionOperations.instance(), (Zero)zero);
                break;
            }
            case none: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported normalization: " + (Object)((Object)norm));
            }
        }
    }

    @Override
    public FractionNumberFluxDistribution clone() {
        return new FractionNumberFluxDistribution(this.mNetwork, (BigFraction[])this.mRates.clone());
    }

    @Override
    public FractionNumberFluxDistribution create(MetabolicNetwork net) {
        Object[] rates = new BigFraction[net.getReactions().length()];
        Arrays.fill(rates, BigFraction.ZERO);
        return new FractionNumberFluxDistribution(net, (BigFraction[])rates);
    }
}

