/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetabolicNetworkVisitor;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;

public class DefaultMetaboliteRatio
implements MetaboliteRatio {
    private final Metabolite mMetabolite;
    private final double mRatio;

    public DefaultMetaboliteRatio(Metabolite metabolite, double ratio) {
        this.mMetabolite = metabolite;
        this.mRatio = ratio;
    }

    public Metabolite getMetabolite() {
        return this.mMetabolite;
    }

    public double getRatio() {
        return this.mRatio;
    }

    public Double getNumberRatio() {
        return this.getRatio();
    }

    public boolean isEduct() {
        return this.mRatio < 0.0;
    }

    public String toString() {
        return DefaultMetaboliteRatio.toString(this.mRatio, this.mMetabolite);
    }

    public String toStringAbs() {
        return DefaultMetaboliteRatio.toString(Math.abs(this.mRatio), this.mMetabolite);
    }

    public static String toString(double value, Metabolite metabolite) {
        int intVal = (int)value;
        if ((double)intVal == value) {
            if (intVal == 1) {
                return metabolite.toString();
            }
            return String.valueOf(String.valueOf(intVal)) + " " + metabolite;
        }
        return String.valueOf(String.valueOf(value)) + " " + metabolite;
    }

    public boolean isIntegerRatio() {
        return (double)((int)this.mRatio) == this.mRatio;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.mRatio);
        return this.mMetabolite.hashCode() ^ (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            MetaboliteRatio ratio = (MetaboliteRatio)obj;
            return this.mMetabolite.equals(ratio.getMetabolite()) && this.mRatio == ratio.getRatio();
        }
        return false;
    }

    public void accept(MetabolicNetworkVisitor visitor) {
        visitor.visitMetaboliteRatio(this);
    }

    public DefaultMetaboliteRatio invert() {
        return new DefaultMetaboliteRatio(this.mMetabolite, this.mRatio);
    }
}

