/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetabolicNetworkVisitor;
import ch.javasoft.metabolic.Metabolite;

public class DefaultMetabolite
implements Metabolite {
    private final String mName;
    private final String mDesc;

    public DefaultMetabolite(int index) {
        this(DefaultMetabolite.name(index));
    }

    public DefaultMetabolite(String name) {
        this(name, null);
    }

    public DefaultMetabolite(String name, String description) {
        if (name == null) {
            throw new NullPointerException("null name not allowed");
        }
        this.mName = name;
        this.mDesc = description;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDesc;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Metabolite && this.mName.equals(((Metabolite)obj).getName());
    }

    public String toString() {
        return this.getName();
    }

    public void accept(MetabolicNetworkVisitor visitor) {
        visitor.visitMetabolite(this);
    }

    public static String name(int index) {
        int charRange = 26;
        StringBuilder sb = new StringBuilder();
        do {
            char ch = (char)(65 + index % charRange);
            index = index / charRange - 1;
            sb.insert(0, ch);
        } while (index >= 0);
        return sb.toString();
    }

    public static String[] names(int count, String prefix) {
        String[] res = new String[count];
        int ii = 0;
        while (ii < res.length) {
            res[ii] = String.valueOf(prefix) + DefaultMetabolite.name(ii);
            ++ii;
        }
        return res;
    }

    public static void main(String[] args) {
        System.out.println(DefaultMetabolite.name(0));
        System.out.println(DefaultMetabolite.name(20));
        System.out.println(DefaultMetabolite.name(23));
        System.out.println(DefaultMetabolite.name(24));
        System.out.println(DefaultMetabolite.name(25));
        System.out.println(DefaultMetabolite.name(26));
        System.out.println(DefaultMetabolite.name(27));
        System.out.println(DefaultMetabolite.name(50));
        System.out.println(DefaultMetabolite.name(51));
        System.out.println(DefaultMetabolite.name(52));
        System.out.println(DefaultMetabolite.name(649));
        System.out.println(DefaultMetabolite.name(650));
        System.out.println(DefaultMetabolite.name(651));
        System.out.println(DefaultMetabolite.name(652));
        System.out.println(DefaultMetabolite.name(675));
        System.out.println(DefaultMetabolite.name(676));
        System.out.println(DefaultMetabolite.name(677));
        System.out.println(DefaultMetabolite.name(700));
        System.out.println(DefaultMetabolite.name(701));
        System.out.println(DefaultMetabolite.name(702));
        System.out.println(DefaultMetabolite.name(703));
        System.out.println(DefaultMetabolite.name(5487));
    }
}

