/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.impl.AbstractMetabolicNetwork;
import ch.javasoft.metabolic.impl.AbstractNamedReaction;
import ch.javasoft.metabolic.impl.DefaultMetabolite;
import ch.javasoft.metabolic.impl.DefaultMetaboliteRatio;
import ch.javasoft.metabolic.impl.DefaultReactionConstraints;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.util.genarr.AbstractArrayIterable;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMetabolicNetwork
extends AbstractMetabolicNetwork {
    private GenericDynamicArray<? extends Metabolite> mMetabolites;
    private GenericDynamicArray<? extends Reaction> mReactions;

    public DefaultMetabolicNetwork(double[][] stoichMatrix, boolean[] reversible) {
        this(DefaultMetabolicNetwork.metabolites(DefaultMetabolicNetwork.metaboliteNames(stoichMatrix)), DefaultMetabolicNetwork.reactionNames(stoichMatrix), stoichMatrix, reversible);
    }

    public DefaultMetabolicNetwork(String[] metaboliteNames, String[] reactionNames, double[][] stoichMatrix, boolean[] reversible) {
        this(DefaultMetabolicNetwork.metabolites(metaboliteNames), reactionNames, stoichMatrix, reversible);
    }

    public DefaultMetabolicNetwork(String[] metaboliteNames, String[] reactionNames, double[][] stoichMatrix, ReactionConstraints[] constraints) {
        this(DefaultMetabolicNetwork.metabolites(metaboliteNames), reactionNames, stoichMatrix, constraints);
    }

    public DefaultMetabolicNetwork(Metabolite[] metabolites, String[] reactionNames, double[][] stoichMatrix, boolean[] reversible) {
        this(metabolites, DefaultMetabolicNetwork.reactions(metabolites, reactionNames, stoichMatrix, reversible));
    }

    public DefaultMetabolicNetwork(Metabolite[] metabolites, String[] reactionNames, double[][] stoichMatrix, ReactionConstraints[] constraints) {
        this(metabolites, DefaultMetabolicNetwork.reactions(metabolites, reactionNames, stoichMatrix, constraints));
    }

    public DefaultMetabolicNetwork(Reaction[] reactions) {
        this(DefaultMetabolicNetwork.metabolites(reactions), reactions);
    }

    public DefaultMetabolicNetwork(Iterable<? extends Metabolite> metabolites, Iterable<? extends Reaction> reactions) {
        this(new GenericDynamicArray<Metabolite>(metabolites), new GenericDynamicArray<Reaction>(reactions));
    }

    public DefaultMetabolicNetwork(Metabolite[] metabolites, Reaction[] reactions) {
        this(new GenericDynamicArray<Metabolite>(metabolites), new GenericDynamicArray<Reaction>(reactions));
    }

    public DefaultMetabolicNetwork(GenericDynamicArray<? extends Metabolite> metabolites, GenericDynamicArray<? extends Reaction> reactions) {
        this.mMetabolites = metabolites;
        this.mReactions = reactions;
    }

    @Override
    public ArrayIterable<? extends Metabolite> getMetabolites() {
        return this.mMetabolites;
    }

    @Override
    public ArrayIterable<? extends Reaction> getReactions() {
        return this.mReactions;
    }

    public DoubleMatrix getStoichiometricMatrix() {
        return new DefaultDoubleMatrix(StoichiometricMatrices.createStoichiometricMatrix(this), true);
    }

    public static String[] metaboliteNames(double[][] stoichMatrix) {
        return DefaultMetabolicNetwork.metaboliteNames(stoichMatrix.length);
    }

    public static String[] metaboliteNames(int length) {
        return DefaultMetabolite.names(length, DefaultMetabolicNetwork.metabolitePrefix());
    }

    public static String[] reactionNames(double[][] stoichMatrix) {
        return DefaultMetabolicNetwork.reactionNames(stoichMatrix.length == 0 ? 0 : stoichMatrix[0].length);
    }

    public static String[] reactionNames(int length) {
        return DefaultMetabolicNetwork.names(length, DefaultMetabolicNetwork.reactionPrefix());
    }

    private static String[] names(int count, String prefix) {
        String[] names = new String[count];
        int len = String.valueOf(names.length - 1).length();
        StringBuffer zeros = new StringBuffer(len);
        int ii = 0;
        while (ii < len) {
            zeros.append('0');
            ++ii;
        }
        ii = 0;
        while (ii < names.length) {
            String sII = String.valueOf(ii);
            names[ii] = String.valueOf(prefix) + zeros.substring(0, zeros.length() - sII.length()) + sII;
            ++ii;
        }
        return names;
    }

    public static Metabolite[] metabolites(Reaction[] reactions) {
        LinkedHashSet<Metabolite> metas = new LinkedHashSet<Metabolite>();
        Reaction[] reactionArray = reactions;
        int n = reactions.length;
        int n2 = 0;
        while (n2 < n) {
            Reaction reac = reactionArray[n2];
            for (MetaboliteRatio metaboliteRatio : reac.getMetaboliteRatios()) {
                if (metas.contains(metaboliteRatio.getMetabolite())) continue;
                metas.add(metaboliteRatio.getMetabolite());
            }
            ++n2;
        }
        Metabolite[] res = new Metabolite[metas.size()];
        metas.toArray(res);
        return res;
    }

    public static Metabolite[] metabolites(String[] metaboliteNames) {
        Metabolite[] metabolites = new Metabolite[metaboliteNames.length];
        int ii = 0;
        while (ii < metabolites.length) {
            metabolites[ii] = new DefaultMetabolite(metaboliteNames[ii]);
            ++ii;
        }
        return metabolites;
    }

    private static Reaction[] reactions(Metabolite[] metabolites, String[] reactionNames, double[][] stoichMatrix, boolean[] reversible) {
        ReactionConstraints[] constr = new ReactionConstraints[reactionNames.length];
        int ii = 0;
        while (ii < constr.length) {
            constr[ii] = ii < reversible.length && reversible[ii] ? DefaultReactionConstraints.DEFAULT_REVERSIBLE : DefaultReactionConstraints.DEFAULT_IRREVERSIBLE;
            ++ii;
        }
        return DefaultMetabolicNetwork.reactions(metabolites, reactionNames, stoichMatrix, constr);
    }

    private static Reaction[] reactions(final Metabolite[] metabolites, String[] reactionNames, final double[][] stoichMatrix, final ReactionConstraints[] constr) {
        Reaction[] reactions = new Reaction[reactionNames.length];
        int ii = 0;
        while (ii < reactions.length) {
            final int reactionIndex = ii;
            final int[] metaIndices = DefaultMetabolicNetwork.getMetaboliteIndices(stoichMatrix, reactionIndex);
            reactions[ii] = new AbstractNamedReaction(reactionNames[reactionIndex]){

                @Override
                public ReactionConstraints getConstraints() {
                    return constr[reactionIndex];
                }

                public ArrayIterable<MetaboliteRatio> getMetaboliteRatios() {
                    return new AbstractArrayIterable<MetaboliteRatio>(){

                        @Override
                        public int length() {
                            return metaIndices.length;
                        }

                        @Override
                        public MetaboliteRatio get(int index) throws IndexOutOfBoundsException {
                            return new DefaultMetaboliteRatio(metabolites[metaIndices[index]], stoichMatrix[metaIndices[index]][reactionIndex]);
                        }
                    };
                }
            };
            ++ii;
        }
        return reactions;
    }

    private static int[] getMetaboliteIndices(double[][] stoichMatrix, int reactionIndex) {
        int[] tmp = new int[stoichMatrix.length];
        int cnt = 0;
        int ii = 0;
        while (ii < stoichMatrix.length) {
            if (stoichMatrix[ii][reactionIndex] != 0.0) {
                tmp[cnt] = ii;
                ++cnt;
            }
            ++ii;
        }
        int[] result = new int[cnt];
        System.arraycopy(tmp, 0, result, 0, cnt);
        return result;
    }

    private static String metabolitePrefix() {
        return "";
    }

    private static String reactionPrefix() {
        return "R";
    }
}

