/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.metabolic.MetabolicNetworkVisitor;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericArray;
import ch.javasoft.util.genarr.GenericDynamicArray;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReaction
implements Reaction {
    @Override
    public abstract String getName();

    @Override
    public abstract ArrayIterable<? extends MetaboliteRatio> getMetaboliteRatios();

    @Override
    public abstract ReactionConstraints getConstraints();

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public ArrayIterable<? extends MetaboliteRatio> getEductRatios() {
        GenericDynamicArray<MetaboliteRatio> educts = new GenericDynamicArray<MetaboliteRatio>();
        ArrayIterable<? extends MetaboliteRatio> metabolites = this.getMetaboliteRatios();
        int ii = 0;
        while (ii < metabolites.length()) {
            MetaboliteRatio metaRatio = metabolites.get(ii);
            if (metaRatio.getRatio() < 0.0) {
                educts.add(metaRatio);
            }
            ++ii;
        }
        return educts;
    }

    @Override
    public ArrayIterable<? extends MetaboliteRatio> getProductRatios() {
        GenericDynamicArray<MetaboliteRatio> products = new GenericDynamicArray<MetaboliteRatio>();
        ArrayIterable<? extends MetaboliteRatio> metabolites = this.getMetaboliteRatios();
        int ii = 0;
        while (ii < metabolites.length()) {
            MetaboliteRatio metaRatio = metabolites.get(ii);
            if (metaRatio.getRatio() > 0.0) {
                products.add(metaRatio);
            }
            ++ii;
        }
        return products;
    }

    @Override
    public boolean isMetaboliteParticipating(Metabolite metabolite) {
        return this.getRatioValueForMetabolite(metabolite) != 0.0;
    }

    @Override
    public boolean isMetaboliteConsumed(Metabolite metabolite) {
        return this.getRatioValueForMetabolite(metabolite) < 0.0;
    }

    @Override
    public boolean isMetaboliteProduced(Metabolite metabolite) {
        return this.getRatioValueForMetabolite(metabolite) > 0.0;
    }

    @Override
    public double getRatioValueForMetabolite(Metabolite metabolite) {
        ArrayIterable<? extends MetaboliteRatio> metabolites = this.getMetaboliteRatios();
        int ii = 0;
        while (ii < metabolites.length()) {
            MetaboliteRatio metaRatio = metabolites.get(ii);
            if (metaRatio.getMetabolite().equals(metabolite)) {
                return metaRatio.getRatio();
            }
            ++ii;
        }
        return 0.0;
    }

    @Override
    public String toString() {
        return AbstractReaction.toString(this.getMetaboliteRatios(), this.getConstraints().isReversible());
    }

    public static String toString(Iterable<? extends MetaboliteRatio> metaRatios, boolean reversible) {
        StringBuilder educ = new StringBuilder();
        StringBuilder prod = new StringBuilder();
        for (MetaboliteRatio metaboliteRatio : metaRatios) {
            if (metaboliteRatio.getRatio() < 0.0) {
                if (educ.length() > 0) {
                    educ.append(" + ");
                }
                educ.append(metaboliteRatio.toStringAbs());
                continue;
            }
            if (metaboliteRatio.getRatio() > 0.0) {
                if (prod.length() > 0) {
                    prod.append(" + ");
                }
                prod.append(metaboliteRatio.toStringAbs());
                continue;
            }
            if (prod.length() > 0) {
                prod.append(" + ");
            }
            prod.append(metaboliteRatio.toStringAbs());
        }
        return (educ.length() > 0 ? educ : "#") + (reversible ? " <--> " : " --> ") + (prod.length() > 0 ? prod : "#");
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            Reaction reac = (Reaction)obj;
            if (this.getName().equals(reac.getName())) {
                GenericArray<? extends MetaboliteRatio> mine = this.getMetaboliteRatios().toGenericArray(true);
                GenericArray<? extends MetaboliteRatio> others = reac.getMetaboliteRatios().toGenericArray(true);
                if (mine.size() == others.size()) {
                    Comparator<MetaboliteRatio> cmp = new Comparator<MetaboliteRatio>(){

                        @Override
                        public int compare(MetaboliteRatio o1, MetaboliteRatio o2) {
                            int cmp = o1.getMetabolite().getName().compareTo(o2.getMetabolite().getName());
                            if (cmp == 0) {
                                cmp = o1.getRatio() == o2.getRatio() ? 0 : (o1.getRatio() < o2.getRatio() ? -1 : 1);
                            }
                            return cmp;
                        }
                    };
                    Collections.sort(mine, cmp);
                    Collections.sort(others, cmp);
                    int ii = 0;
                    while (ii < mine.size()) {
                        if (!((MetaboliteRatio)mine.get(ii)).equals(others.get(ii))) {
                            return false;
                        }
                        ++ii;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isExternal() {
        return this.isUptake() || this.isExtract();
    }

    @Override
    public boolean isUptake() {
        return this.getEductRatios().isEmpty();
    }

    @Override
    public boolean isExtract() {
        return this.getProductRatios().isEmpty();
    }

    @Override
    public boolean hasIntegerRatios() {
        for (MetaboliteRatio metaboliteRatio : this.getMetaboliteRatios()) {
            if (metaboliteRatio.isIntegerRatio()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void accept(MetabolicNetworkVisitor visitor) {
        visitor.visitReaction(this);
    }

    protected int objHashCode() {
        return super.hashCode();
    }
}

