/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compartment.CompartmentMetabolicNetwork;
import ch.javasoft.metabolic.compartment.CompartmentMetabolite;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelGenerator {
    private final MetabolicNetwork net;
    private final HSSFWorkbook workbook;
    private final HSSFCellStyle styleBoldItalic;

    public ExcelGenerator(MetabolicNetwork net) {
        this.net = net;
        this.workbook = new HSSFWorkbook();
        this.styleBoldItalic = this.getCellStyle((short)700, true);
        this.initMetabolites();
        this.initReactions();
    }

    protected HSSFCellStyle getCellStyle(short boldweight, boolean italic) {
        HSSFCellStyle style = this.workbook.createCellStyle();
        HSSFFont font = this.workbook.createFont();
        font.setBoldweight(boldweight);
        font.setItalic(italic);
        style.setFont(font);
        return style;
    }

    protected static HSSFCell getCell(HSSFSheet sheet, int row, int col, boolean create) {
        HSSFCell xlsCell;
        HSSFRow xlsRow = sheet.getRow(row);
        if (xlsRow == null) {
            if (!create) {
                return null;
            }
            xlsRow = sheet.createRow(row);
        }
        if ((xlsCell = xlsRow.getCell((short)col)) == null) {
            if (!create) {
                return null;
            }
            xlsCell = xlsRow.createCell((short)col);
        }
        return xlsCell;
    }

    protected static void writeToCell(HSSFSheet sheet, int row, int col, String value) {
        ExcelGenerator.writeToCell(sheet, row, col, value, null);
    }

    protected static void writeToCell(HSSFSheet sheet, int row, int col, String value, HSSFCellStyle style) {
        HSSFCell xlsCell = ExcelGenerator.getCell(sheet, row, col, true);
        xlsCell.setCellType(1);
        xlsCell.setCellValue(new HSSFRichTextString(value));
        if (style != null) {
            xlsCell.setCellStyle(style);
        }
    }

    protected void initMetabolites() {
        HSSFSheet sheet = this.workbook.createSheet("Metabolites");
        String compartmentName = null;
        boolean hasDescription = false;
        boolean hasCompartment = false;
        boolean hasCompartmentFull = false;
        CompartmentMetabolicNetwork cnet = this.net instanceof CompartmentMetabolicNetwork ? (CompartmentMetabolicNetwork)this.net : null;
        for (Metabolite metabolite : this.net.getMetabolites()) {
            hasDescription |= metabolite.getDescription() != null;
            if (!(metabolite instanceof CompartmentMetabolite)) continue;
            String cmp = ((CompartmentMetabolite)metabolite).getCompartment();
            if (compartmentName == null) {
                compartmentName = cmp;
            } else {
                boolean bl = hasCompartment = !compartmentName.equals(cmp);
            }
            if (cnet == null || cmp == null) continue;
            boolean bl = hasCompartmentFull = !cmp.equals(cnet.getCompartmentFullName(cmp));
        }
        boolean bl = false;
        boolean colDesc = true;
        int colComp = hasDescription ? 2 : 1;
        int colCFul = hasCompartment ? colComp + 1 : -1;
        ExcelGenerator.writeToCell(sheet, 0, 0, "Name", this.styleBoldItalic);
        if (hasDescription) {
            ExcelGenerator.writeToCell(sheet, 0, 1, "Description", this.styleBoldItalic);
        }
        if (hasCompartment) {
            ExcelGenerator.writeToCell(sheet, 0, colComp, "Compartment", this.styleBoldItalic);
        }
        if (hasCompartmentFull) {
            ExcelGenerator.writeToCell(sheet, 0, colCFul, "Compartment Description", this.styleBoldItalic);
        }
        int row = 1;
        for (Metabolite metabolite : this.net.getMetabolites()) {
            ExcelGenerator.writeToCell(sheet, row, 0, metabolite.getName());
            if (hasDescription && metabolite.getDescription() != null) {
                ExcelGenerator.writeToCell(sheet, row, 1, metabolite.getDescription());
            }
            if (hasCompartment && metabolite instanceof CompartmentMetabolite) {
                String ful;
                String cmp = ((CompartmentMetabolite)metabolite).getCompartment();
                String string = ful = cnet != null ? cnet.getCompartmentFullName(cmp) : null;
                if (cmp != null) {
                    ExcelGenerator.writeToCell(sheet, row, colComp, cmp);
                }
                if (hasCompartmentFull && ful != null) {
                    ExcelGenerator.writeToCell(sheet, row, colCFul, ful);
                }
            }
            ++row;
        }
    }

    protected void initReactions() {
        HSSFSheet sheet = this.workbook.createSheet("Reactions");
        boolean hasFullName = false;
        for (Reaction reaction : this.net.getReactions()) {
            hasFullName |= !reaction.getName().equals(reaction.getFullName());
        }
        boolean bl = false;
        boolean colFull = true;
        int colForm = hasFullName ? 2 : 1;
        ExcelGenerator.writeToCell(sheet, 0, 0, "Name", this.styleBoldItalic);
        if (hasFullName) {
            ExcelGenerator.writeToCell(sheet, 0, 1, "Full Name", this.styleBoldItalic);
        }
        ExcelGenerator.writeToCell(sheet, 0, colForm, "Formula", this.styleBoldItalic);
        int row = 1;
        for (Reaction reaction : this.net.getReactions()) {
            ExcelGenerator.writeToCell(sheet, row, 0, reaction.getName());
            if (hasFullName && reaction.getFullName() != null) {
                ExcelGenerator.writeToCell(sheet, row, 1, reaction.getFullName());
            }
            ExcelGenerator.writeToCell(sheet, row, colForm, reaction.toString());
            ++row;
        }
    }

    public void writeTo(File file) throws IOException {
        this.writeTo(new FileOutputStream(file));
    }

    public void writeTo(OutputStream out) throws IOException {
        this.workbook.write(out);
        out.flush();
    }
}

