/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.util;

import ch.javasoft.math.BigFraction;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.numeric.IntegerUtil;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModUtil {
    public static int[][] toIntArray(ReadableMatrix<BigFraction> stoich, int iprime) {
        return ModUtil.toIntArray(stoich, iprime, stoich.getRowCount());
    }

    public static int[][] toIntArray(ReadableMatrix<BigFraction> stoich, int iprime, int rows) {
        BigInteger prime = BigInteger.valueOf(iprime);
        int cols = stoich.getColumnCount();
        int[][] arr = new int[rows][cols];
        int row = 0;
        while (row < rows) {
            int maxPowOfMod = 0;
            int col = 0;
            while (col < cols) {
                if (stoich.getSignumAt(row, col) != 0) {
                    BigInteger den = stoich.getNumberValueAt(row, col).getDenominator();
                    int powOfMod = 0;
                    while (den.remainder(prime).intValue() == 0) {
                        ++powOfMod;
                        den = den.divide(prime);
                    }
                    maxPowOfMod = Math.max(maxPowOfMod, powOfMod);
                }
                ++col;
            }
            BigFraction mul = maxPowOfMod == 0 ? null : BigFraction.valueOf(prime.pow(maxPowOfMod));
            int col2 = 0;
            while (col2 < cols) {
                if (stoich.getSignumAt(row, col2) != 0) {
                    BigFraction val = stoich.getNumberValueAt(row, col2);
                    if (mul != null) {
                        val = val.multiply(mul).reduce();
                    }
                    BigInteger num = val.getNumerator();
                    BigInteger den = val.getDenominator();
                    int iNum = num.remainder(prime).intValue();
                    int iDen = den.remainder(prime).intValue();
                    long inv = ModUtil.invert(iDen, iprime);
                    arr[row][col2] = (int)((long)iNum * inv % (long)iprime);
                } else {
                    arr[row][col2] = 0;
                }
                ++col2;
            }
            ++row;
        }
        return arr;
    }

    public static int[][] toIntArrayNoInversion(ReadableMatrix<BigFraction> stoich, int iprime) {
        return ModUtil.toIntArrayNoInversion(stoich, iprime, stoich.getRowCount());
    }

    public static int[][] toIntArrayNoInversion(ReadableMatrix<BigFraction> stoich, int iprime, int rows) {
        BigInteger prime = BigInteger.valueOf(iprime);
        int cols = stoich.getColumnCount();
        int[][] arr = new int[rows][cols];
        int row = 0;
        while (row < rows) {
            BigInteger lcm = BigInteger.ONE;
            int col = 0;
            while (col < cols) {
                BigInteger den;
                BigInteger gcd;
                if (stoich.getSignumAt(row, col) != 0 && !(gcd = lcm.gcd(den = stoich.getNumberValueAt(row, col).getDenominator())).equals(den)) {
                    lcm.multiply(den);
                    lcm.divide(gcd);
                }
                ++col;
            }
            boolean isOne = lcm.equals(BigInteger.ONE);
            int col2 = 0;
            while (col2 < cols) {
                if (stoich.getSignumAt(row, col2) != 0) {
                    BigFraction val = stoich.getNumberValueAt(row, col2);
                    BigInteger biv = val.getNumerator();
                    if (!isOne) {
                        biv = biv.multiply(lcm).divide(val.getDenominator());
                    }
                    arr[row][col2] = biv.mod(prime).intValue();
                } else {
                    arr[row][col2] = 0;
                }
                ++col2;
            }
            ++row;
        }
        return arr;
    }

    public static int invert(int a, int prime) {
        return IntegerUtil.modularReciprocal(a, prime);
    }

    private ModUtil() {
    }
}

