/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.util;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.IterableMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.tree.Partition;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnUtil {
    public static int getColumnCount(Iterable columns) throws IOException {
        if (columns instanceof Collection) {
            return ((Collection)columns).size();
        }
        if (columns instanceof IterableMemory) {
            return ((IterableMemory)columns).getColumnCount();
        }
        throw new IOException("unknown container type: " + columns.getClass().getName());
    }

    public static int getBooleanSize(List<? extends Column> cols) {
        return cols.size() == 0 ? 0 : cols.get(0).booleanSize();
    }

    public static int getBooleanSize(IndexableMemory<? extends Column> cols) throws IOException {
        return cols.getColumnCount() == 0 ? 0 : cols.getColumn(0).booleanSize();
    }

    public static <N extends Number, Col extends Column> void partition(ColumnHome<N, Col> columnHome, NetworkEfmModel model, IterableMemory<Col> src, AppendableMemory<Col> pos, AppendableMemory<Col> zer, AppendableMemory<Col> neg, IterationStepModel iteration, boolean convert) throws IOException {
        for (Column col : src) {
            int sgn;
            if (convert) {
                col = col.convert(columnHome, model, iteration, false);
            }
            if ((sgn = col.getHyperplaneSign(model, iteration.getNextState())) < 0) {
                neg.appendColumn(col);
                continue;
            }
            if (sgn > 0) {
                pos.appendColumn(col);
                continue;
            }
            zer.appendColumn(col);
        }
        src.close(true);
    }

    public static <N extends Number, Col extends Column> void partitionOrClose(ColumnHome<N, Col> columnHome, NetworkEfmModel model, NetworkEfmModel.Partition partition, IterableMemory<Col> src, AppendableMemory<Col> pos, AppendableMemory<Col> zer, AppendableMemory<Col> neg, IterationStepModel iteration, boolean convert) throws IOException {
        if (model.cutOff(partition)) {
            src.close(true);
        } else {
            ColumnUtil.partition(columnHome, model, src, pos, zer, neg, iteration, convert);
        }
    }

    public static <Col extends Column, N extends Number> void moveToOrClose(ColumnHome<N, Col> columnHome, NetworkEfmModel model, NetworkEfmModel.Partition partition, IterableMemory<Col> src, AppendableMemory<Col> dst, IterationStepModel iteration, boolean convert) throws IOException {
        if (!model.cutOff(partition)) {
            for (Column col : src) {
                if (convert) {
                    col = col.convert(columnHome, model, iteration, false);
                }
                dst.appendColumn(col);
            }
        }
        src.close(true);
    }

    public static <Col extends Column> Partition partitionColumns(SortableMemory<Col> mem, int bitIndex, int start, int end) throws IOException {
        PartitionImpl partitionImpl = new PartitionImpl();
        int len = end;
        int ind = start;
        while (ind < len) {
            Object colLeft = mem.getColumn(ind);
            if (!colLeft.bitValues().get(bitIndex)) {
                partitionImpl.add(colLeft.bitValues());
                ++ind;
                continue;
            }
            Object colRight = mem.getColumn(len - 1);
            if (colRight.bitValues().get(bitIndex)) {
                partitionImpl.add(colRight.bitValues());
                --len;
                continue;
            }
            partitionImpl.add(colRight.bitValues());
            partitionImpl.add(colLeft.bitValues());
            mem.swapColumns(ind, len - 1);
            ++ind;
            --len;
        }
        assert (ind == len || ind == len + 1);
        partitionImpl.median = ind;
        return partitionImpl;
    }

    public static <N extends Number> N[] mergeNumeric(EfmModel model, NumberOperations<N> numOps, N mulCol1, N[] numericValsCol1, N mulCol2, N[] numericValsCol2, boolean num2bool) {
        if (numOps.signum(mulCol1) < 0) {
            if (numOps.signum(mulCol2) > 0) {
                return ColumnUtil.mergeNumeric((EfmModel)model, numOps, mulCol2, numericValsCol2, mulCol1, numericValsCol1, (boolean)num2bool);
            }
        } else if (numOps.signum(mulCol2) < 0) {
            int boolInc = num2bool ? 1 : 0;
            Number[] values = numOps.newArray(numericValsCol1.length - boolInc);
            int ii = 0;
            while (ii < values.length) {
                N prodA = numOps.multiply((Number)numericValsCol1[ii + boolInc], mulCol1);
                N prodB = numOps.multiply((Number)numericValsCol2[ii + boolInc], mulCol2);
                values[ii] = numOps.subtract((Number)prodA, (Number)prodB);
                values[ii] = numOps.reduce(values[ii]);
                ++ii;
            }
            return numOps.reduceVector(false, values);
        }
        throw new RuntimeException("multipliers must have opposite sign: " + mulCol1 + " / " + mulCol2);
    }

    public static double[] mergeNumeric(EfmModel model, double mulCol1, double[] numericValsCol1, double mulCol2, double[] numericValsCol2, boolean num2bool) {
        if (mulCol1 < 0.0) {
            if (mulCol2 > 0.0) {
                return ColumnUtil.mergeNumeric(model, mulCol2, numericValsCol2, mulCol1, numericValsCol1, num2bool);
            }
        } else if (mulCol2 < 0.0) {
            int boolInc = num2bool ? 1 : 0;
            double sum = mulCol1 - mulCol2;
            double[] values = new double[numericValsCol1.length - boolInc];
            int ii = 0;
            while (ii < values.length) {
                double prodA = numericValsCol1[ii + boolInc] * mulCol1;
                double prodB = numericValsCol2[ii + boolInc] * mulCol2;
                values[ii] = (prodA - prodB) / sum;
                ++ii;
            }
            return values;
        }
        throw new RuntimeException("multipliers must have opposite sign: " + mulCol1 + " / " + mulCol2);
    }

    private ColumnUtil() {
    }

    private static class PartitionImpl
    implements Partition {
        private int median;
        private IBitSet unionPattern;

        private PartitionImpl() {
        }

        void add(IBitSet pat) {
            if (this.unionPattern == null) {
                this.unionPattern = pat.clone();
            } else {
                this.unionPattern.or(pat);
            }
        }

        public IBitSet unionPattern() {
            return this.unionPattern;
        }

        public int getMedian() {
            return this.median;
        }
    }
}

