/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.impl;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.tree.InterNode;
import ch.javasoft.metabolic.efm.tree.LeafNode;
import ch.javasoft.metabolic.efm.tree.Node;
import ch.javasoft.metabolic.efm.tree.TreePairTraverser;
import ch.javasoft.metabolic.efm.tree.TreeTraverser;
import ch.javasoft.metabolic.efm.tree.impl.AbstractNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLeafNode
extends AbstractNode
implements LeafNode {
    private int start;
    private int end;

    public AbstractLeafNode(IBitSet unionPattern, int start, int end) {
        super(unionPattern);
        this.start = start;
        this.end = end;
    }

    public <Col extends Column> Iterable<Col> leafColumns(final IndexableMemory<Col> columns) {
        return new Iterable<Col>(){

            @Override
            public Iterator<Col> iterator() {
                return new Iterator<Col>(){
                    int index;
                    {
                        this.index = AbstractLeafNode.this.start;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < AbstractLeafNode.this.end;
                    }

                    @Override
                    public Col next() {
                        if (this.index < AbstractLeafNode.this.end) {
                            try {
                                return columns.getColumn(this.index++);
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public int getLeafColumnStart() {
        return this.start;
    }

    @Override
    public int getLeafColumnEnd() {
        return this.end;
    }

    @Override
    public <Col extends Column, N extends Number, T> boolean traverse(TreeTraverser<T> traverser, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token) throws IOException {
        return traverser.traverseL(columnHome, iterationModel, token, this);
    }

    @Override
    public <Col extends Column, N extends Number, T> void traverseN(TreePairTraverser<T> traverser, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean thisIsPos, Node other) throws IOException {
        traverser.traverseLN(columnHome, iterationModel, token, myDepth, otherDepth, thisIsPos, this, other);
    }

    @Override
    public <Col extends Column, N extends Number, T> void traverseI(TreePairTraverser<T> traverser, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean thisIsPos, InterNode other) throws IOException {
        traverser.traverseIL(columnHome, iterationModel, token, otherDepth, myDepth, !thisIsPos, other, this);
    }

    @Override
    public <Col extends Column, N extends Number, T> void traverseL(TreePairTraverser<T> traverser, ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, int myDepth, int otherDepth, boolean thisIsPos, LeafNode other) throws IOException {
        traverser.traverseLL(columnHome, iterationModel, token, myDepth, otherDepth, thisIsPos, this, other);
    }
}

