/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output.mat;

import ch.javasoft.jsmat.MatOutputStreamWriter;
import ch.javasoft.jsmat.MatWriter;
import ch.javasoft.jsmat.ReservedComplexWriter;
import ch.javasoft.jsmat.ReservedMatrixWriter;
import ch.javasoft.jsmat.variable.MatCell;
import ch.javasoft.jsmat.variable.MatCharMatrix;
import ch.javasoft.jsmat.variable.MatDoubleMatrix;
import ch.javasoft.jsmat.variable.MatMatrix;
import ch.javasoft.jsmat.variable.MatReservedMatrix;
import ch.javasoft.jsmat.variable.MatReservedStructure;
import ch.javasoft.jsmat.variable.MatVariable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileWriter {
    private final MatWriter mMatOut;
    private final String mStructName;
    private ReservedComplexWriter mStructWriter;
    private final Map<String, MatVariable> mFields = new LinkedHashMap<String, MatVariable>();

    public MatFileWriter(File file, String structName) throws IOException {
        this.mMatOut = new ch.javasoft.jsmat.MatFileWriter(file);
        this.mStructName = structName;
    }

    public MatFileWriter(OutputStream out, String structName) throws IOException {
        this.mMatOut = new MatOutputStreamWriter(out);
        this.mStructName = structName;
    }

    public void write(String name, String value) {
        this.mFields.put(name, new MatCharMatrix(value));
    }

    public void write(String name, String[] values) {
        this.mFields.put(name, new MatCell(values));
    }

    public void write(String name, double[] values) {
        this.mFields.put(name, new MatDoubleMatrix(values, true));
    }

    public void write(String name, double[][] values) {
        this.mFields.put(name, new MatDoubleMatrix(values));
    }

    public void write(String name, List<double[]> values, boolean rowsInList) {
        MatDoubleMatrix mx = rowsInList ? MatDoubleMatrix.createMatrixFromRows(values) : MatDoubleMatrix.createMatrixFromColumns(values);
        this.mFields.put(name, mx);
    }

    public void write(String name, int value) {
        this.write(name, new int[]{value});
    }

    public void write(String name, int[] values) {
        MatMatrix<int[]> mxInt = MatMatrix.createIntMatrix(values, 1, values.length);
        this.mFields.put(name, mxInt);
    }

    public <A> ReservedMatrixWriter<A> createReservedWriter(String fieldName, MatReservedMatrix<A> mx) throws IOException {
        this.mFields.put(fieldName, mx);
        MatReservedStructure struc = new MatReservedStructure(this.mFields);
        this.mStructWriter = this.mMatOut.createReservedWriter(this.mStructName, struc);
        return struc.createReservedWriter(this.mStructWriter, mx);
    }

    public void close() throws IOException {
        this.mStructWriter.close();
        this.mFields.clear();
        this.mMatOut.close();
    }
}

