/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compress.CompressedMetabolicNetwork;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmappingEfmOutputFormatter<W>
implements EfmOutputFormatter<W> {
    private final MetabolicNetwork originalNetwork;
    private final EfmOutputFormatter<W> delegate;
    private int[] mMetaboliteMapping;
    private int[] mReactionMapping;

    public UnmappingEfmOutputFormatter(EfmOutputFormatter<W> delegate, MetabolicNetwork originalNetwork) {
        this.delegate = delegate;
        this.originalNetwork = originalNetwork;
    }

    @Override
    public void formatHeader(EfmOutputCallback cb, W writer, EfmOutputEvent evt) throws IOException {
        MetabolicNetwork net = evt.getMetabolicNetwork();
        if (net instanceof CompressedMetabolicNetwork) {
            if (!cb.getGranularity().isUncompressionNeeded()) {
                throw new IOException("compressed network, but uncompressed output");
            }
            net = ((CompressedMetabolicNetwork)net).getRootNetwork();
        }
        int mlen = net.getMetabolites().length();
        int rlen = net.getReactions().length();
        this.mMetaboliteMapping = new int[mlen];
        this.mReactionMapping = new int[rlen];
        int i = 0;
        while (i < mlen) {
            Metabolite meta = net.getMetabolites().get(i);
            this.mMetaboliteMapping[i] = this.originalNetwork.getMetaboliteIndex(meta.getName());
            ++i;
        }
        i = 0;
        while (i < rlen) {
            int index;
            Reaction reac = net.getReactions().get(i);
            this.mReactionMapping[i] = index = this.originalNetwork.getReactionIndex(reac.getName());
            if (this.mReactionMapping[i] == -1) {
                throw new IOException("reaction not found in original network: " + reac.getName());
            }
            ++i;
        }
        this.delegate.formatHeader(cb, writer, evt);
    }

    @Override
    public void formatEfmHeader(EfmOutputCallback cb, W writer, EfmOutputEvent evt, long efmIndex) throws IOException {
        int curLen = evt.getEfm().getSize();
        FluxDistribution fluxDist = evt.getEfm().create(this.originalNetwork);
        int i = 0;
        while (i < curLen) {
            Number value = evt.getEfm().getNumberRate(i);
            fluxDist.setRate(this.mReactionMapping[i], value);
            ++i;
        }
        EfmOutputEvent mappedEvt = new EfmOutputEvent(this.originalNetwork, fluxDist, evt.getEfmCount());
        this.delegate.formatEfmHeader(cb, writer, mappedEvt, efmIndex);
        if (this.isEfmValueIterationNeeded(cb)) {
            int i2 = 0;
            while (i2 < mappedEvt.getEfm().getSize()) {
                Number val = mappedEvt.getEfm().getNumberRate(i2);
                this.delegate.formatEfmValue(cb, writer, mappedEvt, efmIndex, i2, val);
                ++i2;
            }
        }
        this.delegate.formatEfmFooter(cb, writer, mappedEvt, efmIndex);
    }

    @Override
    public void formatEfmValue(EfmOutputCallback cb, W writer, EfmOutputEvent evt, long efmIndex, int valueIndex, Number value) throws IOException {
    }

    @Override
    public void formatEfmFooter(EfmOutputCallback cb, W writer, EfmOutputEvent evt, long efmIndex) throws IOException {
    }

    @Override
    public void formatFooter(EfmOutputCallback cb, W writer, EfmOutputEvent evt, long countEfms) throws IOException {
        this.mMetaboliteMapping = null;
        this.mReactionMapping = null;
        this.delegate.formatFooter(cb, writer, evt, countEfms);
    }

    @Override
    public boolean isEfmValueIterationNeeded(EfmOutputCallback cb) {
        return this.delegate.isEfmValueIterationNeeded(cb);
    }
}

