/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomAccessFileOutputFormatter
implements EfmOutputFormatter<RandomAccessFile> {
    private long startFilePointer;

    @Override
    public void formatHeader(EfmOutputCallback cb, RandomAccessFile writer, EfmOutputEvent evt) throws IOException {
        MetabolicNetwork net = Util.getNetworkUncompressedIfNeeded(cb.getGranularity(), evt);
        this.startFilePointer = writer.getFilePointer();
        writer.writeLong(0L);
        writer.writeInt(net.getReactions().length());
        writer.writeBoolean(cb.getGranularity().isBinarySufficient());
    }

    @Override
    public void formatEfmHeader(EfmOutputCallback cb, RandomAccessFile writer, EfmOutputEvent evt, long efmIndex) throws IOException {
        if (cb.getGranularity().isBinarySufficient()) {
            FluxDistribution fd = evt.getEfm();
            byte b = 0;
            int m = 1;
            int i = 0;
            while (i < fd.getSize()) {
                if (fd.getNumberRate(i).doubleValue() != 0.0) {
                    b = (byte)(b | m);
                }
                if (i % 8 == 7 || i + 1 == fd.getSize()) {
                    writer.writeByte(b);
                    b = 0;
                    m = 1;
                } else {
                    m = (byte)(m << 1);
                }
                ++i;
            }
        }
    }

    @Override
    public void formatEfmValue(EfmOutputCallback cb, RandomAccessFile writer, EfmOutputEvent evt, long efmIndex, int valueIndex, Number value) throws IOException {
        if (!cb.getGranularity().isBinarySufficient()) {
            writer.writeDouble(value.doubleValue());
        }
    }

    @Override
    public void formatEfmFooter(EfmOutputCallback cb, RandomAccessFile writer, EfmOutputEvent evt, long efmIndex) {
    }

    @Override
    public void formatFooter(EfmOutputCallback cb, RandomAccessFile writer, EfmOutputEvent evt, long countEfms) throws IOException {
        long curPtr = writer.getFilePointer();
        writer.seek(this.startFilePointer);
        writer.writeLong(countEfms);
        writer.seek(curPtr);
    }

    @Override
    public boolean isEfmValueIterationNeeded(EfmOutputCallback cb) {
        return !cb.getGranularity().isBinarySufficient();
    }
}

