/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.LogPkg;
import ch.javasoft.util.logging.LogPrintWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CountOutputCallback
implements EfmOutputCallback {
    protected final PrintWriter mPw;
    protected final boolean mUncompress;
    protected final AtomicLong cnt = new AtomicLong();

    public CountOutputCallback(boolean uncompress) {
        this(LogPkg.LOGGER, Level.INFO, uncompress);
    }

    public CountOutputCallback(Logger logger, Level level, boolean uncompress) {
        this(new LogPrintWriter(logger, level), uncompress);
    }

    public CountOutputCallback(OutputStream out, boolean uncompress) {
        this.mPw = Print.createWriter(out);
        this.mUncompress = uncompress;
    }

    public CountOutputCallback(Writer writer, boolean uncompress) {
        this.mPw = Print.createWriter(writer);
        this.mUncompress = uncompress;
    }

    public boolean isUncompress() {
        return this.mUncompress;
    }

    public void callback(EfmOutputEvent evt) {
        switch (evt.getKind()) {
            case PRE: {
                this.cnt.set(0L);
                break;
            }
            case EFM_OUT: {
                this.cnt.incrementAndGet();
                break;
            }
            case POST: {
                this.mPw.println(this.cnt + " elementary modes");
                this.mPw.flush();
                break;
            }
            default: {
                throw new RuntimeException("unknown kind " + (Object)((Object)evt.getKind()));
            }
        }
    }

    public long getEfmCount() {
        return this.cnt.get();
    }

    public CallbackGranularity getGranularity() {
        return this.mUncompress ? CallbackGranularity.CountUncompressed : CallbackGranularity.CountCompressed;
    }

    public boolean allowLoggingDuringOutput() {
        return true;
    }

    public boolean isThreadSafe() {
        return true;
    }
}

