/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.canonical;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.canonical.AbstractCanonicalColumnInspectorModifier;
import ch.javasoft.metabolic.efm.util.CanonicalUtil;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalDoubleColumnInspectorModifier
extends AbstractCanonicalColumnInspectorModifier<Double, double[]> {
    @Override
    protected double[] copyOf(double[] numericVals) {
        return Arrays.copyOf(numericVals, numericVals.length);
    }

    @Override
    public int getHyperplaneSign(ColumnHome<Double, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, double[] numericVals, IterationStateModel iteration) {
        ReadableMatrix<Double> stoich = model.getStoichiometricMatrix(columnHome);
        int hyperIndex = iteration.getHyperplaneIndex();
        double val = CanonicalUtil.getInequalityValue(stoich, hyperIndex, numericVals, model.getReactionSorting());
        return model.zero().sgn(val);
    }

    @Override
    public double[] mergeNumeric(ColumnHome<Double, ?> columnHome, EfmModel model, IBitSet binaryValsCol1, int binarySizeCol1, double[] numericValsCol1, IBitSet binaryValsCol2, int binarySizeCol2, double[] numericValsCol2, IterationStepModel iteration) {
        ReadableMatrix<Double> stoich = model.getStoichiometricMatrix(columnHome);
        int hyperplaneIndex = iteration.getCurrentState().getHyperplaneIndex();
        double mulCol1 = CanonicalUtil.getInequalityValue(stoich, hyperplaneIndex, numericValsCol2, model.getReactionSorting());
        double mulCol2 = CanonicalUtil.getInequalityValue(stoich, hyperplaneIndex, numericValsCol1, model.getReactionSorting());
        return ColumnUtil.mergeNumeric(model, mulCol1, numericValsCol1, mulCol2, numericValsCol2, false);
    }
}

