/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compress.CompressedMetabolicNetwork;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.ColumnToFluxDistributionConverter;
import ch.javasoft.metabolic.efm.model.LogPkg;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.logging.LogFragmenter;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumnToFluxDistributionConverter<N extends Number, Col extends Column>
implements ColumnToFluxDistributionConverter<N, Col> {
    private static final Logger LOG = LogPkg.LOGGER;
    protected final ColumnHome<N, Col> columnHome;

    public AbstractColumnToFluxDistributionConverter(ColumnHome<N, Col> columnHome) {
        this.columnHome = columnHome;
    }

    @Override
    public void writeColumnsToCallback(final Config config, final NetworkEfmModel model, Iterable<Col> columns, final EfmOutputCallback callback) throws IOException {
        WorkerThread thread;
        LogFragmenter log;
        final long efmCount = this.writeE2eReactionsToCallback(config, model, columns, callback);
        int logcnt = 1000;
        int offset = (int)(efmCount - (long)ColumnUtil.getColumnCount(columns));
        if (callback.allowLoggingDuringOutput()) {
            log = new LogFragmenter(LOG);
            log.fineStart("uncompressing efms: ");
        } else {
            log = null;
        }
        AtomicReference<IOException> exception = new AtomicReference<IOException>();
        int threadCnt = Math.min(Runtime.getRuntime().availableProcessors(), config.getMaxThreads());
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(Math.max(threadCnt * 2, 256));
        WorkerThread[] threads = new WorkerThread[threadCnt];
        int i = 0;
        while (i < threadCnt) {
            threads[i] = thread = new WorkerThread(queue, exception);
            thread.start();
            ++i;
        }
        int index = 0;
        for (final Column col : columns) {
            int curindex;
            if ((curindex = ++index + offset) % logcnt == 0) {
                if (log != null) {
                    log.append(String.valueOf(curindex) + "...");
                }
                if (curindex % (10 * logcnt) == 0) {
                    logcnt *= 10;
                }
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    FluxDistribution dist = AbstractColumnToFluxDistributionConverter.this.createFluxDistributionFromColumn(log, config, model, col, callback.getGranularity());
                    AbstractColumnToFluxDistributionConverter.this.writeFluxDistributionToCallback(model.getMetabolicNetwork(), config, dist, efmCount, callback);
                }
            };
            try {
                queue.put(runnable);
            }
            catch (InterruptedException e) {
                throw ExceptionUtil.toIOException(e);
            }
            if (exception.get() == null) continue;
            queue.clear();
            break;
        }
        WorkerThread[] workerThreadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            thread = workerThreadArray[n2];
            thread.setEndOfQueue();
            ++n2;
        }
        workerThreadArray = threads;
        n = threads.length;
        n2 = 0;
        while (n2 < n) {
            thread = workerThreadArray[n2];
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw ExceptionUtil.toIOException(e);
            }
            ++n2;
        }
        if (log != null && log.isStarted()) {
            log.end(String.valueOf(efmCount) + " done.");
        }
        if (exception.get() != null) {
            throw exception.get();
        }
    }

    protected long writeE2eReactionsToCallback(Config config, NetworkEfmModel model, Iterable<Col> columns, EfmOutputCallback callback) throws IOException {
        Reaction reac;
        MetabolicNetwork metaNet = model.getMetabolicNetwork();
        long efmCount = ColumnUtil.getColumnCount(columns);
        NumberOperations<N> numberOps = this.columnHome.getNumberOperations();
        ArrayIterable<? extends Reaction> reacts = metaNet.getReactions();
        int ii = 0;
        while (ii < reacts.length()) {
            reac = reacts.get(ii);
            if (reac.isUptake() && reac.isExtract()) {
                ++efmCount;
                if (reac.getConstraints().isReversible()) {
                    ++efmCount;
                }
            }
            ++ii;
        }
        ii = 0;
        while (ii < reacts.length()) {
            reac = reacts.get(ii);
            if (reac.isUptake() && reac.isExtract()) {
                Object[] rates = numberOps.newArray(reacts.length());
                Arrays.fill(rates, numberOps.zero());
                rates[ii] = numberOps.one();
                this.writeFluxDistributionToCallback(metaNet, config, this.columnHome.createFluxDistribution(metaNet, (Number[])rates), efmCount, callback);
                if (reac.getConstraints().isReversible()) {
                    Number[] ratesRev = (Number[])rates.clone();
                    ratesRev[ii] = numberOps.negate(numberOps.one());
                    this.writeFluxDistributionToCallback(metaNet, config, this.columnHome.createFluxDistribution(metaNet, ratesRev), efmCount, callback);
                }
            }
            ++ii;
        }
        return efmCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFluxDistributionToCallback(MetabolicNetwork metaNet, Config config, FluxDistribution dist, long efmCount, EfmOutputCallback callback) {
        boolean doNormalize = true;
        if (callback.getGranularity().isUncompressionNeeded() && metaNet instanceof CompressedMetabolicNetwork) {
            dist = ((CompressedMetabolicNetwork)metaNet).uncompressFluxDistribution(dist);
            if (callback.getGranularity() == CallbackGranularity.BinaryUncompressed || callback.getGranularity() == CallbackGranularity.SignUncompressed) {
                int i = 0;
                while (i < dist.getSize()) {
                    dist.setRate(i, (Number)dist.getRateSignum(i));
                    ++i;
                }
                doNormalize = false;
            }
        }
        if (doNormalize) {
            dist.norm(config.getNormalize().norm, config.zero());
        }
        if (callback.isThreadSafe()) {
            callback.callback(new EfmOutputEvent(metaNet, dist, efmCount));
        } else {
            EfmOutputCallback efmOutputCallback = callback;
            synchronized (efmOutputCallback) {
                callback.callback(new EfmOutputEvent(metaNet, dist, efmCount));
            }
        }
    }

    @Override
    public FluxDistribution createFluxDistributionFromColumn(Config config, NetworkEfmModel model, Col column) {
        return this.createFluxDistributionFromColumn(null, config, model, column, CallbackGranularity.DoubleUncompressed);
    }

    protected abstract FluxDistribution createFluxDistributionFromColumn(LogFragmenter var1, Config var2, NetworkEfmModel var3, Col var4, CallbackGranularity var5);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkerThread
    extends Thread {
        private final AtomicReference<IOException> exception;
        private final BlockingQueue<Runnable> jobs;
        private volatile boolean endOfQueue = false;

        public WorkerThread(BlockingQueue<Runnable> jobs, AtomicReference<IOException> exception) {
            this.jobs = jobs;
            this.exception = exception;
        }

        public void setEndOfQueue() {
            this.endOfQueue = true;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Runnable runnable;
                        if ((runnable = (Runnable)this.jobs.poll()) == null) {
                            if (this.endOfQueue) {
                                return;
                            }
                            WorkerThread.yield();
                            continue;
                        }
                        runnable.run();
                    }
                }
                catch (Exception e) {
                    this.exception.compareAndSet(null, ExceptionUtil.toIOException(e));
                    continue;
                }
                break;
            }
        }
    }
}

