/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.impl;

import ch.javasoft.metabolic.efm.adj.AdjEnum;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.impl.AbstractDoubleDescriptionImpl;
import ch.javasoft.metabolic.efm.impl.LogPkg;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.IterableMemory;
import ch.javasoft.metabolic.efm.memory.MemoryFactory;
import ch.javasoft.metabolic.efm.memory.PartId;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.DefaultIterationStepModel;
import ch.javasoft.metabolic.efm.model.EfmModelFactory;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialDoubleDescriptionImpl
extends AbstractDoubleDescriptionImpl {
    private static final Logger LOG = LogPkg.LOGGER;

    public SequentialDoubleDescriptionImpl(Config config, EfmModelFactory modelFactory, MemoryFactory memoryFactory) {
        super(config, modelFactory, memoryFactory);
    }

    @Override
    protected <N extends Number, Col extends Column> IterableMemory<Col> iterate(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, AppendableMemory<Col> memory) throws IOException {
        long timeStart;
        AppendableMemory<Col> pos = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, 1, PartId.POS);
        AppendableMemory<Col> zer = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, 1, PartId.ZER);
        AppendableMemory<Col> neg = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, 1, PartId.NEG);
        DefaultIterationStepModel initialItModel = new DefaultIterationStepModel(efmModel, 0);
        ColumnUtil.partition(columnHome, efmModel, memory, pos, zer, neg, initialItModel, false);
        AdjEnum adjEnum = this.getConfig().getAdjMethodFactory().createAdjEnumFromConfig();
        adjEnum.initialize(columnHome, this.getConfig(), efmModel);
        int itCount = efmModel.getIterationCount();
        int cntPos = pos.getColumnCount();
        int cntZer = zer.getColumnCount();
        int cntNeg = neg.getColumnCount();
        int iteration = 0;
        long timeEnd = timeStart = System.currentTimeMillis();
        int colCount = cntPos + cntZer + cntNeg;
        while (colCount > 0 && iteration < itCount) {
            LOG.info("iteration " + iteration + "/" + itCount + ": " + colCount + " modes, dt=" + (timeEnd - timeStart) + "ms." + "\t{ next " + (iteration + 1) + "/" + itCount + ": " + (long)cntPos * (long)cntNeg + " adj candidates, " + "[+/0/-] = [" + cntPos + "/" + cntZer + "/" + cntNeg + "] }");
            if (LOG.isLoggable(Level.ALL)) {
                SequentialDoubleDescriptionImpl.traceCols("col:+", 0, pos);
                SequentialDoubleDescriptionImpl.traceCols("col:0", cntPos, zer);
                SequentialDoubleDescriptionImpl.traceCols("col:-", cntPos + cntZer, neg);
            }
            timeStart = System.currentTimeMillis();
            memory = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, ++iteration + 1, null);
            AdjEnumModel<Col> adjModel = new AdjEnumModel<Col>(efmModel, iteration, pos.toSortableMemory(), zer.toSortableMemory(), neg.toSortableMemory(), memory);
            if (cntPos > 0 && cntNeg > 0) {
                adjEnum.adjacentPairs(columnHome, adjModel);
                pos.flush();
                zer.flush();
                neg.flush();
            }
            if (iteration < itCount) {
                AppendableMemory<Col> npos = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iteration + 1, PartId.POS);
                AppendableMemory<Col> nzer = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iteration + 1, PartId.ZER);
                AppendableMemory<Col> nneg = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iteration + 1, PartId.NEG);
                ColumnUtil.partitionOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Positive, pos, npos, nzer, nneg, adjModel, true);
                ColumnUtil.partitionOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Negative, neg, npos, nzer, nneg, adjModel, true);
                ColumnUtil.partitionOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Zero, zer, npos, nzer, nneg, adjModel, true);
                ColumnUtil.partitionOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Zero, memory, npos, nzer, nneg, adjModel, false);
                pos = npos;
                zer = nzer;
                neg = nneg;
                cntPos = pos.getColumnCount();
                cntZer = zer.getColumnCount();
                cntNeg = neg.getColumnCount();
            } else {
                ColumnUtil.moveToOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Positive, pos, memory, adjModel, true);
                ColumnUtil.moveToOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Negative, neg, memory, adjModel, true);
                ColumnUtil.moveToOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Zero, zer, memory, adjModel, true);
            }
            colCount = cntPos + cntZer + cntNeg;
            timeEnd = System.currentTimeMillis();
        }
        if (iteration < itCount) {
            LOG.info("iteration " + iteration + "/" + itCount + ": discontinued since no modes left.");
        } else {
            LOG.info("iteration " + iteration + "/" + itCount + ": " + memory.getColumnCount() + " modes, dt=" + (timeEnd - timeStart) + "ms.");
            if (LOG.isLoggable(Level.ALL)) {
                SequentialDoubleDescriptionImpl.traceCols("cols:", 0, memory);
            }
        }
        return memory;
    }

    private static void traceCols(String prefix, int indexOffset, Iterable<?> cols) {
        int index = indexOffset;
        for (Object c : cols) {
            LOG.finest(String.valueOf(prefix) + "[" + index + "]: " + c);
            ++index;
        }
    }
}

