/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.impl;

import ch.javasoft.job.ExecJob;
import ch.javasoft.job.ExecJobMonitor;
import ch.javasoft.metabolic.efm.adj.AdjEnum;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.impl.AbstractDoubleDescriptionImpl;
import ch.javasoft.metabolic.efm.impl.LogPkg;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.IterableMemory;
import ch.javasoft.metabolic.efm.memory.MemoryFactory;
import ch.javasoft.metabolic.efm.memory.PartId;
import ch.javasoft.metabolic.efm.memory.outcore.OutOfCoreMemory;
import ch.javasoft.metabolic.efm.memory.outcore.Recovery;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.DefaultIterationStepModel;
import ch.javasoft.metabolic.efm.model.EfmModelFactory;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoverableSequentialDoubleDescriptionImpl
extends AbstractDoubleDescriptionImpl {
    private static final Logger LOG = LogPkg.LOGGER;
    private final ThreadLocal<Boolean> skipModeFiltering = new ThreadLocal();

    public RecoverableSequentialDoubleDescriptionImpl(Config config, EfmModelFactory modelFactory, MemoryFactory memoryFactory) {
        super(config, modelFactory, memoryFactory);
    }

    @Override
    protected <N extends Number, Col extends Column> IterableMemory<Col> iterate(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, AppendableMemory<Col> memory) throws IOException {
        this.skipModeFiltering.set(Boolean.FALSE);
        String flag = this.getConfig().getFlag();
        if (flag == null) {
            return this.iterateUnpartitioned(columnHome, efmModel, memory, 0);
        }
        LOG.info("found flag: " + flag);
        Recovery recovery = Recovery.getRecovery(flag);
        if (recovery == null) {
            String msg = "not a recovery flag: " + flag;
            LOG.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        return this.iterateRecover(columnHome, efmModel, memory, recovery);
    }

    private <N extends Number, Col extends Column> IterableMemory<Col> iterateUnpartitioned(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, AppendableMemory<Col> memory, int iterationStart) throws IOException {
        long tStart = System.currentTimeMillis();
        AppendableMemory<Col> pos = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iterationStart + 1, PartId.POS);
        AppendableMemory<Col> zer = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iterationStart + 1, PartId.ZER);
        AppendableMemory<Col> neg = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iterationStart + 1, PartId.NEG);
        DefaultIterationStepModel itModel = new DefaultIterationStepModel(efmModel, 0);
        ColumnUtil.partition(columnHome, efmModel, memory, pos, zer, neg, itModel, false);
        return this.iteratePartitioned(columnHome, efmModel, pos, zer, neg, iterationStart, tStart);
    }

    private <N extends Number, Col extends Column> IterableMemory<Col> iteratePartitioned(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, AppendableMemory<Col> pos, AppendableMemory<Col> zer, AppendableMemory<Col> neg, int iterationStart, long tStart) throws IOException {
        long timeStart;
        AdjEnum adjEnum = this.getConfig().getAdjMethodFactory().createAdjEnumFromConfig();
        adjEnum.initialize(columnHome, this.getConfig(), efmModel);
        AppendableMemory<Col> memory = null;
        int itCount = efmModel.getIterationCount();
        int cntPos = pos.getColumnCount();
        int cntZer = zer.getColumnCount();
        int cntNeg = neg.getColumnCount();
        int iteration = iterationStart;
        long timeEnd = timeStart = System.currentTimeMillis();
        int colCount = cntPos + cntZer + cntNeg;
        while (colCount > 0 && iteration < itCount) {
            String openFileCount = Loggers.isLoggable(LOG, Level.FINEST) ? this.getOpenFileCountString() : "";
            LOG.info("iteration " + iteration + "/" + itCount + ": " + colCount + " modes, dt=" + (timeEnd - timeStart) + "ms." + "\t{ next " + (iteration + 1) + "/" + itCount + ": " + (long)cntPos * (long)cntNeg + " adj candidates, " + "[+/0/-] = [" + cntPos + "/" + cntZer + "/" + cntNeg + "] }" + openFileCount);
            timeStart = System.currentTimeMillis();
            memory = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, ++iteration + 1, null);
            AdjEnumModel<Col> adjModel = new AdjEnumModel<Col>(efmModel, iteration, pos.toSortableMemory(), zer.toSortableMemory(), neg.toSortableMemory(), memory);
            if (cntPos > 0 && cntNeg > 0) {
                adjEnum.adjacentPairs(columnHome, adjModel);
            }
            if (iteration < itCount) {
                AppendableMemory<Col> npos = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iteration, PartId.POS);
                AppendableMemory<Col> nzer = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iteration, PartId.ZER);
                AppendableMemory<Col> nneg = this.getMemoryFactory().createConcurrentAppendableMemory(columnHome, efmModel, iteration, PartId.NEG);
                ColumnUtil.partitionOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Positive, pos, npos, nzer, nneg, adjModel, true);
                ColumnUtil.partitionOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Negative, neg, npos, nzer, nneg, adjModel, true);
                ColumnUtil.partitionOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Zero, zer, npos, nzer, nneg, adjModel, true);
                ColumnUtil.partitionOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Zero, memory, npos, nzer, nneg, adjModel, false);
                pos = npos;
                zer = nzer;
                neg = nneg;
                cntPos = pos.getColumnCount();
                cntZer = zer.getColumnCount();
                cntNeg = neg.getColumnCount();
            } else {
                ColumnUtil.moveToOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Positive, pos, memory, adjModel, true);
                ColumnUtil.moveToOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Zero, zer, memory, adjModel, true);
                ColumnUtil.moveToOrClose(columnHome, efmModel, NetworkEfmModel.Partition.Negative, neg, memory, adjModel, true);
            }
            colCount = cntPos + cntZer + cntNeg;
            timeEnd = System.currentTimeMillis();
        }
        if (iteration < itCount) {
            LOG.info("iteration " + iteration + "/" + itCount + ": discontinued since no modes left.");
        } else {
            LOG.info("iteration " + iteration + "/" + itCount + ": " + memory.getColumnCount() + " modes, dt=" + (timeEnd - timeStart) + "ms.");
        }
        long tEnd = System.currentTimeMillis();
        LOG.info("TIME iterate " + (tEnd - tStart) + "ms");
        return memory;
    }

    private <N extends Number, Col extends Column> IterableMemory<Col> iterateRecover(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, AppendableMemory<Col> memory, Recovery recovery) throws IOException {
        File dataFolder = recovery.getRecoveryFolder();
        if (!dataFolder.exists() || !dataFolder.isDirectory()) {
            String msg = "recover data folder does not exist or is not a directory: " + dataFolder.getAbsolutePath();
            LOG.severe(msg);
            throw new IOException(msg);
        }
        LOG.info("starting recovery in data folder: " + dataFolder.getAbsolutePath());
        File cfgFile = new File(dataFolder, "config.xml");
        if (cfgFile.exists()) {
            try {
                LOG.warning("config ignored: " + cfgFile.getAbsolutePath());
            }
            catch (Exception e) {
                throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
            }
        } else {
            LOG.info("no config file found, using runtime config");
        }
        int itCount = efmModel.getIterationCount();
        int colCount = memory.getColumnCount();
        LOG.info("evaluating iteration status from recovery data:");
        LOG.info("..iterations                           : " + itCount);
        LOG.info("..modes at step 0                      : " + colCount);
        OutOfCoreMemory<Col> flt = RecoverableSequentialDoubleDescriptionImpl.recoverMemoryFile(columnHome, efmModel, dataFolder, PartId.FLT);
        if (flt != null) {
            if (recovery.isTreeRecovery()) {
                throw new IOException("recovery error: filtered memory found, but recover-tree option specified");
            }
            LOG.info("..recovered final filtered memory file : " + flt.mFile.getAbsolutePath());
            LOG.info("..number of modes                      : " + flt.getColumnCount());
            LOG.info("..last completed iteration             : " + flt.mIteration);
            if (flt.mIteration != itCount) {
                throw new IOException("recovery error: iteration " + flt.mIteration + " is not " + itCount);
            }
            if (flt.mNumericSize != 0) {
                throw new IOException("recovery error: numeric size is non-zero: " + flt.mNumericSize);
            }
            this.skipModeFiltering.set(Boolean.TRUE);
            return flt;
        }
        OutOfCoreMemory<Col> pos = RecoverableSequentialDoubleDescriptionImpl.recoverMemoryFile(columnHome, efmModel, dataFolder, PartId.POS);
        if (pos != null) {
            LOG.info("..partitioned memory, tree option      : " + (recovery.isTreeRecovery() ? "on" : "off"));
            LOG.info("..recovered pos memory file            : " + pos.mFile.getAbsolutePath());
            LOG.info("..number of pos modes                  : " + pos.getColumnCount());
            OutOfCoreMemory<Col> zer = RecoverableSequentialDoubleDescriptionImpl.recoverMemoryFile(columnHome, efmModel, dataFolder, PartId.ZER);
            LOG.info("..recovered zer memory file            : " + zer.mFile.getAbsolutePath());
            LOG.info("..number of zer modes                  : " + zer.getColumnCount());
            OutOfCoreMemory<Col> neg = RecoverableSequentialDoubleDescriptionImpl.recoverMemoryFile(columnHome, efmModel, dataFolder, PartId.NEG);
            LOG.info("..recovered neg memory file            : " + neg.mFile.getAbsolutePath());
            LOG.info("..number of neg modes                  : " + neg.getColumnCount());
            if (pos.mIteration != zer.mIteration || pos.mIteration != neg.mIteration) {
                throw new IOException("recovery error: pos/zer/neg iteration indices not matching");
            }
            if (pos.mIteration > itCount) {
                throw new IOException("recovery error: iteration index " + pos.mIteration + " to large");
            }
            if (pos.mBooleanSize != zer.mBooleanSize || pos.mBooleanSize != neg.mBooleanSize) {
                throw new IOException("recovery error: pos/zer/neg boolean sizes not matching");
            }
            if (pos.mNumericSize != zer.mNumericSize || pos.mNumericSize != neg.mNumericSize) {
                throw new IOException("recovery error: pos/zer/neg numeric sizes not matching");
            }
            LOG.info("..last completed iteration             : " + pos.mIteration);
            if (pos.mIteration < itCount) {
                LOG.info("restarting iteration at step " + (pos.mIteration + 1));
                return this.iteratePartitioned(columnHome, efmModel, pos, zer, neg, pos.mIteration, System.currentTimeMillis());
            }
            throw new IOException("iteration phase complete, but partitioned memories found");
        }
        OutOfCoreMemory<Col> mem = RecoverableSequentialDoubleDescriptionImpl.recoverMemoryFile(columnHome, efmModel, dataFolder, null);
        if (mem != null) {
            if (recovery.isTreeRecovery()) {
                throw new IOException("recovery error: unpartitioned memory found, but recover-tree option specified");
            }
            LOG.info("..recovered unpartitioned memory file  : " + mem.mFile.getAbsolutePath());
            if (mem.mIteration > itCount) {
                throw new IOException("recovery error: iteration index " + mem.mIteration + " to large");
            }
            LOG.info("..last completed iteration             : " + mem.mIteration);
            if (mem.mIteration < itCount) {
                LOG.info("restarting iteration at step " + (mem.mIteration + 1));
                return this.iterateUnpartitioned(columnHome, efmModel, memory, mem.mIteration);
            }
            LOG.info("iteration phase already completed.");
            return mem;
        }
        throw new IOException("recovery error: no recoverable memory files found");
    }

    private static <Col extends Column> OutOfCoreMemory<Col> recoverMemoryFile(ColumnHome<?, Col> columnHome, NetworkEfmModel efmModel, File dataFolder, PartId partId) {
        OutOfCoreMemory.FileName fileName = partId == null ? OutOfCoreMemory.FileName.NORMAL : OutOfCoreMemory.FileName.getPartFileName(partId);
        OutOfCoreMemory<Col> mem = null;
        File[] fileArray = dataFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            int iteration = fileName.getIteration(file.getName());
            if (iteration >= 0 && (mem == null || iteration > mem.mIteration)) {
                OutOfCoreMemory.FileId<Col> fileId = fileName.getFileId(columnHome, dataFolder, iteration, efmModel.getNumericSize(iteration), efmModel.getBooleanSize(iteration), true);
                try {
                    mem = new OutOfCoreMemory<Col>(fileId);
                }
                catch (Exception e) {
                    LOG.severe("recovering memory file " + fileId.getFile().getAbsolutePath() + " failed, e=" + e);
                }
            }
            ++n2;
        }
        return mem;
    }

    @Override
    protected <N extends Number, Col extends Column> IterableMemory<Col> filterModes(ColumnHome<N, Col> columnHome, NetworkEfmModel efmModel, IterableMemory<Col> memory) throws IOException {
        if (this.skipModeFiltering.get().booleanValue()) {
            return memory;
        }
        return super.filterModes(columnHome, efmModel, memory);
    }

    private String getOpenFileCountString() {
        String cmd1 = "lsof -c java";
        String cmd2 = "grep -c " + this.getConfig().getTempDir().getPersonalizedDir().getAbsolutePath().replace(File.separatorChar, '.');
        ExecJob job1 = new ExecJob("lsof -c java");
        ExecJob job2 = new ExecJob(cmd2);
        ExecJobMonitor mon1 = job1.exec();
        ExecJobMonitor mon2 = job2.exec();
        mon1.pipeTo(mon2, true);
        try {
            return ", " + mon2.waitForStdOutString().trim() + " open files";
        }
        catch (Exception e) {
            return ", exec=lsof -c java | " + cmd2 + ", exc=" + e;
        }
    }
}

