/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.impl;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.util.Output;
import ch.javasoft.util.logging.Loggers;
import java.util.logging.Level;
import java.util.logging.Logger;

class LogPkg {
    public static final Logger LOGGER = Loggers.getLogger(LogPkg.class, -2);

    public static void logNetwork(MetabolicNetwork net, Level level) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "Network metabolites: ");
            new Output(LOGGER, level).printMetabolites(net, false, false);
            LOGGER.log(level, "Network reactions: ");
            new Output(LOGGER, level).printReactions(net, false, true);
        }
    }

    public static void logNetworkSize(String prefix, MetabolicNetwork net, Level level) {
        new Output(LOGGER, level).printNetworkSize(prefix, net);
    }

    public static void infoNetworkSize(String prefix, MetabolicNetwork net) {
        LogPkg.logNetworkSize(prefix, net, Level.INFO);
    }

    private LogPkg() {
    }
}

