/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column.filter;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.filter.ColumnFilter;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.util.ReactionMapping;
import ch.javasoft.util.ints.BitSetIntSet;
import ch.javasoft.util.ints.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutileCycleColumnFilter
implements ColumnFilter {
    private final NetworkEfmModel model;

    public FutileCycleColumnFilter(NetworkEfmModel model) {
        this.model = model;
    }

    @Override
    public <Col extends Column> boolean keepColumn(Col column, Config config, ReactionMapping rmap) {
        BitSetIntSet nonzeros = new BitSetIntSet();
        int cnt = 0;
        int i = column.bitValues().nextClearBit(0);
        while (i < column.booleanSize()) {
            nonzeros.addInt(i);
            if (++cnt > 2) {
                return true;
            }
            i = column.bitValues().nextClearBit(i + 1);
        }
        if (this.model.getFinalNumericSize() == 0) {
            i = 0;
            while (i < column.numericSize()) {
                if (column.getNumericSignum(config.zero(), i) != 0) {
                    nonzeros.addInt(column.booleanSize() + i);
                    if (++cnt > 2) {
                        return true;
                    }
                }
                ++i;
            }
        }
        BitSetIntSet orig = new BitSetIntSet();
        IntIterator it = nonzeros.iterator();
        while (it.hasNext()) {
            orig.addAll(rmap.get(ReactionMapping.Layer.Sorted, it.nextInt(), ReactionMapping.Layer.Compressed));
        }
        return orig.size() != 1;
    }
}

