/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnPair<Col extends Column> {
    private final Col colA;
    private final Col colB;

    public ColumnPair(Col colA, Col colB) {
        this.colA = colA;
        this.colB = colB;
    }

    public Col getColumnA() {
        return this.colA;
    }

    public Col getColumnB() {
        return this.colB;
    }

    public final IBitSet intersectBitValues() {
        return this.colA.bitValues().getAnd(this.colB.bitValues());
    }

    public boolean isSuperSet(Col superCandidate) {
        return !superCandidate.equals(this.colA) && !superCandidate.equals(this.colB) && this.colA.bitValues().isSubSetOf(superCandidate.bitValues());
    }

    public boolean existsSuperSet(Iterable<Col> superCandidates) {
        IBitSet inter = null;
        for (Column cand : superCandidates) {
            if (cand.equals(this.colA) || cand.equals(this.colB)) continue;
            if (inter == null) {
                inter = this.intersectBitValues();
            }
            if (!inter.isSubSetOf(cand.bitValues())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{a=");
        sb.append(this.getColumnA());
        sb.append(", b=");
        sb.append(this.getColumnB());
        sb.append(", a^b=");
        sb.append(this.intersectBitValues());
        sb.append("}");
        return sb.toString();
    }
}

