/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumn
implements Column {
    public void set(int bit) {
        this.bitValues().set(bit);
    }

    public void clear(int bit) {
        this.bitValues().clear(bit);
    }

    public void clear() {
        this.bitValues().clear();
    }

    public void flip(int bit) {
        this.bitValues().flip(bit);
    }

    @Override
    public boolean get(int bit) {
        return this.bitValues().get(bit);
    }

    public boolean isSubSetOf(Column of) {
        return this.bitValues().isSubSetOf(of.bitValues());
    }

    public void and(Column with) {
        this.bitValues().and(with.bitValues());
    }

    public void or(Column with) {
        this.bitValues().or(with.bitValues());
    }

    public int length() {
        return this.bitValues().length();
    }

    public int cardinality() {
        return this.bitValues().cardinality();
    }

    public int cardinality(int fromBit, int toBit) {
        return this.bitValues().cardinality(fromBit, toBit);
    }

    public int nextSetBit(int from) {
        return this.bitValues().nextSetBit(from);
    }

    public int nextClearBit(int from) {
        return this.bitValues().nextClearBit(from);
    }

    public BitSet toBitSet() {
        return this.bitValues().toBitSet();
    }

    @Override
    public int totalSize() {
        return this.booleanSize() + this.numericSize();
    }

    public abstract Column clone();

    public int hashCodeObj() {
        return super.hashCode();
    }

    public int hashCode() {
        return this.bitValues().hashCode();
    }

    static <N extends Number, A> ColumnInspectorModifier<N, A> getColumnInspectorModifier(EfmModel model, Class<N> numericType, Class<A> numericArrayType) {
        return model.getColumnInspectorModifierFactory().getColumnInspectorModifier(numericType, numericArrayType);
    }

    public static int partition(SortableMemory<Column> cols, int start, int end, int bit) throws IOException {
        int ind = start;
        int len = end;
        while (ind < len) {
            if (!cols.getColumn(ind).get(bit)) {
                ++ind;
                continue;
            }
            if (cols.getColumn(len - 1).get(bit)) {
                --len;
                continue;
            }
            cols.swapColumns(ind, len - 1);
            ++ind;
            --len;
        }
        assert (ind == len || ind == len + 1);
        return ind;
    }
}

