/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.memory;

import ch.javasoft.metabolic.efm.borndie.BornDieController;
import ch.javasoft.metabolic.efm.borndie.matrix.BornDieMatrix;
import ch.javasoft.metabolic.efm.borndie.model.BornDieIterationStepModel;
import ch.javasoft.metabolic.efm.borndie.range.LowerTriangularMatrix;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.DefaultIterationStepModel;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.util.Iterables;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnDemuxAppendableMemory<Col extends Column>
implements AppendableMemory<Col> {
    private final BornDieController<Col> controller;
    private final int bornColumn;
    private final AtomicInteger appendCounter = new AtomicInteger();

    public ColumnDemuxAppendableMemory(BornDieController<Col> controller, int bornColumn) {
        this.controller = controller;
        this.bornColumn = bornColumn;
    }

    protected int getDieRow(Col column) throws IOException {
        NetworkEfmModel model = this.controller.getModel();
        int itCount = this.controller.getIterationCount();
        int row = column.booleanSize() - model.getBooleanSize(1);
        while (row < itCount) {
            DefaultIterationStepModel itModel = new DefaultIterationStepModel(model, row);
            if (column.getHyperplaneSign(model, itModel.getNextState()) < 0) {
                return row;
            }
            ++row;
        }
        return itCount;
    }

    @Override
    public void appendColumn(Col column) throws IOException {
        ColumnHome<?, Col> columnHome = this.controller.getColumnHome();
        NetworkEfmModel model = this.controller.getModel();
        int dieRow = this.getDieRow(column);
        int iterationFrom = column.booleanSize() == 0 ? 0 : column.booleanSize() - model.getBooleanSize(1) + 1;
        BornDieIterationStepModel itModel = new BornDieIterationStepModel(model, iterationFrom, dieRow + 1);
        column = column.convert(columnHome, model, itModel, false);
        if (this.controller.getConfig().selfTest()) {
            int i = model.getBooleanSize(1);
            while (i < column.booleanSize()) {
                int numSgn;
                int numInd = i - model.getBooleanSize(1);
                int boolSgn = column.get(i) ? 0 : 1;
                if (boolSgn != (numSgn = column.getNumericSignum(new Zero(), numInd))) {
                    throw new RuntimeException("internal error, bool-sgn[" + i + "]=" + boolSgn + " != num-sgn[" + numInd + "]=" + numSgn + " for " + column);
                }
                ++i;
            }
        }
        this.controller.getMatrix().getForAppending(this.bornColumn, dieRow).appendColumn(column);
        this.appendCounter.incrementAndGet();
        if (this.controller.getDebugger().doDebug()) {
            this.controller.getDebugger().notifyColumnAppended(this.bornColumn, dieRow);
        }
    }

    @Override
    public void appendColumns(Iterable<? extends Col> columns) throws IOException {
        for (Column col : columns) {
            this.appendColumn(col);
        }
    }

    @Override
    public void appendFrom(IndexableMemory<? extends Col> memory) throws IOException {
        for (Column col : memory) {
            this.appendColumn(col);
        }
    }

    @Override
    public void flush() throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public SortableMemory<Col> toSortableMemory() throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public void close(boolean erase) throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public String fileId() throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public int getColumnCount() throws IOException {
        BornDieMatrix<Col> matrix = this.controller.getMatrix();
        int cnt = 0;
        LowerTriangularMatrix tril = matrix.getMatrixRange();
        int row = tril.getRowFrom(this.bornColumn);
        while (row < tril.getRowTo(this.bornColumn)) {
            cnt += matrix.getForAppending(this.bornColumn, row).getColumnCount();
            ++row;
        }
        return cnt;
    }

    @Override
    public Iterator<Col> iterator() {
        BornDieMatrix<Col> matrix = this.controller.getMatrix();
        LowerTriangularMatrix tril = matrix.getMatrixRange();
        ArrayList<AppendableMemory<Col>> mems = new ArrayList<AppendableMemory<Col>>();
        int row = tril.getRowFrom(this.bornColumn);
        while (row < tril.getRowTo(this.bornColumn)) {
            try {
                mems.add(matrix.getForAppending(this.bornColumn, row));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++row;
        }
        return Iterables.iterableIterable(mems).iterator();
    }

    public int getAppendedColumnCount() {
        return this.appendCounter.get();
    }
}

