/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.debug;

import ch.javasoft.metabolic.efm.borndie.BornDieController;
import ch.javasoft.metabolic.efm.borndie.debug.Debugger;
import ch.javasoft.metabolic.efm.borndie.debug.DebuggerTableCellRenderer;
import ch.javasoft.metabolic.efm.borndie.job.JobManager;
import ch.javasoft.metabolic.efm.borndie.job.PairingJob;
import ch.javasoft.metabolic.efm.borndie.matrix.BornDieMatrix;
import ch.javasoft.metabolic.efm.borndie.range.CellRange;
import ch.javasoft.metabolic.efm.borndie.range.LowerTriangularMatrix;
import ch.javasoft.metabolic.efm.memory.IterableMemory;
import ch.javasoft.util.Null;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class SwingDebugger
implements Debugger {
    private final JFrame frame;
    private final JTable table;
    private final JLabel lblStatus;
    private final JButton btnContinue;
    private final JCheckBox[] chkAsk;
    private final JTextArea txtArea;
    private final BornDieController controller;
    private final LowerTriangularMatrix tril;
    private final AbstractTableModel tableModel;
    private final AtomicIntegerArray cellModesAdded;
    private final AtomicIntegerArray cellModesBorn;
    private final AtomicIntegerArray bearingCellCounts;
    private final List<ConcurrentHashMap<PairingJob, Null>> cellJobs;
    private final AtomicReference<Exception> exception;
    private final AtomicInteger jobCount;
    private final AtomicInteger jobCountNoPos;
    private final AtomicReference<Ask> waitFor;

    public SwingDebugger(BornDieController controller, LowerTriangularMatrix tril) {
        int cellCnt = tril.getCellCount();
        this.frame = new JFrame("Born/Die Debugger");
        this.lblStatus = new JLabel("Ok.");
        this.btnContinue = new JButton(new AbstractAction("Continue"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                if (SwingDebugger.this.waitFor.get() != null) {
                    SwingDebugger.this.btnContinue.setEnabled(false);
                    SwingDebugger.this.waitFor.set(null);
                }
            }
        });
        this.txtArea = new JTextArea();
        this.controller = controller;
        this.tril = tril;
        this.cellModesAdded = new AtomicIntegerArray(cellCnt);
        this.cellModesBorn = new AtomicIntegerArray(cellCnt);
        this.bearingCellCounts = new AtomicIntegerArray(tril.getRowCount());
        this.cellJobs = new ArrayList<ConcurrentHashMap<PairingJob, Null>>(cellCnt);
        this.exception = new AtomicReference();
        this.jobCount = new AtomicInteger();
        this.jobCountNoPos = new AtomicInteger();
        this.waitFor = new AtomicReference();
        int i = 0;
        while (i < cellCnt) {
            this.cellJobs.add(new ConcurrentHashMap());
            ++i;
        }
        int r = 0;
        while (r < tril.getRowCount()) {
            this.bearingCellCounts.set(r, tril.getColumnTo(r) - tril.getColumnFrom(r));
            ++r;
        }
        this.tableModel = new DebuggerTableModel();
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new DebuggerMouseListener());
        this.btnContinue.setEnabled(false);
        JSplitPane pane = new JSplitPane(0, new JScrollPane(this.table), new JScrollPane(this.txtArea));
        this.table.setDefaultRenderer(Object.class, new DebuggerTableCellRenderer(controller));
        this.chkAsk = new JCheckBox[Ask.values().length];
        JPanel pnlCheck = new JPanel(new FlowLayout());
        final JCheckBox chkToggle = new JCheckBox();
        chkToggle.setAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                boolean select = chkToggle.isSelected();
                Ask[] askArray = Ask.values();
                int n = askArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Ask ask = askArray[n2];
                    if (ask.isToggled()) {
                        SwingDebugger.this.chkAsk[ask.ordinal()].setSelected(select);
                    }
                    ++n2;
                }
            }
        });
        chkToggle.setSelected(true);
        pnlCheck.add(chkToggle);
        Ask[] askArray = Ask.values();
        int n = askArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ask ask = askArray[n2];
            JCheckBox jCheckBox = new JCheckBox();
            this.chkAsk[ask.ordinal()] = jCheckBox;
            pnlCheck.add(jCheckBox);
            this.chkAsk[ask.ordinal()].setSelected(ask.defValue);
            pnlCheck.add(new JLabel(ask.caption));
            ++n2;
        }
        JPanel pnlNorth = new JPanel(new BorderLayout());
        pnlNorth.add((Component)pnlCheck, "North");
        pnlNorth.add((Component)this.lblStatus, "Center");
        pnlNorth.add((Component)this.btnContinue, "East");
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)pnlNorth, "North");
        this.frame.add((Component)pane, "Center");
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setAlwaysOnTop(true);
        pane.setDividerLocation(0.75);
        this.frame.addWindowListener(new DebuggerWindowListener());
        this.frame.setVisible(true);
    }

    public boolean doDebug() {
        return true;
    }

    public void notifyColumnAppended(int bornColumn, int dieRow) {
        int index = this.tril.cellToIndex(bornColumn, dieRow);
        this.cellModesAdded.incrementAndGet(index);
        this.fireTableCellUpdated(dieRow, bornColumn);
        this.waitToContinue(Ask.ColumnAppended);
    }

    private void fireTableCellUpdated(final int row, final int column) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingDebugger.this.tableModel.fireTableCellUpdated(row, column);
            }
        });
    }

    private void fireTableUpdated() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingDebugger.this.tableModel.fireTableDataChanged();
            }
        });
    }

    public void notifyPairingQueued(PairingJob job) {
        CellRange range = job.getCellRangeNeg();
        int index = this.tril.cellToIndex(range.getBornColumn(), range.getDieRow());
        this.cellJobs.get(index).put(job, Null.INSTANCE);
        this.waitToContinue(Ask.PairingComplete, job.toString());
    }

    public void notifyPairingComplete(PairingJob job) {
        CellRange range = job.getCellRangeNeg();
        int index = this.tril.cellToIndex(range.getBornColumn(), range.getDieRow());
        this.cellJobs.get(index).remove(job);
        this.jobCount.incrementAndGet();
        try {
            this.cellModesBorn.addAndGet(index, job.getAppendedColumnCount());
            if (job.getMemoryPos().getColumnCount() == 0) {
                this.jobCountNoPos.incrementAndGet();
            }
            this.waitToContinue(Ask.PairingQueued, job.toString());
        }
        catch (IOException e) {
            this.waitToContinue(Ask.PairingQueued, e.toString());
        }
    }

    public void notifyAllPairingJobsComplete(int bornCol, int dieRow, int leftForRow) {
        int old = this.bearingCellCounts.get(dieRow);
        while (old > leftForRow) {
            if (this.bearingCellCounts.compareAndSet(dieRow, old, leftForRow)) continue;
            old = this.bearingCellCounts.get(dieRow);
        }
        this.waitToContinue(Ask.AllPairingJobsComplete);
        if (leftForRow == 0) {
            this.waitToContinue(Ask.RowJobsComplete);
        }
    }

    public void notifyRowPairingJobsComplete(int dieRow) {
        this.bearingCellCounts.set(dieRow, 0);
        this.fireTableUpdated();
        this.waitToContinue(Ask.RowPairingJobsComplete);
    }

    public void notifyException(Exception ex) {
        if (this.exception.compareAndSet(null, ex)) {
            ex.printStackTrace();
            this.waitToContinue(Ask.Exception, ex.toString());
        }
    }

    private void setStatus(String msg) {
        this.lblStatus.setText(msg);
        this.lblStatus.invalidate();
        this.frame.validate();
    }

    public void notifyTerminate(JobManager jobManager, IterableMemory result) {
        String msg;
        try {
            msg = String.valueOf(result.getColumnCount()) + " modes, jobs=" + this.jobCount + ", empty=" + this.jobCountNoPos;
        }
        catch (Exception e) {
            msg = e.toString();
        }
        this.waitToContinue(Ask.Terminate, msg);
    }

    private void waitToContinue(Ask ask) {
        this.waitToContinue(ask, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitToContinue(Ask ask, String msg) {
        boolean stop;
        SwingDebugger swingDebugger = this;
        synchronized (swingDebugger) {
            stop = this.chkAsk[ask.ordinal()].isSelected();
        }
        if (stop) {
            while (!this.waitFor.compareAndSet(null, ask)) {
                SwingDebugger.sleep(100L);
            }
            this.setStatus("Stop: " + ask.caption + (msg == null ? "" : " (" + msg + ")"));
            this.btnContinue.setEnabled(true);
            while (this.waitFor.get() != null) {
                SwingDebugger.sleep(100L);
            }
        } else if (msg != null) {
            this.setStatus(msg);
        }
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Ask {
        ColumnAppended("Add Col", false),
        PairingQueued("New Job", false),
        PairingComplete("Job Done", false),
        AllPairingJobsComplete("All Jobs", false),
        RowPairingJobsComplete("Bearing row", true),
        RowJobsComplete("Row Jobs", false),
        Exception("Error", true),
        Terminate("End", true);

        public final String caption;
        public final boolean defValue;

        private Ask(String caption, boolean defValue) {
            this.caption = caption;
            this.defValue = defValue;
        }

        public boolean isToggled() {
            return !Exception.equals((Object)this) && !Terminate.equals((Object)this);
        }
    }

    private class DebuggerMouseListener
    extends MouseAdapter {
        private DebuggerMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int row = SwingDebugger.this.table.rowAtPoint(e.getPoint());
            int col = SwingDebugger.this.table.columnAtPoint(e.getPoint());
            SwingDebugger.this.txtArea.setText(null);
            if (row >= 0 && col >= 0 && col <= row) {
                try {
                    SwingDebugger.this.txtArea.setText(SwingDebugger.this.controller.getMatrix().getCellStage(col, row).toString(col, row));
                    if (e.getClickCount() > 1) {
                        BornDieMatrix mx = SwingDebugger.this.controller.getMatrix();
                        if (!mx.isEmpty(col, row)) {
                            IterableMemory it;
                            switch (mx.getCellStage(col, row)) {
                                case Accumulating: {
                                    it = mx.getForAppending(col, row);
                                    break;
                                }
                                case Bearing: 
                                case Collaborating: {
                                    it = mx.getNegForGenerating(col, row);
                                    break;
                                }
                                case Done: {
                                    it = mx.getFinal(col);
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            int mind = 0;
                            for (Object mode : it) {
                                SwingDebugger.this.txtArea.append("\nmode[" + mind + "]=" + mode);
                                ++mind;
                            }
                        }
                    } else {
                        int index = SwingDebugger.this.tril.cellToIndex(col, row);
                        SwingDebugger.this.txtArea.append("\nbearing cells in row: " + SwingDebugger.this.bearingCellCounts.get(row));
                        for (PairingJob job : ((ConcurrentHashMap)SwingDebugger.this.cellJobs.get(index)).keySet()) {
                            SwingDebugger.this.txtArea.append("\n" + job.toString());
                        }
                    }
                }
                catch (Exception ex) {
                    SwingDebugger.this.txtArea.append("\n" + e);
                }
            }
        }
    }

    private class DebuggerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private DebuggerTableModel() {
        }

        public int getRowCount() {
            return SwingDebugger.this.tril.getRowCount();
        }

        public int getColumnCount() {
            return SwingDebugger.this.tril.getColumnCount();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            int add;
            int brn;
            block6: {
                BornDieMatrix matrix = SwingDebugger.this.controller.getMatrix();
                if (columnIndex > rowIndex) {
                    return null;
                }
                if (matrix == null) {
                    return "0";
                }
                try {
                    brn = SwingDebugger.this.cellModesBorn.get(SwingDebugger.this.tril.cellToIndex(columnIndex, rowIndex));
                    int cur = matrix.getColumnCount(columnIndex, rowIndex);
                    if (cur > 0) {
                        return String.valueOf(cur) + (brn > 0 ? ":" + brn : "");
                    }
                    add = SwingDebugger.this.cellModesAdded.get(SwingDebugger.this.tril.cellToIndex(columnIndex, rowIndex));
                    if (add != 0) break block6;
                    return "0";
                }
                catch (IOException e) {
                    return e;
                }
            }
            return String.valueOf(add) + (brn > 0 ? ":" + brn : "");
        }
    }

    private class DebuggerWindowListener
    extends WindowAdapter {
        private DebuggerWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            if (Ask.Terminate.equals(SwingDebugger.this.waitFor.get())) {
                SwingDebugger.this.waitFor.set(null);
            } else {
                System.exit(0);
            }
        }
    }
}

