/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.search;

import ch.javasoft.metabolic.efm.adj.incore.AbstractAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.adj.incore.DefaultRankTestAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.adj.incore.tree.DefaultTreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.JobScheduleMultiThreadTreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.search.SearchRoot;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.concurrent.SemaphoreConcurrentToken;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternTreeLogLogAdjacencyEnumerator
extends AbstractAdjacencyEnumerator {
    public static final String NAME = "pattern-tree-loglog";
    private int mRequiredZeroCount;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public <Col extends Column, N extends Number> void initialize(ColumnHome<N, Col> columnHome, Config config, EfmModel model) {
        super.initialize(columnHome, config, model);
        DefaultRankTestAdjacencyEnumerator rank = new DefaultRankTestAdjacencyEnumerator(false);
        rank.initialize(columnHome, config, model);
        this.mRequiredZeroCount = rank.getRequiredZeroBitCount();
    }

    @Override
    public void adjacentPairs(Queue<ColumnPair> adjacentPairs, SortableMemory<Column> zerCols, SortableMemory<Column> posCols, SortableMemory<Column> negCols) throws IOException {
        if (this.mModel.getAdjEnumThreads() > 1) {
            JobScheduleMultiThreadTreeFactory fac = new JobScheduleMultiThreadTreeFactory(this.mModel);
            SearchRoot<SemaphoreConcurrentToken> root = new SearchRoot<SemaphoreConcurrentToken>(this.mConfig, this.mModel, fac, this.mRequiredZeroCount, posCols, zerCols, negCols);
            fac.createTraverser().traverseTree(root, posCols, zerCols, negCols, adjacentPairs);
        } else {
            DefaultTreeFactory fac = new DefaultTreeFactory(this.mModel);
            SearchRoot<Void> root = new SearchRoot<Void>(this.mConfig, this.mModel, fac, this.mRequiredZeroCount, posCols, zerCols, negCols);
            fac.createTraverser().traverseTree(root, posCols, zerCols, negCols, adjacentPairs);
        }
    }
}

