/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.metabolic.efm.adj.incore.tree.AbstractTreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.InterNode;
import ch.javasoft.metabolic.efm.adj.incore.tree.JobQueue;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.adj.incore.tree.Traverser;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.concurrent.SemaphoreConcurrentToken;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobScheduleMultiThreadTreeFactory
extends AbstractTreeFactory<SemaphoreConcurrentToken> {
    public JobScheduleMultiThreadTreeFactory(EfmModel efmModel) {
        super(efmModel);
    }

    @Override
    public InterNode<SemaphoreConcurrentToken> createInterNode(SortableMemory<Column> cols, int[] selectiveBits, int prevSelBitIndex, int iStart, int iEnd) throws IOException {
        return new InterNode<SemaphoreConcurrentToken>((TreeFactory)this, cols, selectiveBits, prevSelBitIndex, iStart, iEnd){

            @Override
            public void addAdjacentPairs(SemaphoreConcurrentToken token, Root<SemaphoreConcurrentToken> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<SemaphoreConcurrentToken> partner, boolean thisIsPos, Queue<ColumnPair> adjacentPairs) throws IOException {
                if (root.enterIfCandidates(token, this, partner)) {
                    if (partner instanceof InterNode) {
                        JobQueue<SemaphoreConcurrentToken> queue = JobQueue.createQueue(JobScheduleMultiThreadTreeFactory.this.efmModel.getConfig(), token, root, posCols, zeroCols, negCols, this, partner, thisIsPos, adjacentPairs);
                        if (queue != null) {
                            queue.execParentThread();
                        } else {
                            InterNode interPartner = (InterNode)partner;
                            this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                            this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                            this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                            this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                        }
                    } else {
                        this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
                        this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
                    }
                    root.leave(token, this, partner);
                }
            }
        };
    }

    @Override
    public Traverser<SemaphoreConcurrentToken> createTraverser() {
        return new Traverser<SemaphoreConcurrentToken>(){

            @Override
            public void traverseTree(Root<SemaphoreConcurrentToken> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Queue<ColumnPair> adjacentPairs) throws IOException {
                SemaphoreConcurrentToken token = new SemaphoreConcurrentToken(JobScheduleMultiThreadTreeFactory.this.efmModel);
                if (token.tryAcquirePermit()) {
                    root.pos().addAdjacentPairs(token, root, posCols, zeroCols, negCols, root.neg(), true, adjacentPairs);
                    token.releasePermit();
                    try {
                        token.waitForChildThreads();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    throw new RuntimeException("no initial thread");
                }
            }
        };
    }
}

