/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.DefaultRankTestAdjacencyEnumerator;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.numeric.Zero;

public class NewRankTestAdjacencyEnumerator
extends DefaultRankTestAdjacencyEnumerator {
    public static final String NAME = "new-rank";

    public NewRankTestAdjacencyEnumerator() {
        this(false);
    }

    public NewRankTestAdjacencyEnumerator(boolean isMinCardinalityTested) {
        super(isMinCardinalityTested);
    }

    public String name() {
        return NAME;
    }

    protected double[][] getRemainingMatrix(IBitSet zeroColumns, int[] rankSoFarPtr) {
        Zero zero = this.mConfig.zero();
        int stoichRows = this.mStoichRed.length;
        int stoichCols = stoichRows == 0 ? 0 : this.mStoichRed[0].length;
        int zeroCnt = 0;
        int[] keptCols = new int[stoichCols];
        int keptColCnt = 0;
        int[] keptRows = new int[stoichRows];
        int keptRowCnt = 0;
        int ii = 0;
        while (ii < stoichCols) {
            int col = this.mColMapping[ii];
            if (zeroColumns.get(ii)) {
                if (col < stoichRows) {
                    keptRows[keptRowCnt++] = col;
                }
                ++zeroCnt;
            } else {
                keptCols[keptColCnt++] = col;
            }
            ++ii;
        }
        double[][] arr = new double[keptRowCnt][keptColCnt];
        int zeroCols = 0;
        int oneValueCols = 0;
        int newCol = 0;
        int iCol = 0;
        while (iCol < keptColCnt) {
            int col = keptCols[iCol];
            int cntNonZeros = 0;
            int rowNonZero = -1;
            int iRow = 0;
            while (iRow < keptRowCnt - oneValueCols) {
                double val;
                int row = keptRows[iRow];
                arr[iRow][newCol] = val = this.mStoichRed[row][col];
                if (zero.isNonZero(val)) {
                    rowNonZero = iRow;
                    ++cntNonZeros;
                }
                ++iRow;
            }
            if (cntNonZeros == 1) {
                Arrays.swapRow(arr, rowNonZero, keptRowCnt - ++oneValueCols);
                Arrays.swap(keptRows, rowNonZero, keptRowCnt - oneValueCols);
            } else if (cntNonZeros > 1) {
                ++newCol;
            } else {
                ++zeroCols;
            }
            ++iCol;
        }
        rankSoFarPtr[0] = stoichRows + zeroCnt - (keptRowCnt - oneValueCols);
        if (zeroCols + oneValueCols > 0) {
            double[][] zarr = new double[keptRowCnt - oneValueCols][keptColCnt - zeroCols - oneValueCols];
            int i = 0;
            while (i < zarr.length) {
                System.arraycopy(arr[i], 0, zarr[i], 0, zarr[i].length);
                ++i;
            }
            return zarr;
        }
        return arr;
    }
}

