/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.cdd.parser.CddParser;
import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.CddHelper;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.LogPkg;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import junit.framework.TestCase;

public class CddExtTest
extends TestCase {
    private static final File FOLDER_EXT = new File("../cdd-data/ext");

    static {
        CompressionMethod[] compression = CompressionMethod.NONE;
        if (Config.initForJUnitTest("pattern-tree-minzero", "FewestNegPosOrMostZeros", compression, false, Arithmetic.varint)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
        }
    }

    public void testCcp4() throws IOException {
        this.internalTestExt("ccp4.ext");
    }

    public void testCcp5() throws IOException {
        this.internalTestExt("ccp5.ext");
    }

    public void testCcp6() throws IOException {
        this.internalTestExt("ccp6.ext");
    }

    public void testCcp7() throws IOException {
        this.internalTestExt("ccp7.ext");
    }

    public void testCcp8() throws IOException {
        this.internalTestExt("ccp8.ext");
    }

    public void testCcc6() throws IOException {
        this.internalTestExt("ccc6.ext");
    }

    public void testCcc7() throws IOException {
        this.internalTestExt("ccc7.ext");
    }

    public void testCube6() throws IOException {
        this.internalTestExt("cube6.ext");
    }

    public void testCube8() throws IOException {
        this.internalTestExt("cube8.ext");
    }

    public void testCube10() throws IOException {
        this.internalTestExt("cube10.ext");
    }

    public void testCross6() throws IOException {
        this.internalTestExt("cross6.ext");
    }

    public void testCross8() throws IOException {
        this.internalTestExt("cross8.ext");
    }

    public void testCross10() throws IOException {
        this.internalTestExt("cross10.ext");
    }

    public void testProdmT62() throws IOException {
        this.internalTestExt("prodmT62.ext");
    }

    public void testTc7_30() throws IOException {
        this.internalTestExt("tc7-30.ext");
    }

    public void testTc8_38() throws IOException {
        this.internalTestExt("tc8-38.ext");
    }

    public void testTc9_48() throws IOException {
        this.internalTestExt("tc9-48.ext");
    }

    public void testTc10_83() throws IOException {
        this.internalTestExt("tc10-83.ext");
    }

    public void testTc11_106() throws IOException {
        this.internalTestExt("tc11-106.ext");
    }

    public void testTc12_152() throws IOException {
        this.internalTestExt("tc12-152.ext");
    }

    public void testTc13_254() throws IOException {
        this.internalTestExt("tc13-254.ext");
    }

    public void internalTestExt(String fileName) throws FileNotFoundException, IOException {
        File file = new File(FOLDER_EXT, fileName);
        CddParser parser = new CddParser(file);
        BigFraction[][] mx = CddHelper.getMatrix(parser);
        int dims = mx.length == 0 ? 0 : mx[0].length;
        LogPkg.LOGGER.info(String.valueOf(mx.length) + "x" + mx[0].length + " matrix for cdd file: " + file.getAbsolutePath());
        mx = CddHelper.addSlackVariables(mx);
        boolean[] reversible = new boolean[mx.length == 0 ? 0 : mx[0].length];
        int i = 0;
        while (i < dims) {
            reversible[i] = true;
            ++i;
        }
        FractionNumberStoichMetabolicNetwork metaNet = new FractionNumberStoichMetabolicNetwork(new DefaultBigIntegerRationalMatrix(mx, true), reversible);
        if (!Config.getConfig().getReactionsNoSplit().isEmpty()) {
            throw new RuntimeException("non-empty no split reactions");
        }
        int i2 = 0;
        while (i2 < dims) {
            Config.getConfig().getReactionsNoSplit().add(metaNet.getReactions().get(i2).getName());
            ++i2;
        }
        ElementaryFluxModes.calculateFileMatlab(metaNet, new File("/tmp"), "efms.mat");
    }
}

