/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.LogPkg;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.output.mat.MatFileOutputCallback;
import ch.javasoft.metabolic.impl.FilteredMetabolicNetwork;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnneTest
extends ch.javasoft.metabolic.parse.AnneTest {
    private static final Logger LOG;

    static {
        CompressionMethod[] compression = CompressionMethod.STANDARD;
        if (Config.initForJUnitTest("pattern-tree-rank-update-modpi", compression, Arithmetic.fractional)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
            Logger.getLogger("compress.data").setLevel(Level.INFO);
        }
        LOG = LogPkg.LOGGER;
    }

    @Override
    public void testAnneYeast_all() throws Exception {
        super.testAnneYeast_all();
    }

    @Override
    public void testAnneYeast_glc() throws Exception {
        super.testAnneYeast_glc();
    }

    @Override
    public void testAnneYeast_eth() throws Exception {
        super.testAnneYeast_eth();
    }

    @Override
    public void testAnneYeast_iAK0815_Glc_Etoh() throws Exception {
        super.testAnneYeast_iAK0815_Glc_Etoh();
    }

    @Override
    public void testAnneYeast_iAK0815_Glc() throws Exception {
        super.testAnneYeast_iAK0815_Glc();
    }

    @Override
    public void testAnneYeast_iAK0815_Etoh() throws Exception {
        super.testAnneYeast_iAK0815_Etoh();
    }

    @Override
    protected void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
        if (suppressedReactions != null && !suppressedReactions.isEmpty()) {
            FilteredMetabolicNetwork filtered = new FilteredMetabolicNetwork(network, suppressedReactions);
            this.internalTestMetabolicNetwork(network, filtered);
        } else {
            this.internalTestMetabolicNetwork(network, network);
        }
    }

    public void internalTestMetabolicNetwork(MetabolicNetwork originalNetwork, MetabolicNetwork reducedNetwork) throws Exception {
        File outFile = new File("/local/tmp/anne_yeast_red.mat");
        String fileNameNoEnding = outFile.getName().substring(0, outFile.getName().lastIndexOf(46));
        ElementaryFluxModes.calculateCallback(reducedNetwork, new MatFileOutputCallback(originalNetwork, outFile.getParentFile(), fileNameNoEnding, 500000L));
        LOG.info("written modes to file(s): " + outFile.getAbsolutePath());
        LOG.info("done.");
    }
}

