/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compress.generate;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.compress.CompressionUtil;
import ch.javasoft.metabolic.compress.DuplicateGeneCompressor;
import ch.javasoft.metabolic.compress.StoichMatrixCompressedMetabolicNetwork;
import ch.javasoft.metabolic.compress.StoichMatrixCompressor;
import ch.javasoft.metabolic.compress.generate.LogPkg;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.metabolic.util.MetabolicNetworkUtil;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatlabGenerator
extends ch.javasoft.metabolic.generate.MatlabGenerator {
    private static final Logger LOG = LogPkg.LOGGER;

    public MatlabGenerator() {
    }

    public MatlabGenerator(String modelName) {
        super(modelName);
    }

    public MetabolicNetwork writeDuplicateGeneCompression(MetabolicNetwork net, PrintWriter pw, boolean sparse, CompressionMethod ... compressionMethods) {
        if (CompressionMethod.isContainingDuplicateGene(compressionMethods)) {
            ReadableBigIntegerRationalMatrix stoich = FractionNumberStoichMetabolicNetwork.getStoich(net);
            DuplicateGeneCompressor.CompressionRecord rec = DuplicateGeneCompressor.compress(stoich, net.getReactionReversibilities(), net.getMetaboliteNames(), net.getReactionNames(), CompressionMethod.DuplicateGeneExtended.containedIn(compressionMethods));
            CompressionUtil.logCompressionRecord(rec, Level.FINER);
            int i = 0;
            while (i < rec.dupgroups.length) {
                pw.print(String.valueOf(this.getStructureName()) + ".dupgroups{" + (i + 1) + "}=[");
                int j = 0;
                while (j < rec.dupgroups[i].length()) {
                    if (j > 0) {
                        pw.print(", ");
                    }
                    pw.print(rec.dupgroups[i].get(j) + 1);
                    ++j;
                }
                pw.println("];");
                ++i;
            }
            if (rec.dupgroups.length != 0) {
                this.writeMatrix(rec.dupelim.getDoubleRows(), "dupelim", pw, sparse);
                this.writeMatrix(rec.dupfree.getDoubleRows(), "dupfree", pw, sparse);
                pw.flush();
                return new FractionNumberStoichMetabolicNetwork(rec.metaNames, rec.reacNames, rec.dupfree, rec.reversible);
            }
            pw.flush();
            return net;
        }
        throw new IllegalArgumentException("no duplicate gene compression methods specified: " + Arrays.toString((Object[])compressionMethods));
    }

    public StoichMatrixCompressedMetabolicNetwork writeNonDuplicateGeneCompression(MetabolicNetwork net, PrintWriter pw, boolean sparse, Set<String> suppressedReactions, CompressionMethod ... compressionMethods) {
        ReadableBigIntegerRationalMatrix stoich = FractionNumberStoichMetabolicNetwork.getStoich(net);
        StoichMatrixCompressor cmp = new StoichMatrixCompressor(CompressionMethod.removeDuplicateGeneMethods(compressionMethods));
        StoichMatrixCompressor.CompressionRecord rec = cmp.compress(stoich, net.getReactionReversibilities(), net.getMetaboliteNames(), net.getReactionNames(), suppressedReactions);
        CompressionUtil.logCompressionRecord(rec, Level.FINER);
        this.writeMatrix(rec.pre.getDoubleRows(), "cmppre", pw, sparse);
        this.writeMatrix(rec.post.getDoubleRows(), "cmppost", pw, sparse);
        this.writeMatrix(rec.cmp.getDoubleRows(), "cmp", pw, sparse);
        pw.flush();
        StoichMatrixCompressedMetabolicNetwork cmpNet = new StoichMatrixCompressedMetabolicNetwork(net, rec.pre, rec.post, rec.cmp);
        if (!Arrays.equals(rec.reversible, cmpNet.getReactionReversibilities())) {
            LOG.warning("reversibility missmatch:");
            LOG.warning("  reversibility(cmp.rec) = " + Arrays.toString(rec.reversible));
            LOG.warning("  reversibility(cmp.net) = " + Arrays.toString(cmpNet.getReactionReversibilities()));
        }
        return cmpNet;
    }

    public void writeAll(MetabolicNetwork net, PrintWriter pw, Set<String> suppressedReactions, CompressionMethod ... compressionMethods) {
        this.writeAll(net, pw, false, true, suppressedReactions, compressionMethods);
    }

    public StoichMatrixCompressedMetabolicNetwork writeAll(MetabolicNetwork net, PrintWriter pw, boolean expandReversible, boolean sparse, Set<String> suppressedReactions, CompressionMethod ... compressionMethods) {
        super.writeAll(net, pw, expandReversible, sparse);
        LOG.info("original network:            " + MetabolicNetworkUtil.getNetworkSizeString("", net));
        pw.print(String.valueOf(this.getStructureName()) + ".cmpinfo='");
        int i = 0;
        while (i < compressionMethods.length) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print((Object)compressionMethods[i]);
            ++i;
        }
        pw.println("';");
        if (CompressionMethod.isContainingDuplicateGene(compressionMethods)) {
            net = this.writeDuplicateGeneCompression(net, pw, sparse, compressionMethods);
            compressionMethods = CompressionMethod.removeDuplicateGeneMethods(compressionMethods);
            LOG.info("duplicate gene free network: " + MetabolicNetworkUtil.getNetworkSizeString("", net));
        } else {
            LOG.info("duplicate gene free network: -");
        }
        StoichMatrixCompressedMetabolicNetwork cmpNet = this.writeNonDuplicateGeneCompression(net, pw, sparse, suppressedReactions, compressionMethods);
        LOG.info("compressed network:          " + MetabolicNetworkUtil.getNetworkSizeString("", cmpNet));
        return cmpNet;
    }
}

