/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compress;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.compress.CompressedMetabolicNetwork;
import ch.javasoft.metabolic.impl.AbstractReaction;
import ch.javasoft.metabolic.impl.DefaultReactionConstraints;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericFixSizeArray;
import ch.javasoft.util.map.DefaultIntIntMultiValueMap;
import ch.javasoft.util.map.IntIntMultiValueMap;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoichMatrixCompressedMetabolicNetwork
extends FractionNumberStoichMetabolicNetwork
implements CompressedMetabolicNetwork {
    private final MetabolicNetwork mParentNetwork;
    private final BigIntegerRationalMatrix mPost;
    private final BigIntegerRationalMatrix mStoichCompressed;
    private int[][] tSparsePostIndices;
    private BigFraction[][] tSparsePostFrns;
    private double[][] tSparsePostDbls;

    public StoichMatrixCompressedMetabolicNetwork(BigIntegerRationalMatrix stoichOrig, boolean[] origReversible, BigIntegerRationalMatrix pre, BigIntegerRationalMatrix post, BigIntegerRationalMatrix compressedStoich) {
        this(new FractionNumberStoichMetabolicNetwork(stoichOrig, origReversible), pre, post, compressedStoich);
    }

    public StoichMatrixCompressedMetabolicNetwork(String[] origMetaboliteNames, String[] origReactionNames, boolean[] origReversible, BigIntegerRationalMatrix pre, BigIntegerRationalMatrix origStoich, BigIntegerRationalMatrix post, BigIntegerRationalMatrix compressedStoich) {
        this(new FractionNumberStoichMetabolicNetwork(origMetaboliteNames, origReactionNames, origStoich, origReversible), pre, post, compressedStoich);
    }

    public StoichMatrixCompressedMetabolicNetwork(MetabolicNetwork original, BigIntegerRationalMatrix pre, BigIntegerRationalMatrix post, BigIntegerRationalMatrix compressedStoich) {
        super(StoichMatrixCompressedMetabolicNetwork.getMetaboliteNames(original, pre, post, compressedStoich), StoichMatrixCompressedMetabolicNetwork.getReactionNames(original, pre, post, compressedStoich), compressedStoich, StoichMatrixCompressedMetabolicNetwork.getReversible(original, pre, post, compressedStoich));
        this.mParentNetwork = original;
        this.mPost = post;
        this.mStoichCompressed = compressedStoich;
    }

    @Override
    public MetabolicNetwork getParentNetwork() {
        return this.mParentNetwork;
    }

    @Override
    public MetabolicNetwork getRootNetwork() {
        return this.mParentNetwork instanceof CompressedMetabolicNetwork ? ((CompressedMetabolicNetwork)this.mParentNetwork).getRootNetwork() : this.mParentNetwork;
    }

    @Override
    public List<Metabolite> getMappedMetabolites(List<Metabolite> original) {
        ArrayList<Metabolite> res = new ArrayList<Metabolite>(original.size());
        int i = 0;
        while (i < original.size()) {
            Metabolite orig = original.get(i);
            int index = this.getMetaboliteIndex(orig.getName());
            res.add(index < 0 ? null : orig);
            ++i;
        }
        return res;
    }

    @Override
    public List<Reaction> getMappedReactions(List<Reaction> original) {
        ArrayList<Reaction> res = new ArrayList<Reaction>(original.size());
        int i = 0;
        while (i < original.size()) {
            Reaction orig = original.get(i);
            int origIndex = this.mParentNetwork.getReactionIndex(orig.getName());
            ArrayList<Reaction> mappings = new ArrayList<Reaction>(1);
            int newIndex = 0;
            while (newIndex < this.mStoichCompressed.getColumnCount()) {
                if (this.mPost.getSignumAt(origIndex, newIndex) != 0) {
                    mappings.add(this.getReactions().get(newIndex));
                }
                ++newIndex;
            }
            if (mappings.size() == 0) {
                res.add(null);
            } else if (mappings.size() == 1) {
                res.add((Reaction)mappings.get(0));
            } else {
                res.add(new MultiplexedReaction());
            }
            ++i;
        }
        return res;
    }

    @Override
    public FluxDistribution uncompressFluxDistribution(FluxDistribution fluxDistribution) {
        FluxDistribution uncompressed = fluxDistribution.getPreferredNumberClass() == Double.class ? this.uncompressFluxDistributionsDouble(fluxDistribution) : this.uncompressFluxDistributionFactional(fluxDistribution);
        if (this.mParentNetwork instanceof CompressedMetabolicNetwork) {
            return ((CompressedMetabolicNetwork)this.mParentNetwork).uncompressFluxDistribution(uncompressed);
        }
        return uncompressed;
    }

    private synchronized void initSparsePostMatrix() {
        if (this.tSparsePostIndices == null) {
            int compReacs = this.getReactions().length();
            int origReacs = this.mParentNetwork.getReactions().length();
            BigFraction[] template = new BigFraction[]{};
            this.tSparsePostIndices = new int[origReacs][];
            this.tSparsePostFrns = new BigFraction[origReacs][];
            int origReac = 0;
            while (origReac < origReacs) {
                IntArray indices = new IntArray();
                ArrayList<BigFraction> values = new ArrayList<BigFraction>();
                int compReac = 0;
                while (compReac < compReacs) {
                    if (this.mPost.getSignumAt(origReac, compReac) != 0) {
                        indices.add(compReac);
                        values.add(this.mPost.getBigFractionValueAt(origReac, compReac));
                    }
                    ++compReac;
                }
                this.tSparsePostIndices[origReac] = indices.toArray();
                this.tSparsePostFrns[origReac] = values.toArray(template);
                ++origReac;
            }
        }
    }

    private synchronized void initSparsePostMatrixDbl() {
        if (this.tSparsePostDbls == null) {
            this.initSparsePostMatrix();
            this.tSparsePostDbls = new double[this.tSparsePostFrns.length][];
            int i = 0;
            while (i < this.tSparsePostDbls.length) {
                this.tSparsePostDbls[i] = new double[this.tSparsePostFrns[i].length];
                int j = 0;
                while (j < this.tSparsePostDbls[i].length) {
                    this.tSparsePostDbls[i][j] = this.tSparsePostFrns[i][j].doubleValue();
                    ++j;
                }
                ++i;
            }
        }
    }

    public FluxDistribution uncompressFluxDistributionFactional(FluxDistribution compFluxDist) {
        this.initSparsePostMatrix();
        int origReacs = this.mParentNetwork.getReactions().length();
        FluxDistribution origFluxDist = compFluxDist.create(this.mParentNetwork);
        int origReac = 0;
        while (origReac < origReacs) {
            BigFraction origFlux = BigFraction.ZERO;
            int i = 0;
            while (i < this.tSparsePostIndices[origReac].length) {
                int compReac = this.tSparsePostIndices[origReac][i];
                BigFraction cmpFlux = BigFraction.valueOf(compFluxDist.getNumberRate(compReac));
                if (!cmpFlux.isZero()) {
                    BigFraction mul = this.tSparsePostFrns[origReac][i];
                    BigFraction add = cmpFlux.multiply(mul);
                    origFlux = origFlux.add(add).reduce();
                }
                ++i;
            }
            origFluxDist.setRate(origReac, (Number)origFlux);
            ++origReac;
        }
        return origFluxDist;
    }

    public FluxDistribution uncompressFluxDistributionsDouble(FluxDistribution compFluxDist) {
        this.initSparsePostMatrixDbl();
        int origReacs = this.mParentNetwork.getReactions().length();
        FluxDistribution origFluxDist = compFluxDist.create(this.mParentNetwork);
        int origReac = 0;
        while (origReac < origReacs) {
            double origFlux = 0.0;
            int i = 0;
            while (i < this.tSparsePostIndices[origReac].length) {
                int compReac = this.tSparsePostIndices[origReac][i];
                double cmpFlux = compFluxDist.getDoubleRates()[compReac];
                if (cmpFlux != 0.0) {
                    origFlux += cmpFlux * this.tSparsePostDbls[origReac][i];
                }
                ++i;
            }
            origFluxDist.getDoubleRates()[origReac] = origFlux;
            ++origReac;
        }
        return origFluxDist;
    }

    private static boolean[] getReversible(MetabolicNetwork original, BigIntegerRationalMatrix pre, BigIntegerRationalMatrix post, BigIntegerRationalMatrix stoichCompressed) {
        boolean[] revs = new boolean[stoichCompressed.getColumnCount()];
        int newReac = 0;
        while (newReac < revs.length) {
            boolean reversible = true;
            int oldReac = 0;
            while (oldReac < original.getReactions().length() && reversible) {
                if (post.getSignumAt(oldReac, newReac) != 0) {
                    reversible &= original.getReactions().get(oldReac).getConstraints().isReversible();
                }
                ++oldReac;
            }
            revs[newReac] = reversible;
            ++newReac;
        }
        return revs;
    }

    private static String[] getMetaboliteNames(MetabolicNetwork original, BigIntegerRationalMatrix pre, BigIntegerRationalMatrix post, BigIntegerRationalMatrix stoichCompressed) {
        String[] newNames = new String[stoichCompressed.getRowCount()];
        int newMeta = 0;
        while (newMeta < newNames.length) {
            StringBuilder sb = new StringBuilder();
            int oldMeta = 0;
            while (oldMeta < original.getMetabolites().length()) {
                if (pre.getSignumAt(newMeta, oldMeta) != 0) {
                    if (sb.length() > 0) {
                        sb.append("::");
                    }
                    sb.append(original.getMetabolites().get(oldMeta).getName());
                }
                ++oldMeta;
            }
            newNames[newMeta] = sb.toString();
            ++newMeta;
        }
        return newNames;
    }

    private static String[] getReactionNames(MetabolicNetwork original, BigIntegerRationalMatrix pre, BigIntegerRationalMatrix post, BigIntegerRationalMatrix stoichCompressed) {
        String[] newNames = new String[stoichCompressed.getColumnCount()];
        int newReac = 0;
        while (newReac < newNames.length) {
            StringBuilder sb = new StringBuilder();
            int oldReac = 0;
            while (oldReac < original.getReactions().length()) {
                if (post.getSignumAt(oldReac, newReac) != 0) {
                    if (sb.length() > 0) {
                        sb.append("::");
                    }
                    sb.append(original.getReactions().get(oldReac).getName());
                }
                ++oldReac;
            }
            newNames[newReac] = sb.toString();
            ++newReac;
        }
        return newNames;
    }

    @Override
    public IntIntMultiValueMap getReactionMapping() {
        this.initSparsePostMatrix();
        DefaultIntIntMultiValueMap map = new DefaultIntIntMultiValueMap();
        int origReacs = this.mParentNetwork.getReactions().length();
        int origReac = 0;
        while (origReac < origReacs) {
            map.addAll(origReac, this.tSparsePostIndices[origReac]);
            ++origReac;
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiplexedReaction
    extends AbstractReaction {
        @Override
        public ReactionConstraints getConstraints() {
            return new DefaultReactionConstraints(Double.NaN, Double.NaN);
        }

        @Override
        public ArrayIterable<? extends MetaboliteRatio> getMetaboliteRatios() {
            GenericFixSizeArray ratios = new GenericFixSizeArray(1);
            return ratios;
        }

        @Override
        public String getName() {
            return "MultiplexedReaction[@" + this.objHashCode() + "]";
        }

        @Override
        public int hashCode() {
            return this.objHashCode();
        }
    }
}

