/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compartment;

import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.compartment.CompartmentMetaboliteRatio;
import ch.javasoft.metabolic.impl.DefaultReaction;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericDynamicArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompartmentReaction
extends DefaultReaction {
    private final String mFullName;

    public CompartmentReaction(String name, String fullName, Iterable<? extends CompartmentMetaboliteRatio> metaboliteRatios, boolean reversible) {
        super(name, metaboliteRatios, reversible);
        this.mFullName = fullName;
    }

    public CompartmentReaction(String name, String fullName, CompartmentMetaboliteRatio[] metaboliteRatios, boolean reversible) {
        super(name, (MetaboliteRatio[])metaboliteRatios, reversible);
        this.mFullName = fullName;
    }

    public CompartmentReaction(String name, String fullName, ArrayIterable<? extends CompartmentMetaboliteRatio> metaboliteRatios, boolean reversible) {
        super(name, metaboliteRatios, reversible);
        this.mFullName = fullName;
    }

    public CompartmentReaction(String name, String fullName, CompartmentMetaboliteRatio[] metaboliteRatios, ReactionConstraints constraints) {
        super(name, (MetaboliteRatio[])metaboliteRatios, constraints);
        this.mFullName = fullName;
    }

    public CompartmentReaction(String name, String fullName, ArrayIterable<? extends CompartmentMetaboliteRatio> metaboliteRatios, ReactionConstraints constraints) {
        super(name, metaboliteRatios, constraints);
        this.mFullName = fullName;
    }

    @Override
    public String getFullName() {
        return this.mFullName;
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getMetaboliteRatios() {
        return super.getMetaboliteRatios();
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getEductRatios() {
        return super.getEductRatios();
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getProductRatios() {
        return super.getProductRatios();
    }

    public boolean isCompartmentInternal() {
        String cmp = null;
        for (CompartmentMetaboliteRatio compartmentMetaboliteRatio : this.getMetaboliteRatios()) {
            if (cmp == null) {
                cmp = compartmentMetaboliteRatio.getMetabolite().getCompartment();
                continue;
            }
            if (cmp.equals(compartmentMetaboliteRatio.getMetabolite().getCompartment())) continue;
            return false;
        }
        return true;
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getMetabolieRatiosForCompartment(String compartment) {
        return this.getMetabolieRatiosForCompartment(compartment, MetaKind.ALL, true);
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getMetabolieRatiosExcludeCompartment(String compartment) {
        return this.getMetabolieRatiosForCompartment(compartment, MetaKind.ALL, false);
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getEductRatiosForCompartment(String compartment) {
        return this.getMetabolieRatiosForCompartment(compartment, MetaKind.EDUCTS, true);
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getEductRatiosExcludeCompartment(String compartment) {
        return this.getMetabolieRatiosForCompartment(compartment, MetaKind.EDUCTS, false);
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getProductRatiosForCompartment(String compartment) {
        return this.getMetabolieRatiosForCompartment(compartment, MetaKind.PRODUCTS, true);
    }

    public ArrayIterable<? extends CompartmentMetaboliteRatio> getProductRatiosExcludeCompartment(String compartment) {
        return this.getMetabolieRatiosForCompartment(compartment, MetaKind.PRODUCTS, false);
    }

    private ArrayIterable<? extends CompartmentMetaboliteRatio> getMetabolieRatiosForCompartment(String compartment, MetaKind kind, boolean include) {
        ArrayIterable<? extends CompartmentMetaboliteRatio> itRatios;
        GenericDynamicArray<CompartmentMetaboliteRatio> ratios = new GenericDynamicArray<CompartmentMetaboliteRatio>();
        switch (kind) {
            case ALL: {
                itRatios = this.getMetaboliteRatios();
                break;
            }
            case PRODUCTS: {
                itRatios = this.getProductRatios();
                break;
            }
            case EDUCTS: {
                itRatios = this.getEductRatios();
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal kind: " + (Object)((Object)kind));
            }
        }
        for (CompartmentMetaboliteRatio compartmentMetaboliteRatio : itRatios) {
            boolean fit = compartment.equals(compartmentMetaboliteRatio.getMetabolite().getCompartment());
            if (fit != include) continue;
            ratios.add(compartmentMetaboliteRatio);
        }
        return ratios;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MetaKind {
        ALL,
        PRODUCTS,
        EDUCTS;

    }
}

