/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.varint.array;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.impl.DefaultArrayOperations;
import ch.javasoft.math.linalg.DefaultLinAlgOperations;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.operator.AbstractBinaryOperator;
import ch.javasoft.math.operator.AbstractBooleanBinaryOperator;
import ch.javasoft.math.operator.AbstractBooleanUnaryOperator;
import ch.javasoft.math.operator.AbstractIntBinaryOperator;
import ch.javasoft.math.operator.AbstractIntUnaryOperator;
import ch.javasoft.math.operator.AbstractNullaryOperator;
import ch.javasoft.math.operator.AbstractUnaryOperator;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanBinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.ConvertingUnaryOperator;
import ch.javasoft.math.operator.DivisionSupport;
import ch.javasoft.math.operator.IntBinaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.math.varint.VarIntFactory;
import ch.javasoft.math.varint.VarIntNumber;
import ch.javasoft.math.varint.array.VarIntGaussPivoting;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarIntOperators
implements NumberOperators<VarIntNumber, VarIntNumber[]> {
    public static final VarIntOperators INTEGER_DIVISION_INSTANCE = new VarIntOperators(DivisionMode.Integer, ConversionMode.Truncate);
    public static final VarIntOperators NO_DIVISION_INSTANCE = new VarIntOperators(DivisionMode.None, ConversionMode.Exact);
    public static final VarIntOperators EXACT_DIVISION_INSTANCE = new VarIntOperators(DivisionMode.Exact, ConversionMode.Exact);
    public static final VarIntOperators ROUNDED_DIVISION_INSTANCE = new VarIntOperators(DivisionMode.Round, ConversionMode.Round);
    private final LinAlgOperations<VarIntNumber, VarIntNumber[]> linAlgOps;
    private final DivisionMode divisionMode;
    private final ConversionMode conversionMode;
    private final NullaryOperator<VarIntNumber, VarIntNumber[]>[] nullary;
    private final UnaryOperator<VarIntNumber, VarIntNumber[]>[] unary;
    private final BooleanUnaryOperator<VarIntNumber, VarIntNumber[]>[] boolUnary;
    private final IntUnaryOperator<VarIntNumber, VarIntNumber[]>[] intUnary;
    private final ConvertingUnaryOperator<Number, Number[], VarIntNumber, VarIntNumber[]> converter;
    private final BinaryOperator<VarIntNumber, VarIntNumber[]>[] binary;
    private final BooleanBinaryOperator<VarIntNumber, VarIntNumber[]>[] boolBinary;
    private final IntBinaryOperator<VarIntNumber, VarIntNumber[]>[] intBinary;
    private final AggregatingUnaryOperator<VarIntNumber, VarIntNumber[]>[] aggUnary;
    private final AggregatingBinaryOperator<VarIntNumber, VarIntNumber[]>[] aggBinary;

    public VarIntOperators(DivisionMode divMode, ConversionMode convMode) {
        this.divisionMode = divMode;
        this.conversionMode = convMode;
        this.nullary = VarIntOperators.initNullary();
        this.unary = VarIntOperators.initUnary(divMode);
        this.boolUnary = VarIntOperators.initBoolUnary();
        this.intUnary = VarIntOperators.initIntUnary();
        this.converter = this.initConverter(convMode);
        this.binary = VarIntOperators.initBinary(divMode);
        this.boolBinary = VarIntOperators.initBoolBinary();
        this.intBinary = VarIntOperators.initIntBinary();
        this.aggUnary = VarIntOperators.initAggUnary();
        this.aggBinary = VarIntOperators.initAggBinary();
        this.linAlgOps = new DefaultLinAlgOperations<VarIntNumber, VarIntNumber[]>(this, new DefaultArrayOperations((Class<C[]>)VarIntNumber[].class), VarIntGaussPivoting.LEN_L);
    }

    @Override
    public Class<VarIntNumber> numberClass() {
        return VarIntNumber.class;
    }

    @Override
    public Class<VarIntNumber[]> arrayClass() {
        return VarIntNumber[].class;
    }

    public DivisionMode getDivisionMode() {
        return this.divisionMode;
    }

    @Override
    public LinAlgOperations<VarIntNumber, VarIntNumber[]> getLinAlgOperations() {
        return this.linAlgOps;
    }

    @Override
    public LinAlgOperations<VarIntNumber, VarIntNumber[]> getLinAlgOperations(GaussPivotingFactory<VarIntNumber, VarIntNumber[]> gaussPivotingFactory) {
        return new DefaultLinAlgOperations<VarIntNumber, VarIntNumber[]>(this.getNumberArrayOperations(), gaussPivotingFactory);
    }

    @Override
    public ArrayOperations<VarIntNumber[]> getArrayOperations() {
        return this.linAlgOps.getArrayOperations();
    }

    @Override
    public NumberArrayOperations<VarIntNumber, VarIntNumber[]> getNumberArrayOperations() {
        return this.linAlgOps.getNumberArrayOperations();
    }

    public ConversionMode getConversionMode() {
        return this.conversionMode;
    }

    @Override
    public DivisionSupport getDivisionSupport() {
        return this.divisionMode;
    }

    @Override
    public VarIntNumber zero() {
        return VarIntNumber.ZERO;
    }

    @Override
    public VarIntNumber one() {
        return VarIntNumber.ONE;
    }

    @Override
    public NullaryOperator<VarIntNumber, VarIntNumber[]> constant(VarIntNumber value) {
        if (value.equals(VarIntNumber.ZERO)) {
            return this.nullary(NullaryOperator.Id.zero);
        }
        if (value.equals(VarIntNumber.ONE)) {
            return this.nullary(NullaryOperator.Id.one);
        }
        return new VarIntNumberConstOperator(value);
    }

    @Override
    public ConvertingUnaryOperator<Number, Number[], VarIntNumber, VarIntNumber[]> converter() {
        return this.converter;
    }

    @Override
    public NullaryOperator<VarIntNumber, VarIntNumber[]> nullary(NullaryOperator.Id id) {
        return this.nullary[id.ordinal()];
    }

    @Override
    public UnaryOperator<VarIntNumber, VarIntNumber[]> unary(UnaryOperator.Id id) {
        return this.unary[id.ordinal()];
    }

    @Override
    public BooleanUnaryOperator<VarIntNumber, VarIntNumber[]> booleanUnary(BooleanUnaryOperator.Id id) {
        return this.boolUnary[id.ordinal()];
    }

    @Override
    public IntUnaryOperator<VarIntNumber, VarIntNumber[]> intUnary(IntUnaryOperator.Id id) {
        return this.intUnary[id.ordinal()];
    }

    @Override
    public BinaryOperator<VarIntNumber, VarIntNumber[]> binary(BinaryOperator.Id id) {
        return this.binary[id.ordinal()];
    }

    @Override
    public BooleanBinaryOperator<VarIntNumber, VarIntNumber[]> booleanBinary(BooleanBinaryOperator.Id id) {
        return this.boolBinary[id.ordinal()];
    }

    @Override
    public IntBinaryOperator<VarIntNumber, VarIntNumber[]> intBinary(IntBinaryOperator.Id id) {
        return this.intBinary[id.ordinal()];
    }

    @Override
    public AggregatingUnaryOperator<VarIntNumber, VarIntNumber[]> aggregatingUnary(AggregatingUnaryOperator.Id id) {
        return this.aggUnary[id.ordinal()];
    }

    @Override
    public AggregatingBinaryOperator<VarIntNumber, VarIntNumber[]> aggregatingBinary(AggregatingBinaryOperator.Id id) {
        return this.aggBinary[id.ordinal()];
    }

    private static NullaryOperator<VarIntNumber, VarIntNumber[]>[] initNullary() {
        NullaryOperator[] ops = new NullaryOperator[NullaryOperator.Id.values().length];
        ops[NullaryOperator.Id.zero.ordinal()] = new VarIntNumberConstOperator(VarIntNumber.ZERO);
        ops[NullaryOperator.Id.one.ordinal()] = new VarIntNumberConstOperator(VarIntNumber.ONE);
        ops[NullaryOperator.Id.random.ordinal()] = new AbstractNullaryOperator<VarIntNumber, VarIntNumber[]>(){
            private final Random rnd = new Random();

            @Override
            public VarIntNumber operate() {
                return VarIntFactory.create(this.rnd.nextLong());
            }

            @Override
            public void operate(VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = VarIntFactory.create(this.rnd.nextLong());
            }
        };
        return VarIntOperators.checkComplete(ops, NullaryOperator.Id.values());
    }

    private static UnaryOperator<VarIntNumber, VarIntNumber[]>[] initUnary(final DivisionMode divMode) {
        UnaryOperator[] ops = new UnaryOperator[UnaryOperator.Id.values().length];
        ops[UnaryOperator.Id.identity.ordinal()] = new AbstractUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand) {
                return operand;
            }

            @Override
            public VarIntNumber operate(VarIntNumber[] src, int srcIndex) {
                return src[srcIndex];
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex];
            }
        };
        ops[UnaryOperator.Id.normalize.ordinal()] = ops[UnaryOperator.Id.identity.ordinal()];
        ops[UnaryOperator.Id.abs.ordinal()] = new AbstractUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand) {
                return operand.abs();
            }

            @Override
            public VarIntNumber operate(VarIntNumber[] src, int srcIndex) {
                return src[srcIndex].abs();
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].abs();
            }
        };
        ops[UnaryOperator.Id.negate.ordinal()] = new AbstractUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand) {
                return operand.negate();
            }

            @Override
            public VarIntNumber operate(VarIntNumber[] src, int srcIndex) {
                return src[srcIndex].negate();
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].negate();
            }
        };
        ops[UnaryOperator.Id.invert.ordinal()] = new AbstractUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand) {
                return divMode.divide(VarIntNumber.ONE, operand);
            }

            @Override
            public VarIntNumber operate(VarIntNumber[] src, int srcIndex) {
                return divMode.divide(VarIntNumber.ONE, src[srcIndex]);
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = divMode.divide(VarIntNumber.ONE, src[srcIndex]);
            }
        };
        ops[UnaryOperator.Id.square.ordinal()] = new AbstractUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand) {
                return operand.pow(2);
            }

            @Override
            public VarIntNumber operate(VarIntNumber[] src, int srcIndex) {
                return src[srcIndex].pow(2);
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].pow(2);
            }
        };
        return VarIntOperators.checkComplete(ops, UnaryOperator.Id.values());
    }

    private static IntUnaryOperator<VarIntNumber, VarIntNumber[]>[] initIntUnary() {
        IntUnaryOperator[] ops = new IntUnaryOperator[IntUnaryOperator.Id.values().length];
        ops[IntUnaryOperator.Id.signum.ordinal()] = new AbstractIntUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public int intOperate(VarIntNumber operand) {
                return operand.signum();
            }

            @Override
            public int intOperate(VarIntNumber[] operand, int index) {
                return operand[index].signum();
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, int[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum();
            }
        };
        return VarIntOperators.checkComplete(ops, IntUnaryOperator.Id.values());
    }

    private ConvertingUnaryOperator<Number, Number[], VarIntNumber, VarIntNumber[]> initConverter(final ConversionMode convMode) {
        return new ConvertingUnaryOperator<Number, Number[], VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(Number operand) {
                return convMode.convert(operand);
            }

            @Override
            public void operate(Number[] src, int srcIndex, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = convMode.convert(src[srcIndex]);
            }
        };
    }

    private static BooleanUnaryOperator<VarIntNumber, VarIntNumber[]>[] initBoolUnary() {
        BooleanUnaryOperator[] ops = new BooleanUnaryOperator[BooleanUnaryOperator.Id.values().length];
        ops[BooleanUnaryOperator.Id.isZero.ordinal()] = new AbstractBooleanUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand) {
                return VarIntNumber.ZERO.equals(operand);
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] src, int srcIndex) {
                return VarIntNumber.ZERO.equals(src[srcIndex]);
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = VarIntNumber.ZERO.equals(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isNonZero.ordinal()] = new AbstractBooleanUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand) {
                return !VarIntNumber.ZERO.equals(operand);
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] src, int srcIndex) {
                return !VarIntNumber.ZERO.equals(src[srcIndex]);
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !VarIntNumber.ZERO.equals(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isOne.ordinal()] = new AbstractBooleanUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand) {
                return VarIntNumber.ONE.equals(operand);
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] src, int srcIndex) {
                return VarIntNumber.ONE.equals(src[srcIndex]);
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = VarIntNumber.ONE.equals(src[srcIndex]);
            }
        };
        ops[BooleanUnaryOperator.Id.isPositive.ordinal()] = new AbstractBooleanUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand) {
                return operand.signum() > 0;
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] src, int srcIndex) {
                return src[srcIndex].signum() > 0;
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum() > 0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNegative.ordinal()] = new AbstractBooleanUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand) {
                return operand.signum() < 0;
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] src, int srcIndex) {
                return src[srcIndex].signum() < 0;
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum() < 0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNonPositive.ordinal()] = new AbstractBooleanUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand) {
                return operand.signum() <= 0;
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] src, int srcIndex) {
                return src[srcIndex].signum() <= 0;
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum() <= 0;
            }
        };
        ops[BooleanUnaryOperator.Id.isNonNegative.ordinal()] = new AbstractBooleanUnaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand) {
                return operand.signum() >= 0;
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] src, int srcIndex) {
                return src[srcIndex].signum() >= 0;
            }

            @Override
            public void operate(VarIntNumber[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum() >= 0;
            }
        };
        return VarIntOperators.checkComplete(ops, BooleanUnaryOperator.Id.values());
    }

    private static BinaryOperator<VarIntNumber, VarIntNumber[]>[] initBinary(final DivisionMode divMode) {
        BinaryOperator[] ops = new BinaryOperator[BinaryOperator.Id.values().length];
        ops[BinaryOperator.Id.add.ordinal()] = new AbstractBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.add(operand2);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].add(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.subtract.ordinal()] = new AbstractBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.subtract(operand2);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].subtract(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.multiply.ordinal()] = new AbstractBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.multiply(operand2);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].multiply(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.divide.ordinal()] = new AbstractBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand1, VarIntNumber operand2) {
                return divMode.divide(operand1, operand2);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = divMode.divide(operand1[index1], operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.min.ordinal()] = new AbstractBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.min(operand2);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].min(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.max.ordinal()] = new AbstractBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public VarIntNumber operate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.max(operand2);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, VarIntNumber[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].max(operand2[index2]);
            }
        };
        return VarIntOperators.checkComplete(ops, BinaryOperator.Id.values());
    }

    private static BooleanBinaryOperator<VarIntNumber, VarIntNumber[]>[] initBoolBinary() {
        BooleanBinaryOperator[] ops = new BooleanBinaryOperator[BooleanBinaryOperator.Id.values().length];
        ops[BooleanBinaryOperator.Id.less.ordinal()] = new AbstractBooleanBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.compareTo(operand2) < 0;
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) < 0;
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) < 0;
            }
        };
        ops[BooleanBinaryOperator.Id.lessOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.compareTo(operand2) <= 0;
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) <= 0;
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) <= 0;
            }
        };
        ops[BooleanBinaryOperator.Id.equal.ordinal()] = new AbstractBooleanBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.equals(operand2);
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2) {
                return operand1[index1].equals(operand2[index2]);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].equals(operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.unequal.ordinal()] = new AbstractBooleanBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand1, VarIntNumber operand2) {
                return !operand1.equals(operand2);
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2) {
                return !operand1[index1].equals(operand2[index2]);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !operand1[index1].equals(operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.greaterOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.compareTo(operand2) >= 0;
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) >= 0;
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) >= 0;
            }
        };
        ops[BooleanBinaryOperator.Id.greater.ordinal()] = new AbstractBooleanBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public boolean booleanOperate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.compareTo(operand2) > 0;
            }

            @Override
            public boolean booleanOperate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) > 0;
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) > 0;
            }
        };
        return VarIntOperators.checkComplete(ops, BooleanBinaryOperator.Id.values());
    }

    private static IntBinaryOperator<VarIntNumber, VarIntNumber[]>[] initIntBinary() {
        IntBinaryOperator[] ops = new IntBinaryOperator[IntBinaryOperator.Id.values().length];
        ops[IntBinaryOperator.Id.compare.ordinal()] = new AbstractIntBinaryOperator<VarIntNumber, VarIntNumber[]>(){

            @Override
            public int intOperate(VarIntNumber operand1, VarIntNumber operand2) {
                return operand1.compareTo(operand2);
            }

            @Override
            public int intOperate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]);
            }

            @Override
            public void operate(VarIntNumber[] operand1, int index1, VarIntNumber[] operand2, int index2, int[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]);
            }
        };
        return VarIntOperators.checkComplete(ops, IntBinaryOperator.Id.values());
    }

    private static AggregatingUnaryOperator<VarIntNumber, VarIntNumber[]>[] initAggUnary() {
        AggregatingUnaryOperator[] ops = new AggregatingUnaryOperator[AggregatingUnaryOperator.Id.values().length];
        ops[AggregatingUnaryOperator.Id.min.ordinal()] = new VarIntNumberAggregatingUnaryOperator(){

            public VarIntNumber operate(VarIntNumber[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return null;
                }
                VarIntNumber min = src[srcIndexFrom];
                int i = 1;
                while (i < length) {
                    min = min.min(src[srcIndexFrom + i]);
                    ++i;
                }
                return min;
            }

            public VarIntNumber operate(VarIntNumber[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return null;
                }
                VarIntNumber min = src[srcRowFrom][srcColFrom];
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        min = min.min(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return min;
            }
        };
        ops[AggregatingUnaryOperator.Id.max.ordinal()] = new VarIntNumberAggregatingUnaryOperator(){

            public VarIntNumber operate(VarIntNumber[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return null;
                }
                VarIntNumber max = src[srcIndexFrom];
                int i = 1;
                while (i < length) {
                    max = max.max(src[srcIndexFrom + i]);
                    ++i;
                }
                return max;
            }

            public VarIntNumber operate(VarIntNumber[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return null;
                }
                VarIntNumber max = src[srcRowFrom][srcColFrom];
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        max = max.max(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return max;
            }
        };
        ops[AggregatingUnaryOperator.Id.sum.ordinal()] = new VarIntNumberAggregatingUnaryOperator(){

            public VarIntNumber operate(VarIntNumber[] src, int srcIndexFrom, int length) {
                VarIntNumber sum = VarIntNumber.ZERO;
                int i = 0;
                while (i < length) {
                    sum = ((VarIntNumber)sum).add(src[srcIndexFrom + i]);
                    ++i;
                }
                return sum;
            }

            public VarIntNumber operate(VarIntNumber[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                VarIntNumber sum = VarIntNumber.ZERO;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = ((VarIntNumber)sum).add(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.prod.ordinal()] = new VarIntNumberAggregatingUnaryOperator(){

            public VarIntNumber operate(VarIntNumber[] src, int srcIndexFrom, int length) {
                VarIntNumber sum = VarIntNumber.ONE;
                int i = 0;
                while (i < length) {
                    sum = ((VarIntNumber)sum).multiply(src[srcIndexFrom + i]);
                    ++i;
                }
                return sum;
            }

            public VarIntNumber operate(VarIntNumber[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                VarIntNumber sum = VarIntNumber.ONE;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = ((VarIntNumber)sum).multiply(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.sumSquared.ordinal()] = new VarIntNumberAggregatingUnaryOperator(){

            public VarIntNumber operate(VarIntNumber[] src, int srcIndexFrom, int length) {
                VarIntNumber sum = VarIntNumber.ZERO;
                int i = 0;
                while (i < length) {
                    sum = ((VarIntNumber)sum).add(src[srcIndexFrom + i].pow(2));
                    ++i;
                }
                return sum;
            }

            public VarIntNumber operate(VarIntNumber[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                VarIntNumber sum = VarIntNumber.ZERO;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = ((VarIntNumber)sum).add(src[srcRowFrom + r][srcColFrom + c].pow(2));
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.normDivisor.ordinal()] = new VarIntNumberAggregatingUnaryOperator(){

            public VarIntNumber operate(VarIntNumber[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return VarIntNumber.ZERO;
                }
                VarIntNumber gcd = src[srcIndexFrom].abs();
                int i = 1;
                while (i < length) {
                    VarIntNumber val = src[srcIndexFrom + i];
                    if (gcd.equals(VarIntNumber.ONE)) break;
                    gcd = gcd.gcd(val);
                    ++i;
                }
                return gcd.signum() == 0 ? VarIntNumber.ZERO : gcd;
            }

            public VarIntNumber operate(VarIntNumber[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return VarIntNumber.ZERO;
                }
                VarIntNumber gcd = src[srcRowFrom][srcColFrom].abs();
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        VarIntNumber val = src[srcRowFrom + r][srcColFrom + c];
                        if (gcd.equals(VarIntNumber.ONE)) break;
                        gcd = gcd.gcd(val);
                        ++c;
                    }
                    ++r;
                }
                return gcd.signum() == 0 ? VarIntNumber.ZERO : gcd;
            }
        };
        ops[AggregatingUnaryOperator.Id.squeezeDivisor.ordinal()] = ops[AggregatingUnaryOperator.Id.normDivisor.ordinal()];
        return VarIntOperators.checkComplete(ops, AggregatingUnaryOperator.Id.values());
    }

    private static AggregatingBinaryOperator<VarIntNumber, VarIntNumber[]>[] initAggBinary() {
        AggregatingBinaryOperator[] ops = new AggregatingBinaryOperator[AggregatingBinaryOperator.Id.values().length];
        ops[AggregatingBinaryOperator.Id.innerProduct.ordinal()] = new VarIntNumberAggregatingBinaryOperator(){

            public VarIntNumber operate(VarIntNumber[] src1, int src1IndexFrom, VarIntNumber[] src2, int src2IndexFrom, int length) {
                VarIntNumber sum = VarIntNumber.ZERO;
                int i = 0;
                while (i < length) {
                    sum = ((VarIntNumber)sum).add(src1[src1IndexFrom + i].multiply(src2[src2IndexFrom + i]));
                    ++i;
                }
                return sum;
            }

            public VarIntNumber operate(VarIntNumber[][] src1, int src1RowFrom, int src1Col, VarIntNumber[] src2, int src2IndexFrom, int length) {
                VarIntNumber sum = VarIntNumber.ZERO;
                int i = 0;
                while (i < length) {
                    sum = ((VarIntNumber)sum).add(src1[src1RowFrom + i][src1Col].multiply(src2[src2IndexFrom + i]));
                    ++i;
                }
                return sum;
            }

            public VarIntNumber operate(VarIntNumber[][] src1, int src1RowFrom, int src1Col, VarIntNumber[][] src2, int src2RowFrom, int src2Col, int length) {
                VarIntNumber sum = VarIntNumber.ZERO;
                int i = 0;
                while (i < length) {
                    sum = ((VarIntNumber)sum).add(src1[src1RowFrom + i][src1Col].multiply(src2[src2RowFrom + i][src2Col]));
                    ++i;
                }
                return sum;
            }
        };
        return VarIntOperators.checkComplete(ops, AggregatingBinaryOperator.Id.values());
    }

    private static <A> A[] checkComplete(A[] arr, Enum[] ids) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == null) {
                throw new RuntimeException("internal error, implementation missing for " + arr.getClass().getComponentType().getName() + " for constant " + ids[i]);
            }
            ++i;
        }
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConversionMode {
        Exact{

            public VarIntNumber convert(Number value) {
                if (value instanceof VarIntNumber) {
                    return (VarIntNumber)value;
                }
                if (value instanceof BigDecimal) {
                    return VarIntFactory.create(((BigDecimal)value).toBigIntegerExact());
                }
                if (value instanceof BigFraction) {
                    return VarIntFactory.create(((BigFraction)value).toBigIntegerExact());
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof AtomicInteger || value instanceof AtomicLong) {
                    return VarIntFactory.create(value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return VarIntFactory.create(BigDecimal.valueOf(value.doubleValue()).toBigIntegerExact());
                }
                return VarIntFactory.create(value.toString());
            }
        }
        ,
        Truncate{

            public VarIntNumber convert(Number value) {
                if (value instanceof VarIntNumber) {
                    return (VarIntNumber)value;
                }
                if (value instanceof BigDecimal) {
                    return VarIntFactory.create(((BigDecimal)value).toBigInteger());
                }
                if (value instanceof BigFraction) {
                    return VarIntFactory.create(((BigFraction)value).toBigInteger());
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof AtomicInteger || value instanceof AtomicLong) {
                    return VarIntFactory.create(value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return VarIntFactory.create(BigDecimal.valueOf(value.doubleValue()).toBigInteger());
                }
                return VarIntFactory.create(value.toString());
            }
        }
        ,
        Round{

            public VarIntNumber convertBigDecimal(BigDecimal value) {
                return VarIntFactory.create(value.divide(BigDecimal.ONE, 0, RoundingMode.HALF_EVEN).toBigIntegerExact());
            }

            public VarIntNumber convert(Number value) {
                if (value instanceof VarIntNumber) {
                    return (VarIntNumber)value;
                }
                if (value instanceof BigDecimal) {
                    return this.convertBigDecimal((BigDecimal)value);
                }
                if (value instanceof BigFraction) {
                    return VarIntFactory.create(((BigFraction)value).toBigInteger(RoundingMode.HALF_EVEN));
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof AtomicInteger || value instanceof AtomicLong) {
                    return VarIntFactory.create(value.longValue());
                }
                if (value instanceof Double || value instanceof Float) {
                    return this.convertBigDecimal(BigDecimal.valueOf(value.doubleValue()));
                }
                return VarIntFactory.create(value.toString());
            }
        };


        public boolean conversionMightCauseException() {
            return Exact.equals((Object)this);
        }

        public abstract VarIntNumber convert(Number var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DivisionMode implements DivisionSupport
    {
        None{

            public VarIntNumber divide(VarIntNumber dividend, VarIntNumber divisor) {
                throw new ArithmeticException("division not supported");
            }
        }
        ,
        Exact{

            public VarIntNumber divide(VarIntNumber dividend, VarIntNumber divisor) {
                return dividend.divide(divisor, RoundingMode.UNNECESSARY);
            }
        }
        ,
        Integer{

            public VarIntNumber divide(VarIntNumber dividend, VarIntNumber divisor) {
                return dividend.divide(divisor);
            }
        }
        ,
        Round{

            public VarIntNumber divide(VarIntNumber dividend, VarIntNumber divisor) {
                return dividend.divide(divisor, RoundingMode.HALF_EVEN);
            }
        };


        @Override
        public boolean alwaysCausesException() {
            return None.equals(this);
        }

        @Override
        public boolean mightCauseException() {
            return None.equals(this) || Exact.equals(this);
        }

        @Override
        public boolean isExact() {
            return Exact.equals(this);
        }

        @Override
        public boolean isSufficientlyExact() {
            return Exact.equals(this);
        }

        public abstract VarIntNumber divide(VarIntNumber var1, VarIntNumber var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class VarIntNumberAggregatingBinaryOperator
    implements AggregatingBinaryOperator<VarIntNumber, VarIntNumber[]> {
        private VarIntNumberAggregatingBinaryOperator() {
        }

        @Override
        public void operate(VarIntNumber[] src1, int src1IndexFrom, VarIntNumber[] src2, int src2IndexFrom, VarIntNumber[] dst, int dstIndex, int length) {
            dst[dstIndex] = (VarIntNumber)this.operate(src1, src1IndexFrom, src2, src2IndexFrom, length);
        }

        public void operate(VarIntNumber[][] src1, int src1RowFrom, int src1Col, VarIntNumber[] src2, int src2IndexFrom, VarIntNumber[] dst, int dstIndex, int length) {
            dst[dstIndex] = (VarIntNumber)this.operate((A[])src1, src1RowFrom, src1Col, src2, src2IndexFrom, length);
        }

        public void operate(VarIntNumber[][] src1, int src1RowFrom, int src1Col, VarIntNumber[][] src2, int src2RowFrom, int src2Col, VarIntNumber[] dst, int dstIndex, int length) {
            dst[dstIndex] = (VarIntNumber)this.operate((A[])src1, src1RowFrom, src1Col, (A[])src2, src2RowFrom, src2Col, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class VarIntNumberAggregatingUnaryOperator
    implements AggregatingUnaryOperator<VarIntNumber, VarIntNumber[]> {
        private VarIntNumberAggregatingUnaryOperator() {
        }

        @Override
        public void operate(VarIntNumber[] src, int srcIndexFrom, int srcIndexTo, VarIntNumber[] dst, int dstIndex) {
            dst[dstIndex] = (VarIntNumber)this.operate(src, srcIndexFrom, srcIndexTo);
        }

        public void operate(VarIntNumber[][] src, int srcRowFrom, int srcColFrom, int rows, int cols, VarIntNumber[] dst, int dstIndex) {
            dst[dstIndex] = (VarIntNumber)this.operate((A[])src, srcRowFrom, srcColFrom, rows, cols);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VarIntNumberConstOperator
    extends AbstractNullaryOperator<VarIntNumber, VarIntNumber[]> {
        private final VarIntNumber value;

        public VarIntNumberConstOperator(VarIntNumber value) {
            this.value = value;
        }

        @Override
        public VarIntNumber operate() {
            return this.value;
        }

        @Override
        public void operate(VarIntNumber[] dst, int dstIndex) {
            dst[dstIndex] = this.value;
        }
    }
}

