/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.linalg;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.linalg.BasicLinAlgOperations;
import ch.javasoft.math.linalg.DefaultBasicLinAlgOperations;
import ch.javasoft.math.operator.TernaryOperator;
import ch.javasoft.util.IntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportBasicLinAlgOperations<N extends Number, A>
extends DefaultBasicLinAlgOperations<N, A> {
    public SupportBasicLinAlgOperations(NumberOperators<N, A> numberOps, ArrayOperations<A> arrayOps) {
        super(numberOps, arrayOps);
    }

    public SupportBasicLinAlgOperations(NumberArrayOperations<N, A> numberArrayOps) {
        super(numberArrayOps);
    }

    public SupportBasicLinAlgOperations(BasicLinAlgOperations<N, A> basicLinAlgOps) {
        super(basicLinAlgOps.getNumberArrayOperations());
    }

    @Override
    public A[] multiply(A[] m1, A[] m2) {
        int rows1 = this.arrayOps.getRowCount(m1);
        int cols1 = this.arrayOps.getColumnCount(m1);
        int rows2 = this.arrayOps.getRowCount(m2);
        int cols2 = this.arrayOps.getColumnCount(m2);
        if (cols1 != rows2) {
            throw new IllegalArgumentException("incompatible dimension for matrix multiplication: " + rows1 + "x" + cols1 + " * " + rows2 + "x" + cols2);
        }
        TernaryOperator mulAdd = this.expressionComposer.addToFree(this.expressionComposer.mul());
        A[] res = this.numberArrayOps.newZeroMatrix(rows1, cols2);
        IntArray indices = null;
        long[][] rsup = this.numberArrayOps.getMatrixSupportAsLongBits(m1);
        int c = 0;
        while (c < cols2) {
            long[] csup = this.numberArrayOps.getMatrixColumnSupportAsLongBits(m2, c);
            int r = 0;
            while (r < rows1) {
                indices = SupportBasicLinAlgOperations.toIndexArray(rsup[r], csup, indices);
                int i = 0;
                while (i < indices.length()) {
                    int index = indices.get(i);
                    mulAdd.operate(res[r], c, m1[r], index, m2[index], c, res[r], c);
                    ++i;
                }
                ++r;
            }
            ++c;
        }
        return res;
    }

    private static IntArray toIndexArray(long[] supportA, long[] supportB, IntArray indices) {
        if (indices == null) {
            indices = new IntArray();
        } else {
            indices.clear();
        }
        int i = 0;
        while (i < supportA.length) {
            long commonSupport = supportA[i] & supportB[i];
            while (commonSupport != 0L) {
                int index = Long.numberOfTrailingZeros(commonSupport);
                indices.add(index + i * 64);
                commonSupport ^= 1L << index;
            }
            ++i;
        }
        return indices;
    }

    @Override
    public A multiply(A[] m, A v) {
        int rows2;
        int rows1 = this.arrayOps.getRowCount(m);
        int cols1 = this.arrayOps.getColumnCount(m);
        if (cols1 != (rows2 = this.arrayOps.getLength(v))) {
            throw new IllegalArgumentException("incompatible dimension for matrix multiplication: " + rows1 + "x" + cols1 + " * " + rows2 + "x1");
        }
        TernaryOperator mulAdd = this.expressionComposer.addToFree(this.expressionComposer.mul());
        Object res = this.numberArrayOps.newZeroVector(rows1);
        IntArray indices = null;
        long[] csup = this.numberArrayOps.getVectorSupportAsLongBits(v);
        int r = 0;
        while (r < rows1) {
            long[] rsup = this.numberArrayOps.getMatrixRowSupportAsLongBits(m, r);
            indices = SupportBasicLinAlgOperations.toIndexArray(rsup, csup, indices);
            int i = 0;
            while (i < indices.length()) {
                int index = indices.get(i);
                mulAdd.operate(res, r, m[r], index, v, index, res, r);
                ++i;
            }
            ++r;
        }
        return res;
    }

    @Override
    public A multiply(A v, A[] m) {
        int cols1 = this.arrayOps.getLength(v);
        int rows2 = this.arrayOps.getRowCount(m);
        int cols2 = this.arrayOps.getColumnCount(m);
        if (cols1 != rows2) {
            throw new IllegalArgumentException("incompatible dimension for matrix multiplication: 1x" + cols1 + " * " + rows2 + "x" + cols2);
        }
        TernaryOperator mulAdd = this.expressionComposer.addToFree(this.expressionComposer.mul());
        Object res = this.numberArrayOps.newZeroVector(cols2);
        IntArray indices = null;
        long[] rsup = this.numberArrayOps.getVectorSupportAsLongBits(v);
        int c = 0;
        while (c < cols2) {
            long[] csup = this.numberArrayOps.getMatrixColumnSupportAsLongBits(m, c);
            indices = SupportBasicLinAlgOperations.toIndexArray(rsup, csup, indices);
            int i = 0;
            while (i < indices.length()) {
                int index = indices.get(i);
                mulAdd.operate(res, c, v, index, m[index], c, res, c);
                ++i;
            }
            ++c;
        }
        return res;
    }
}

