/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.linalg;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.Converter;
import ch.javasoft.math.array.ExpressionComposer;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.impl.DefaultNumberArrayOperations;
import ch.javasoft.math.linalg.BasicLinAlgOperations;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.UnaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBasicLinAlgOperations<N extends Number, A>
implements BasicLinAlgOperations<N, A> {
    protected final NumberArrayOperations<N, A> numberArrayOps;
    protected final NumberOperators<N, A> numberOps;
    protected final ArrayOperations<A> arrayOps;
    protected final ExpressionComposer<N, A> expressionComposer;

    public DefaultBasicLinAlgOperations(NumberOperators<N, A> numberOps, ArrayOperations<A> arrayOps) {
        this(new DefaultNumberArrayOperations<N, A>(numberOps, arrayOps));
    }

    public DefaultBasicLinAlgOperations(NumberArrayOperations<N, A> numberArrayOps) {
        this.numberArrayOps = numberArrayOps;
        this.numberOps = numberArrayOps.getNumberOperators();
        this.arrayOps = numberArrayOps.getArrayOperations();
        this.expressionComposer = new ExpressionComposer<N, A>(this.arrayOps, this.numberOps);
    }

    @Override
    public final NumberArrayOperations<N, A> getNumberArrayOperations() {
        return this.numberArrayOps;
    }

    @Override
    public final NumberOperators<N, A> getNumberOperators() {
        return this.numberOps;
    }

    @Override
    public final ArrayOperations<A> getArrayOperations() {
        return this.arrayOps;
    }

    @Override
    public <IN extends Number, IA> Converter<IN, IA, N, A> getConverterFrom(NumberArrayOperations<IN, IA> fromOps) {
        return this.numberArrayOps.getConverterFrom(fromOps);
    }

    @Override
    public <RN extends Number, RA> Converter<N, A, RN, RA> getConverterTo(NumberArrayOperations<RN, RA> toOps) {
        return this.numberArrayOps.getConverterTo(toOps);
    }

    @Override
    public ExpressionComposer<N, A> getExpressionComposer() {
        return this.expressionComposer;
    }

    @Override
    public Class<N> numberClass() {
        return this.numberArrayOps.numberClass();
    }

    @Override
    public Class<A> arrayClass() {
        return this.numberArrayOps.arrayClass();
    }

    @Override
    public A abs(A vector) {
        return this.numberArrayOps.applyToEachElement(vector, this.numberOps.unary(UnaryOperator.Id.abs));
    }

    @Override
    public A[] abs(A[] matrix) {
        return this.numberArrayOps.applyToEachElement(matrix, this.numberOps.unary(UnaryOperator.Id.abs));
    }

    @Override
    public A add(A v, A u) {
        return this.numberArrayOps.applyToElementByElement(v, u, this.numberOps.binary(BinaryOperator.Id.add));
    }

    @Override
    public A[] add(A[] m1, A[] m2) {
        return this.numberArrayOps.applyToElementByElement(m1, m2, this.numberOps.binary(BinaryOperator.Id.add));
    }

    @Override
    public A divideElementByElement(A v, A u) {
        return this.numberArrayOps.applyToElementByElement(v, u, this.numberOps.binary(BinaryOperator.Id.divide));
    }

    @Override
    public A[] divideElementByElement(A[] m1, A[] m2) {
        return this.numberArrayOps.applyToElementByElement(m1, m2, this.numberOps.binary(BinaryOperator.Id.divide));
    }

    @Override
    public N get(A vector, int index) {
        return (N)((Number)this.numberOps.unary(UnaryOperator.Id.identity).operate(vector, index));
    }

    @Override
    public N get(A[] matrix, int row, int col) {
        return (N)((Number)this.numberOps.unary(UnaryOperator.Id.identity).operate(matrix[row], col));
    }

    @Override
    public A[] multiply(A[] m1, A[] m2) {
        int rows1 = this.arrayOps.getRowCount(m1);
        int cols1 = this.arrayOps.getColumnCount(m1);
        int rows2 = this.arrayOps.getRowCount(m2);
        int cols2 = this.arrayOps.getColumnCount(m2);
        if (cols1 != rows2) {
            throw new IllegalArgumentException("incompatible dimension for matrix multiplication: " + rows1 + "x" + cols1 + " * " + rows2 + "x" + cols2);
        }
        AggregatingBinaryOperator<N, A> inner = this.numberOps.aggregatingBinary(AggregatingBinaryOperator.Id.innerProduct);
        A[] res = this.arrayOps.newMatrix(rows1, cols2);
        int r = 0;
        while (r < rows1) {
            int c = 0;
            while (c < cols2) {
                inner.operate(m2, 0, c, m1[r], 0, res[r], c, cols1);
                ++c;
            }
            ++r;
        }
        return res;
    }

    @Override
    public A multiply(A[] m, A v) {
        int rows2;
        int rows1 = this.arrayOps.getRowCount(m);
        int cols1 = this.arrayOps.getColumnCount(m);
        if (cols1 != (rows2 = this.arrayOps.getLength(v))) {
            throw new IllegalArgumentException("incompatible dimension for matrix multiplication: " + rows1 + "x" + cols1 + " * " + rows2 + "x1");
        }
        AggregatingBinaryOperator<N, A> inner = this.numberOps.aggregatingBinary(AggregatingBinaryOperator.Id.innerProduct);
        A res = this.arrayOps.newVector(rows1);
        int r = 0;
        while (r < rows1) {
            inner.operate(m[r], 0, v, 0, res, r, cols1);
            ++r;
        }
        return res;
    }

    @Override
    public A multiply(A v, A[] m) {
        int cols1 = this.arrayOps.getLength(v);
        int rows2 = this.arrayOps.getRowCount(m);
        int cols2 = this.arrayOps.getColumnCount(m);
        if (cols1 != rows2) {
            throw new IllegalArgumentException("incompatible dimension for matrix multiplication: 1x" + cols1 + " * " + rows2 + "x" + cols2);
        }
        AggregatingBinaryOperator<N, A> inner = this.numberOps.aggregatingBinary(AggregatingBinaryOperator.Id.innerProduct);
        A res = this.arrayOps.newVector(cols2);
        int c = 0;
        while (c < cols2) {
            inner.operate(m, 0, c, v, 0, res, c, cols1);
            ++c;
        }
        return res;
    }

    @Override
    public A multiplyElementByElement(A v, A u) {
        return this.numberArrayOps.applyToElementByElement(v, u, this.numberOps.binary(BinaryOperator.Id.multiply));
    }

    @Override
    public A[] multiplyElementByElement(A[] m1, A[] m2) {
        return this.numberArrayOps.applyToElementByElement(m1, m2, this.numberOps.binary(BinaryOperator.Id.multiply));
    }

    @Override
    public N multiplyInner(A v, A u) {
        return this.numberArrayOps.applyTo(v, u, this.numberOps.aggregatingBinary(AggregatingBinaryOperator.Id.innerProduct));
    }

    @Override
    public A[] multiplyOuter(A v, A u) {
        int rows = this.arrayOps.getLength(u);
        int cols = this.arrayOps.getLength(v);
        A[] res = this.arrayOps.newMatrix(rows, cols);
        BinaryOperator<N, A> mul = this.numberOps.binary(BinaryOperator.Id.multiply);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                mul.operate(u, r, v, c, res[r], c);
                ++c;
            }
            ++r;
        }
        return res;
    }

    @Override
    public A negate(A vector) {
        return this.numberArrayOps.applyToEachElement(vector, this.numberOps.unary(UnaryOperator.Id.negate));
    }

    @Override
    public A[] negate(A[] matrix) {
        return this.numberArrayOps.applyToEachElement(matrix, this.numberOps.unary(UnaryOperator.Id.negate));
    }

    @Override
    public int signum(A vector, int index) {
        return this.numberArrayOps.evalInt(vector, index, this.numberOps.intUnary(IntUnaryOperator.Id.signum));
    }

    @Override
    public int signum(A[] matrix, int row, int col) {
        return this.numberArrayOps.evalInt(matrix[row], col, this.numberOps.intUnary(IntUnaryOperator.Id.signum));
    }

    @Override
    public A subtract(A v, A u) {
        return this.numberArrayOps.applyToElementByElement(v, u, this.numberOps.binary(BinaryOperator.Id.subtract));
    }

    @Override
    public A[] subtract(A[] m1, A[] m2) {
        return this.numberArrayOps.applyToElementByElement(m1, m2, this.numberOps.binary(BinaryOperator.Id.subtract));
    }
}

