/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.parse;

import ch.javasoft.math.BigFraction;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataType {
    Fractional(BigFraction[].class){

        public BigFraction[] asVector(BigFraction[] vector) {
            return vector;
        }

        public Void asLooserVector(DataType desired, Object vector) throws ClassCastException {
            throw new IllegalArgumentException((Object)((Object)desired) + " must be looser than " + (Object)((Object)this));
        }

        public BigFraction getMatrixValue(Object[] matrix, int row, int col) {
            BigFraction[][] mx = 1.castMatrix(BigFraction[].class, matrix);
            return mx[row][col];
        }

        public int getVectorLength(Object vector) throws ClassCastException {
            BigFraction[] vec = 1.castVector(BigFraction[].class, vector);
            return vec.length;
        }
    }
    ,
    BigInt(BigInteger[].class){

        public BigInteger[] asVector(BigFraction[] vector) {
            BigInteger[] converted = new BigInteger[vector.length];
            int i = 0;
            while (i < converted.length) {
                converted[i] = vector[i].toBigInteger(RoundingMode.UNNECESSARY);
                ++i;
            }
            return converted;
        }

        public BigFraction[] asLooserVector(DataType desired, Object vector) throws ClassCastException {
            BigInteger[] vals = 2.castVector(BigInteger[].class, vector);
            if (Fractional.equals((Object)desired)) {
                BigFraction[] conv = new BigFraction[vals.length];
                int i = 0;
                while (i < conv.length) {
                    conv[i] = BigFraction.valueOf(vals[i]);
                    ++i;
                }
                return conv;
            }
            throw new IllegalArgumentException((Object)((Object)desired) + " must be looser than " + (Object)((Object)this));
        }

        public BigInteger getMatrixValue(Object[] matrix, int row, int col) {
            BigInteger[][] mx = 2.castMatrix(BigInteger[].class, matrix);
            return mx[row][col];
        }

        public int getVectorLength(Object vector) throws ClassCastException {
            BigInteger[] vec = 2.castVector(BigInteger[].class, vector);
            return vec.length;
        }
    }
    ,
    Long(long[].class){

        public long[] asVector(BigFraction[] vector) {
            long[] converted = new long[vector.length];
            int i = 0;
            while (i < converted.length) {
                BigInteger bigint = vector[i].toBigInteger(RoundingMode.UNNECESSARY);
                if (bigint.bitLength() >= 64) {
                    throw new ArithmeticException("integer too large for long: " + bigint);
                }
                converted[i] = bigint.longValue();
                ++i;
            }
            return converted;
        }

        public Number[] asLooserVector(DataType desired, Object vector) throws ClassCastException {
            long[] vals = 3.castVector(long[].class, vector);
            if (Fractional.equals((Object)desired)) {
                Number[] conv = new BigFraction[vals.length];
                int i = 0;
                while (i < conv.length) {
                    conv[i] = BigFraction.valueOf(vals[i]);
                    ++i;
                }
                return conv;
            }
            if (BigInt.equals((Object)desired)) {
                Number[] conv = new BigInteger[vals.length];
                int i = 0;
                while (i < conv.length) {
                    conv[i] = BigInteger.valueOf(vals[i]);
                    ++i;
                }
                return conv;
            }
            throw new IllegalArgumentException((Object)((Object)desired) + " must be looser than " + (Object)((Object)this));
        }

        public Long getMatrixValue(Object[] matrix, int row, int col) {
            long[][] mx = 3.castMatrix(long[].class, matrix);
            return mx[row][col];
        }

        public int getVectorLength(Object vector) throws ClassCastException {
            long[] vec = 3.castVector(long[].class, vector);
            return vec.length;
        }
    }
    ,
    Int(int[].class){

        public int[] asVector(BigFraction[] vector) {
            int[] converted = new int[vector.length];
            int i = 0;
            while (i < converted.length) {
                BigInteger bigint = vector[i].toBigInteger(RoundingMode.UNNECESSARY);
                if (bigint.bitLength() >= 32) {
                    throw new ArithmeticException("integer too large for int: " + bigint);
                }
                converted[i] = bigint.intValue();
                ++i;
            }
            return converted;
        }

        public Object asLooserVector(DataType desired, Object vector) throws ClassCastException {
            int[] vals = 4.castVector(int[].class, vector);
            if (Fractional.equals((Object)desired)) {
                BigFraction[] conv = new BigFraction[vals.length];
                int i = 0;
                while (i < conv.length) {
                    conv[i] = BigFraction.valueOf(vals[i]);
                    ++i;
                }
                return conv;
            }
            if (BigInt.equals((Object)desired)) {
                BigInteger[] conv = new BigInteger[vals.length];
                int i = 0;
                while (i < conv.length) {
                    conv[i] = BigInteger.valueOf(vals[i]);
                    ++i;
                }
                return conv;
            }
            if (Long.equals((Object)desired)) {
                long[] conv = new long[vals.length];
                int i = 0;
                while (i < conv.length) {
                    conv[i] = vals[i];
                    ++i;
                }
                return conv;
            }
            throw new IllegalArgumentException((Object)((Object)desired) + " must be looser than " + (Object)((Object)this));
        }

        public Integer getMatrixValue(Object[] matrix, int row, int col) {
            int[][] mx = 4.castMatrix(int[].class, matrix);
            return mx[row][col];
        }

        public int getVectorLength(Object vector) throws ClassCastException {
            int[] vec = 4.castVector(int[].class, vector);
            return vec.length;
        }
    };

    private final Class vectorClass;

    private DataType(Class vectorClass) {
        this.vectorClass = vectorClass;
    }

    public Class getVectorClass() {
        return this.vectorClass;
    }

    public abstract Object asVector(BigFraction[] var1);

    public static DataType getTightestFit(BigFraction value) {
        if (value.isInteger()) {
            BigInteger bi = value.toBigInteger();
            int bitlen = bi.bitLength();
            if (bitlen >= 64) {
                return BigInt;
            }
            if (bitlen >= 32) {
                return Long;
            }
            return Int;
        }
        return Fractional;
    }

    public static DataType getTightestType() {
        return DataType.values()[DataType.values().length - 1];
    }

    public static DataType getLoosestType() {
        return DataType.values()[0];
    }

    public static DataType getLoosestType(DataType ... types) {
        int min = DataType.values().length;
        int i = 0;
        while (i < types.length) {
            min = Math.min(min, types[i].ordinal());
            ++i;
        }
        return DataType.values()[min];
    }

    public boolean isTighterThan(DataType other) {
        return this.ordinal() > other.ordinal();
    }

    public abstract int getVectorLength(Object var1) throws ClassCastException;

    public abstract Number getMatrixValue(Object[] var1, int var2, int var3);

    public abstract Object asLooserVector(DataType var1, Object var2) throws ClassCastException;

    public Object[] toMatrix(List<? extends Object> data) throws ArrayStoreException {
        int rows = data.size();
        int cols = rows == 0 ? 0 : this.getVectorLength(data.get(0));
        Object[] matrix = (Object[])Array.newInstance(this.vectorClass.getComponentType(), rows, cols);
        int r = 0;
        while (r < rows) {
            matrix[r] = data.get(r);
            ++r;
        }
        return matrix;
    }

    public static <A> A castVector(Class<A> arrayClass, Object vector) throws ClassCastException {
        if (arrayClass.isAssignableFrom(vector.getClass())) {
            return (A)vector;
        }
        throw new ClassCastException(String.valueOf(arrayClass.getName()) + ": " + vector);
    }

    public static <A> A[] castMatrix(Class<A> arrayClass, Object[] matrix) throws ClassCastException {
        if (arrayClass.isAssignableFrom(matrix.getClass().getComponentType())) {
            return matrix;
        }
        throw new ClassCastException(String.valueOf(arrayClass.getName()) + "[]: " + matrix);
    }

    /* synthetic */ DataType(String string, int n, Class clazz, DataType dataType) {
        this(clazz);
    }
}

