/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math;

import ch.javasoft.math.BigFraction;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class BigMath {
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal FOUR = BigDecimal.valueOf(4L);
    private static final double LOG10_OF_2 = Math.log10(2.0);

    public static BigDecimal pi(int scale) {
        BigDecimal a = BigDecimal.ONE;
        BigDecimal b = BigDecimal.ONE.divide(BigMath.sqrt(TWO, scale), scale, RoundingMode.HALF_EVEN);
        BigDecimal t = new BigDecimal(0.25);
        BigDecimal x = BigDecimal.ONE;
        while (!a.equals(b)) {
            BigDecimal y = a;
            a = a.add(b).divide(TWO, scale, RoundingMode.HALF_EVEN);
            b = BigMath.sqrt(b.multiply(y), scale);
            t = t.subtract(x.multiply(y.subtract(a).multiply(y.subtract(a))));
            x = x.multiply(TWO);
        }
        return a.add(b).multiply(a.add(b)).divide(t.multiply(FOUR), scale, RoundingMode.HALF_EVEN);
    }

    public static long sqrtBabylonian(long num) {
        long old;
        if (num <= 1L) {
            return num;
        }
        long log = 63 - Long.numberOfLeadingZeros(num);
        long res = 1L << (int)(log >>> 1);
        while ((old = res) - (res = res + num / res >>> 1) < -1L && old - res > 1L) {
        }
        if (old - res != 0L && Math.abs(num - old * old) < Math.abs(num - res * res)) {
            return old;
        }
        return res;
    }

    public static long sqrt(long num) {
        long res = 0L;
        for (int curLog = 32; curLog > 0; --curLog) {
            long resTimes2toCurLog = res << curLog;
            if (num <= resTimes2toCurLog) continue;
            long resAdd = 1L << curLog;
            long nextNum = num - resTimes2toCurLog - (resAdd << curLog);
            if (nextNum <= 0L) continue;
            num = nextNum;
            res |= resAdd;
        }
        return res;
    }

    public static int sqrt(int num) {
        int res = 0;
        for (int curLog = 16; curLog > 0; --curLog) {
            int resTimes2toCurLog = res << curLog;
            if (num <= resTimes2toCurLog) continue;
            int resAdd = 1 << curLog;
            int nextNum = num - resTimes2toCurLog - (resAdd << curLog);
            if (nextNum <= 0) continue;
            num = nextNum;
            res |= resAdd;
        }
        return res;
    }

    public static BigDecimal sqrt(BigDecimal num, int scale) {
        BigDecimal x0 = BigDecimal.ZERO;
        BigDecimal x1 = BigMath.estimateSqrt(num);
        while (!x0.equals(x1)) {
            x0 = x1;
            x1 = num.divide(x0, scale, RoundingMode.HALF_EVEN);
            x1 = x1.add(x0);
            x1 = x1.divide(TWO, scale, RoundingMode.HALF_EVEN);
        }
        return x1;
    }

    public static BigDecimal sqrt(BigInteger num, int scale) {
        return BigMath.sqrt(BigFraction.valueOf(num), scale);
    }

    public static BigDecimal sqrt(BigFraction num, int scale) {
        if (num.isZero()) {
            return BigDecimal.ZERO;
        }
        BigFraction x0 = BigFraction.ZERO;
        BigFraction x1 = BigMath.estimateSqrt(num);
        int binaryScale = 1 + (int)((double)scale / LOG10_OF_2);
        int i = 0;
        while (i < scale) {
            x0 = x1;
            x1 = num.divide(x0);
            x1 = x1.add(x0);
            int numLen = x1.getNumerator().bitLength();
            int denLen = x1.getDenominator().bitLength();
            int scaleDown = denLen - Math.max(0, numLen - denLen) - binaryScale;
            x1 = scaleDown > 0 ? new BigFraction(x1.getNumerator().shiftRight(scaleDown + 1), x1.getDenominator().shiftRight(scaleDown)) : x1.shiftRight(1);
            i += 2;
        }
        return x1.toBigDecimal(scale, RoundingMode.HALF_EVEN);
    }

    public static double sqrt(BigDecimal num) {
        int intScale = num.precision() - num.scale();
        int scale = 1 + (int)(52.0 * LOG10_OF_2 - (double)(intScale / 2) + 1.0);
        return BigMath.sqrt(num, scale).doubleValue();
    }

    public static double sqrt(BigInteger num) {
        return BigMath.sqrt(BigFraction.valueOf(num));
    }

    public static double sqrt(BigFraction num) {
        int numBits = num.getNumerator().bitLength();
        int denBits = num.getDenominator().bitLength();
        int intBits = numBits - denBits;
        int scale = 1 + (int)((double)(52 - intBits / 2) * LOG10_OF_2 + 1.0);
        return BigMath.sqrt(num, scale).doubleValue();
    }

    private static BigInteger estimateSqrt(BigInteger val) {
        return val.shiftRight(val.bitLength() / 2);
    }

    private static BigDecimal estimateSqrt(BigDecimal val) {
        return new BigDecimal(BigMath.estimateSqrt(val.unscaledValue()), val.scale() / 2);
    }

    private static BigFraction estimateSqrt(BigFraction val) {
        return new BigFraction(BigMath.estimateSqrt(val.getNumerator()), BigMath.estimateSqrt(val.getDenominator()));
    }
}

