/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.variable;

import ch.javasoft.jsmat.common.MatClass;
import ch.javasoft.jsmat.common.MatType;
import ch.javasoft.jsmat.primitive.MatInt32;
import ch.javasoft.jsmat.primitive.MatUtf8;
import java.io.DataOutput;
import java.io.IOException;

public abstract class MatVariable {
    protected static final String DEFAULT_NAME = "@";
    protected MatClass mMatClass;
    protected int[] mDims;
    private int mAttriubtes;

    public MatVariable(MatClass matClass, int[] dims) {
        this.mMatClass = matClass;
        this.mDims = dims;
        long dim = this.mDims.length == 0 ? 0 : this.mDims[0];
        int i = 1;
        while (i < this.mDims.length) {
            dim *= (long)this.mDims[i];
            ++i;
        }
        if (dim > Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow for matrix size: " + dim);
        }
    }

    public int getDimLength() {
        int dim = this.mDims.length == 0 ? 0 : this.mDims[0];
        int i = 1;
        while (i < this.mDims.length) {
            dim *= this.mDims[i];
            ++i;
        }
        return dim;
    }

    protected void checkValueLength(int len) throws IllegalArgumentException {
        if (len != this.getDimLength()) {
            throw new IllegalArgumentException("expected " + this.getDimLength() + " values, but found " + len);
        }
    }

    public int getFlags() {
        int flags = this.mMatClass.type & 0xFF | this.mAttriubtes & 0xFFFFFF00;
        return flags;
    }

    protected abstract int getRawDataSize();

    protected void checkRawDataSizeOverflow(int typeSize) throws ArithmeticException {
        long size = (long)typeSize * (long)this.getDimLength();
        if (size > Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow for raw data size: " + size);
        }
    }

    public int getSize(String name) {
        int flagSize = new MatInt32(new int[2]).getSize();
        int dimSize = new MatInt32(this.mDims).getSize();
        int namSize = new MatUtf8(name).getSize();
        int rawSize = this.getRawDataSize();
        return flagSize + dimSize + namSize + rawSize;
    }

    protected void writeStart(String name, DataOutput out) throws IOException {
        out.writeInt(MatType.MATRIX.type);
        out.writeInt(this.getSize(name));
        this.writeFlags(out);
        new MatInt32(this.mDims).write(out);
        new MatUtf8(name).write(out);
    }

    private void writeFlags(DataOutput out) throws IOException {
        int maxNZ = 0;
        new MatInt32(new int[]{this.getFlags(), maxNZ}).write(out);
    }
}

