/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.primitive;

import ch.javasoft.jsmat.common.MatType;
import java.io.DataOutput;
import java.io.IOException;

public abstract class MatPrimitive {
    private final MatType mMatType;

    public MatPrimitive(MatType type) {
        this.mMatType = type;
    }

    public int getRawDataSize() {
        return this.getUnitSize() * this.getArrayLength();
    }

    public abstract int getArrayLength();

    public static void writeStart(MatType mType, DataOutput out, int rawDataSize) throws IOException {
        out.writeInt(mType.type);
        out.writeInt(rawDataSize);
    }

    protected abstract void writeBody(DataOutput var1) throws IOException;

    public static void writeEnd(MatType mType, DataOutput out, int rawDataSize) throws IOException {
        int padding = MatPrimitive.getPaddingSize(rawDataSize, mType.size, false);
        out.write(new byte[padding]);
    }

    public int getSize() {
        int rawSize = this.getRawDataSize();
        int padding = this.getPaddingSize(rawSize, false);
        return 8 + rawSize + padding;
    }

    public void write(DataOutput out) throws IOException {
        int rawDataSize = this.getRawDataSize();
        MatPrimitive.writeStart(this.mMatType, out, rawDataSize);
        this.writeBody(out);
        MatPrimitive.writeEnd(this.mMatType, out, rawDataSize);
    }

    private int getPaddingSize(int size, boolean compressed) {
        return MatPrimitive.getPaddingSize(size, this.getUnitSize(), compressed);
    }

    private static int getPaddingSize(int size, int unitSize, boolean compressed) {
        int b;
        int padding = !compressed ? ((b = size / unitSize % (8 / unitSize) * unitSize) != 0 ? 8 - b : 0) : ((b = size / unitSize % (4 / unitSize) * unitSize) != 0 ? 4 - b : 0);
        return padding;
    }

    protected int getUnitSize() {
        return this.mMatType.size;
    }
}

